/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.block.blockentity;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.block.blockentity.IItemHandlerBEBase;
import com.teammetallurgy.aquaculture.init.AquaBlockEntities;
import com.teammetallurgy.aquaculture.init.AquaSounds;
import com.teammetallurgy.aquaculture.inventory.container.TackleBoxContainer;
import com.teammetallurgy.aquaculture.item.AquaFishingRodItem;
import com.teammetallurgy.aquaculture.item.BaitItem;
import com.teammetallurgy.aquaculture.item.HookItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TackleBoxBlockEntity
extends IItemHandlerBEBase
implements MenuProvider {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
            TackleBoxBlockEntity.playSound(level, pos, state, (SoundEvent)AquaSounds.TACKLE_BOX_OPEN.get());
        }

        protected void m_142289_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
            TackleBoxBlockEntity.playSound(level, pos, state, (SoundEvent)AquaSounds.TACKLE_BOX_CLOSE.get());
        }

        protected void m_142148_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, int i, int i1) {
            TackleBoxBlockEntity.this.signalOpenCount(level, pos, state, i, i1);
        }

        protected boolean m_142718_(Player player) {
            return player.f_36096_ instanceof TackleBoxContainer;
        }
    };
    private final ChestLidController lidController = new ChestLidController();

    public TackleBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AquaBlockEntities.TACKLE_BOX.get(), pos, state);
    }

    @Override
    @Nonnull
    protected IItemHandler createItemHandler() {
        return new ItemStackHandler(17){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TackleBoxBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                Item item = stack.m_41720_();
                if (slot == 0) {
                    return item instanceof AquaFishingRodItem;
                }
                return TackleBoxBlockEntity.canBePutInTackleBox(stack);
            }
        };
    }

    public static boolean canBePutInTackleBox(@Nonnull ItemStack stack) {
        Item item = stack.m_41720_();
        boolean isDyeable = item instanceof DyeableLeatherItem;
        return stack.m_204117_(AquacultureAPI.Tags.TACKLE_BOX) || item instanceof HookItem || item instanceof BaitItem || stack.m_204117_(AquacultureAPI.Tags.FISHING_LINE) && isDyeable || stack.m_204117_(AquacultureAPI.Tags.BOBBER) && isDyeable;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, @Nonnull Inventory playerInventory, @Nonnull Player player) {
        return new TackleBoxContainer(windowID, this.f_58858_, playerInventory);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, TackleBoxBlockEntity tackleBox) {
        tackleBox.lidController.m_155374_();
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int i, int i1) {
        Block block = state.m_60734_();
        level.m_7696_(pos, block, 1, i1);
    }

    static void playSound(Level level, BlockPos pos, BlockState state, SoundEvent sound) {
        if (level != null) {
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, sound, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }

    public boolean m_7531_(int p_59114_, int p_59115_) {
        if (p_59114_ == 1) {
            this.lidController.m_155377_(p_59115_ > 0);
            return true;
        }
        return super.m_7531_(p_59114_, p_59115_);
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public float getOpenNess(float partialTicks) {
        return this.lidController.m_155375_(partialTicks);
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }
}

