/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.Tags;

public class BiomeTagPredicate {
    private static final BiomeTagPredicate ANY = new BiomeTagPredicate(MinMaxBounds.Doubles.f_154779_, MinMaxBounds.Doubles.f_154779_, MinMaxBounds.Doubles.f_154779_, new ArrayList<TagKey<Biome>>(), new ArrayList<TagKey<Biome>>(), false);
    private static final HashMap<CheckType, Set<Holder<Biome>>> CACHE = new HashMap();
    public static final List<TagKey<Biome>> INVALID_TYPES = Arrays.asList(BiomeTags.f_207612_, BiomeTags.f_215818_, Tags.Biomes.IS_VOID);
    private final MinMaxBounds.Doubles x;
    private final MinMaxBounds.Doubles y;
    private final MinMaxBounds.Doubles z;
    private final List<TagKey<Biome>> include;
    private final List<TagKey<Biome>> exclude;
    private final boolean and;

    public BiomeTagPredicate(MinMaxBounds.Doubles x, MinMaxBounds.Doubles y, MinMaxBounds.Doubles z, List<TagKey<Biome>> include, List<TagKey<Biome>> exclude, boolean and) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.include = include;
        this.exclude = exclude;
        this.and = and;
    }

    public boolean test(ServerLevel serverLevel, float x, float y, float z) {
        if (!this.x.m_154810_((double)x)) {
            return false;
        }
        if (!this.y.m_154810_((double)y)) {
            return false;
        }
        if (!this.z.m_154810_((double)z)) {
            return false;
        }
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        if (serverLevel.m_46749_(pos)) {
            Optional biomeHolder;
            Biome biome = (Biome)serverLevel.m_204166_(pos).m_203334_();
            Registry biomeRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256952_);
            Optional resourceKey = biomeRegistry.m_7854_((Object)biome);
            if (resourceKey.isPresent() && (biomeHolder = biomeRegistry.m_203636_((ResourceKey)resourceKey.get())).isPresent()) {
                CheckType checkType = CheckType.getOrCreate(this.include, this.exclude, this.and);
                Set<Holder<Biome>> validBiomes = CACHE.get(checkType);
                if (validBiomes == null) {
                    validBiomes = BiomeTagPredicate.getValidBiomes(serverLevel, checkType);
                    CACHE.put(checkType, validBiomes);
                }
                return validBiomes.contains(biomeHolder.get());
            }
        }
        return false;
    }

    public static Set<Holder<Biome>> getValidBiomes(ServerLevel serverLevel, CheckType checkType) {
        return BiomeTagPredicate.getValidBiomes(serverLevel, checkType.getInclude(), checkType.getExclude(), checkType.isAnd());
    }

    public static Set<Holder<Biome>> getValidBiomes(ServerLevel serverLevel, List<TagKey<Biome>> includeList, List<TagKey<Biome>> excludeList, boolean and) {
        HashSet<Holder<Biome>> biomes = new HashSet<Holder<Biome>>();
        Optional optionalBiomeRegistry = serverLevel.m_9598_().m_6632_(Registries.f_256952_);
        if (optionalBiomeRegistry.isPresent()) {
            Registry biomeRegistry = (Registry)optionalBiomeRegistry.get();
            if (includeList.isEmpty() && !excludeList.isEmpty()) {
                includeList.addAll(biomeRegistry.m_203613_().collect(Collectors.toSet()));
                excludeList.addAll(INVALID_TYPES);
            }
            if (and) {
                for (TagKey<Biome> tagKey : includeList) {
                    BiomeTagPredicate.getBiomeFromTag((Registry<Biome>)biomeRegistry, tagKey).forEach(a -> {
                        List tags = a.getTagKeys().collect(Collectors.toList());
                        int beforeTagCount = tags.size();
                        tags.removeAll(includeList);
                        int afterTagCount = tags.size();
                        if (beforeTagCount - afterTagCount == includeList.size()) {
                            biomes.add((Holder<Biome>)a);
                        }
                    });
                }
            } else {
                for (TagKey<Biome> tagKey : includeList) {
                    BiomeTagPredicate.getBiomeFromTag((Registry<Biome>)biomeRegistry, tagKey).forEach(biomes::add);
                }
            }
            if (!excludeList.isEmpty()) {
                for (TagKey<Biome> tagKey : excludeList) {
                    BiomeTagPredicate.getBiomeFromTag((Registry<Biome>)biomeRegistry, tagKey).forEach(biomes::remove);
                }
            }
        }
        return biomes;
    }

    public static Iterable<Holder<Biome>> getBiomeFromTag(Registry<Biome> biomeRegistry, TagKey<Biome> tagKey) {
        return biomeRegistry.m_206058_(tagKey);
    }

    public JsonElement serialize() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject object = new JsonObject();
        if (!(this.x.m_55327_() && this.y.m_55327_() && this.z.m_55327_())) {
            JsonObject posObj = new JsonObject();
            posObj.add("x", this.x.m_55328_());
            posObj.add("y", this.y.m_55328_());
            posObj.add("z", this.z.m_55328_());
            object.add("position", (JsonElement)posObj);
        }
        if (this.include != null) {
            for (TagKey<Biome> tagKey : this.include) {
                object.add("include", (JsonElement)object.getAsJsonArray(tagKey.f_203868_().toString()));
            }
        }
        if (this.exclude != null) {
            for (TagKey<Biome> tagKey : this.exclude) {
                object.add("exclude", (JsonElement)object.getAsJsonArray(tagKey.f_203868_().toString()));
            }
        }
        object.addProperty("add", Boolean.valueOf(GsonHelper.m_13855_((JsonObject)object, (String)"add", (boolean)false)));
        return object;
    }

    public static BiomeTagPredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonObject location = GsonHelper.m_13918_((JsonElement)element, (String)"location");
            JsonObject position = GsonHelper.m_13841_((JsonObject)location, (String)"position", (JsonObject)new JsonObject());
            MinMaxBounds.Doubles x = MinMaxBounds.Doubles.m_154791_((JsonElement)position.get("x"));
            MinMaxBounds.Doubles y = MinMaxBounds.Doubles.m_154791_((JsonElement)position.get("y"));
            MinMaxBounds.Doubles z = MinMaxBounds.Doubles.m_154791_((JsonElement)position.get("z"));
            ArrayList<TagKey<Biome>> include = new ArrayList<TagKey<Biome>>();
            if (location.has("include")) {
                JsonArray includeArray = GsonHelper.m_13933_((JsonObject)location, (String)"include");
                for (int entry = 0; entry < includeArray.size(); ++entry) {
                    String name = includeArray.get(entry).getAsString().toLowerCase(Locale.ROOT);
                    TagKey type = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(name));
                    include.add((TagKey<Biome>)type);
                }
            }
            ArrayList<TagKey<Biome>> exclude = new ArrayList<TagKey<Biome>>();
            if (location.has("exclude")) {
                JsonArray excludeArray = GsonHelper.m_13933_((JsonObject)location, (String)"exclude");
                for (int entry = 0; entry < excludeArray.size(); ++entry) {
                    String name = excludeArray.get(entry).getAsString().toLowerCase(Locale.ROOT);
                    TagKey type = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(name));
                    exclude.add((TagKey<Biome>)type);
                }
            }
            boolean and = false;
            if (location.has("and")) {
                and = GsonHelper.m_13912_((JsonObject)location, (String)"and");
            }
            return new BiomeTagPredicate(x, y, z, include, exclude, and);
        }
        return ANY;
    }

    public static class CheckType {
        private static final Map<Integer, CheckType> BY_NAME = new TreeMap<Integer, CheckType>();
        private final List<TagKey<Biome>> include;
        private final List<TagKey<Biome>> exclude;
        private final boolean and;

        private CheckType(List<TagKey<Biome>> include, List<TagKey<Biome>> exclude, boolean and) {
            this.include = include;
            this.exclude = exclude;
            this.and = and;
            BY_NAME.put(this.hashCode(), this);
        }

        public List<TagKey<Biome>> getInclude() {
            return this.include;
        }

        public List<TagKey<Biome>> getExclude() {
            return this.exclude;
        }

        public boolean isAnd() {
            return this.and;
        }

        public static CheckType getOrCreate(List<TagKey<Biome>> include, List<TagKey<Biome>> exclude, boolean and) {
            CheckType checkType = BY_NAME.get(Objects.hash(include, exclude, and));
            if (checkType == null) {
                checkType = new CheckType(include, exclude, and);
            }
            return checkType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CheckType checkType = (CheckType)o;
            return this.and == checkType.and && Objects.equals(this.include, checkType.include) && Objects.equals(this.exclude, checkType.exclude);
        }

        public int hashCode() {
            return Objects.hash(this.include, this.exclude, this.and);
        }
    }
}

