/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api;

import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.api.recipe.PotionIngredient;
import com.hollingsworth.arsnouveau.api.scrying.IScryer;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.common.mixin.PotionRecipeMixin;
import com.hollingsworth.arsnouveau.common.spell.validation.StandardSpellValidator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.fml.loading.FMLPaths;

public class ArsNouveauAPI {
    public static boolean ENABLE_DEBUG_NUMBERS = false;
    private ConcurrentHashMap<ResourceLocation, IScryer> scryerMap = new ConcurrentHashMap();
    private Set<RecipeType<? extends IEnchantingRecipe>> enchantingRecipeTypes = ConcurrentHashMap.newKeySet();
    private ISpellValidator craftingSpellValidator;
    private ISpellValidator castingSpellValidator;
    private List<IEnchantingRecipe> enchantingApparatusRecipes = new ArrayList<IEnchantingRecipe>();
    private List<BrewingRecipe> brewingRecipes = new ArrayList<BrewingRecipe>();
    private static final ArsNouveauAPI INSTANCE = new ArsNouveauAPI();

    public Set<RecipeType<? extends IEnchantingRecipe>> getEnchantingRecipeTypes() {
        return this.enchantingRecipeTypes;
    }

    public List<IEnchantingRecipe> getEnchantingApparatusRecipes(Level world) {
        ArrayList<IEnchantingRecipe> recipes = new ArrayList<IEnchantingRecipe>(this.enchantingApparatusRecipes);
        RecipeManager manager = world.m_7465_();
        ArrayList recipesByType = new ArrayList();
        for (RecipeType<? extends IEnchantingRecipe> type : this.enchantingRecipeTypes) {
            recipesByType.addAll(manager.m_44013_(type));
        }
        recipes.addAll(recipesByType);
        return recipes;
    }

    public List<BrewingRecipe> getAllPotionRecipes() {
        if (this.brewingRecipes.isEmpty()) {
            BrewingRecipeRegistry.getRecipes().forEach(ib -> {
                if (ib instanceof BrewingRecipe) {
                    BrewingRecipe brewingRecipe = (BrewingRecipe)ib;
                    this.brewingRecipes.add(brewingRecipe);
                }
            });
            for (PotionBrewing.Mix<Potion> mix : PotionRecipeMixin.mixList()) {
                this.brewingRecipes.add(new BrewingRecipe((Ingredient)PotionIngredient.fromPotion((Potion)mix.f_43532_.get()), mix.f_43533_, PotionIngredient.fromPotion((Potion)mix.f_43534_.get()).getStack()));
            }
        }
        return this.brewingRecipes;
    }

    public ISpellValidator getSpellCraftingSpellValidator() {
        if (this.craftingSpellValidator == null) {
            this.craftingSpellValidator = new StandardSpellValidator(false);
        }
        return this.craftingSpellValidator;
    }

    public ISpellValidator getSpellCastingSpellValidator() {
        if (this.castingSpellValidator == null) {
            this.castingSpellValidator = new StandardSpellValidator(true);
        }
        return this.castingSpellValidator;
    }

    @Nullable
    public IScryer getScryer(ResourceLocation id) {
        return this.scryerMap.get(id);
    }

    public boolean registerScryer(IScryer scryer) {
        this.scryerMap.put(scryer.getRegistryName(), scryer);
        return true;
    }

    public void onResourceReload() {
        this.brewingRecipes = new ArrayList<BrewingRecipe>();
    }

    private ArsNouveauAPI() {
    }

    public static ArsNouveauAPI getInstance() {
        return INSTANCE;
    }

    static {
        FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get().resolve("ars_nouveau"));
    }
}

