/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.gui.ScreenUtils;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class GuiEntityInfoHUD {
    public static final IGuiOverlay OVERLAY = GuiEntityInfoHUD::renderOverlay;
    public static int hoverTicks = 0;
    public static Object lastHovered = null;
    public static final Color VANILLA_TOOLTIP_BORDER_1 = new Color(0x505000FF, true);
    public static final Color VANILLA_TOOLTIP_BORDER_2 = new Color(1344798847, true);
    public static final Color VANILLA_TOOLTIP_BACKGROUND = new Color(-267386864, true);

    public static void renderOverlay(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        PoseStack poseStack = graphics.m_280168_();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        HitResult objectMouseOver = mc.f_91077_;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        BlockPos hovering = null;
        if (objectMouseOver instanceof BlockHitResult) {
            BlockHitResult hitResult = (BlockHitResult)objectMouseOver;
            hovering = hitResult.m_82425_();
            var13_12 = mc.f_91073_.m_7702_(hitResult.m_82425_());
            if (var13_12 instanceof ITooltipProvider) {
                ITooltipProvider iTooltipProvider = (ITooltipProvider)var13_12;
                iTooltipProvider.getTooltip(tooltip);
            }
        } else if (objectMouseOver instanceof EntityHitResult) {
            EntityHitResult result = (EntityHitResult)objectMouseOver;
            var13_12 = result.m_82443_();
            if (var13_12 instanceof ITooltipProvider) {
                ITooltipProvider iTooltipProvider = (ITooltipProvider)var13_12;
                iTooltipProvider.getTooltip(tooltip);
            }
            if ((var13_12 = result.m_82443_()) instanceof ItemFrame) {
                ItemFrame itemFrame = (ItemFrame)var13_12;
                ItemScroll.ItemScrollData data = new ItemScroll.ItemScrollData(itemFrame.m_31822_());
                for (ItemStack i : data.getItems()) {
                    tooltip.add(i.m_41786_());
                }
            }
            hovering = result.m_82443_();
        }
        if (hovering == null || lastHovered != null && !lastHovered.equals(hovering)) {
            lastHovered = null;
            hoverTicks = 0;
        }
        hoverTicks = lastHovered == null || lastHovered.equals(hovering) ? ++hoverTicks : 0;
        lastHovered = hovering;
        if (tooltip.isEmpty()) {
            return;
        }
        poseStack.m_85836_();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : tooltip) {
            int textLineWidth = mc.f_91062_.m_92852_(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2;
            tooltipHeight += (tooltip.size() - 1) * 10;
        }
        int n = (Integer)Config.TOOLTIP_X_OFFSET.get();
        int posX = width / 2 + n;
        int posY = height / 2 + (Integer)Config.TOOLTIP_Y_OFFSET.get();
        posX = Math.min(posX, width - tooltipTextWidth - 20);
        posY = Math.min(posY, height - tooltipHeight - 20);
        float fade = Mth.m_14036_((float)(((float)hoverTicks + partialTicks) / 12.0f), (float)0.0f, (float)1.0f);
        Color colorBackground = VANILLA_TOOLTIP_BACKGROUND.scaleAlpha(0.75f);
        Color colorBorderTop = VANILLA_TOOLTIP_BORDER_1;
        Color colorBorderBot = VANILLA_TOOLTIP_BORDER_2;
        if (fade < 1.0f) {
            poseStack.m_252880_((1.0f - fade) * Math.signum((float)n + 0.5f) * 4.0f, 0.0f, 0.0f);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }
        GuiEntityInfoHUD.drawHoveringText(ItemStack.f_41583_, graphics, tooltip, posX, posY, width, height, -1, colorBackground.getRGB(), colorBorderTop.getRGB(), colorBorderBot.getRGB(), mc.f_91062_);
        poseStack.m_85849_();
    }

    public static void drawHoveringText(GuiGraphics mStack, List<? extends FormattedText> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, Font font) {
        GuiEntityInfoHUD.drawHoveringText(mStack, textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, -267386864, 0x505000FF, 1344798847, font);
    }

    public static void drawHoveringText(GuiGraphics mStack, List<? extends FormattedText> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, Font font) {
        GuiEntityInfoHUD.drawHoveringText(ItemStack.f_41583_, mStack, textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, backgroundColor, borderColorStart, borderColorEnd, font);
    }

    public static void drawHoveringText(@NotNull ItemStack stack, GuiGraphics mStack, List<? extends FormattedText> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, Font font) {
        GuiEntityInfoHUD.drawHoveringText(stack, mStack, textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, -267386864, 0x505000FF, 1344798847, font);
    }

    public static void drawHoveringText(@NotNull ItemStack stack, GuiGraphics graphics, List<? extends FormattedText> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, Font font) {
        int n;
        if (textLines.isEmpty()) {
            return;
        }
        PoseStack pStack = graphics.m_280168_();
        List list = ForgeHooksClient.gatherTooltipComponents((ItemStack)stack, textLines, (Optional)stack.m_150921_(), (int)mouseX, (int)screenWidth, (int)screenHeight, (Font)font);
        RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, graphics, mouseX, mouseY, screenWidth, screenHeight, font, list, DefaultTooltipPositioner.f_262752_);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        mouseX = event.getX();
        mouseY = event.getY();
        screenWidth = event.getScreenWidth();
        screenHeight = event.getScreenHeight();
        font = event.getFont();
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : textLines) {
            int textLineWidth = font.m_92852_(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        boolean bl = true;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<? extends FormattedText> wrappedTextLines = new ArrayList<FormattedText>();
            for (int i = 0; i < textLines.size(); ++i) {
                FormattedText textLine = textLines.get(i);
                List wrappedLine = font.m_92865_().m_92414_(textLine, tooltipTextWidth, Style.f_131099_);
                if (i == 0) {
                    n = wrappedLine.size();
                }
                for (FormattedText line : wrappedLine) {
                    int lineWidth = font.m_92852_(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add((FormattedText)line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > n) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        int zLevel = 400;
        RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, graphics, tooltipX, tooltipY, font, backgroundColor, borderColorStart, borderColorEnd, list);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        backgroundColor = colorEvent.getBackgroundStart();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        pStack.m_85836_();
        Matrix4f mat = pStack.m_85850_().m_252922_();
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        ScreenUtils.drawGradientRect((Matrix4f)mat, (int)400, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
        MultiBufferSource.BufferSource renderType = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        pStack.m_85837_(0.0, 0.0, 400.0);
        for (int lineNumber = 0; lineNumber < list.size(); ++lineNumber) {
            ClientTooltipComponent line = (ClientTooltipComponent)list.get(lineNumber);
            if (line != null) {
                line.m_142440_(font, tooltipX, tooltipY, mat, renderType);
            }
            if (lineNumber + 1 == n) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        renderType.m_109911_();
        pStack.m_85849_();
        RenderSystem.enableDepthTest();
    }
}

