/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.api.client.CosmeticRenderUtil;
import com.hollingsworth.arsnouveau.api.item.ICosmeticItem;
import com.hollingsworth.arsnouveau.client.registry.ShaderRegistry;
import com.hollingsworth.arsnouveau.client.renderer.entity.StarbuncleModel;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class StarbuncleRenderer
extends GeoEntityRenderer<Starbuncle> {
    public static MultiBufferSource.BufferSource cosmeticBuffer = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(256));

    public StarbuncleRenderer(EntityRendererProvider.Context manager) {
        super(manager, (GeoModel)new StarbuncleModel());
    }

    public void renderFinal(PoseStack poseStack, Starbuncle animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderRecursively(PoseStack stack, Starbuncle animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        ICosmeticItem cosmetic;
        Item item;
        super.renderRecursively(stack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (bone.getName().equals("item")) {
            stack.m_85836_();
            RenderUtils.translateToPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
            stack.m_85837_(0.0, -0.1, 0.0);
            stack.m_85841_(0.75f, 0.75f, 0.75f);
            ItemStack itemstack = animatable.getHeldStack();
            if (animatable.dynamicBehavior != null) {
                itemstack = animatable.dynamicBehavior.getStackForRender();
            }
            if (!itemstack.m_41619_()) {
                Minecraft.m_91087_().m_91291_().m_269128_(itemstack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, stack, (MultiBufferSource)cosmeticBuffer, animatable.f_19853_, (int)animatable.m_20097_().m_121878_());
            }
            cosmeticBuffer.m_109911_();
            stack.m_85849_();
        }
        if ((item = animatable.getCosmeticItem().m_41720_()) instanceof ICosmeticItem && (cosmetic = (ICosmeticItem)item).getBone().equals(bone.getName())) {
            CosmeticRenderUtil.renderCosmetic(bone, stack, (MultiBufferSource)cosmeticBuffer, animatable, packedLight);
            cosmeticBuffer.m_109911_();
        }
    }

    public ResourceLocation getTextureLocation(Starbuncle entity) {
        return entity.getTexture(entity);
    }

    public RenderType getRenderType(Starbuncle animatable, ResourceLocation textureLocation, @Nullable MultiBufferSource bufferSource, float partialTick) {
        if (animatable.m_7755_().getString().equals("Splonk")) {
            return ShaderRegistry.blamed(textureLocation, true);
        }
        if (animatable.m_7755_().getString().equals("Bailey")) {
            return ShaderRegistry.rainbowEntity(textureLocation, new ResourceLocation("ars_nouveau", "textures/entity/starbuncle_mask.png"), true);
        }
        return RenderType.m_110458_((ResourceLocation)textureLocation);
    }
}

