/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.common.base.Preconditions;
import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.common.datagen.BlockStatesDatagen;
import com.hollingsworth.arsnouveau.common.items.FamiliarScript;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.lib.LibBlockNames;
import com.hollingsworth.arsnouveau.common.util.RegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "ars_nouveau", existingFileHelper);
    }

    protected void registerModels() {
        for (Supplier<Glyph> supplier : GlyphRegistry.getGlyphItemMap().values()) {
            try {
                if (!supplier.get().spellPart.getRegistryName().m_135827_().equals("ars_nouveau")) continue;
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(supplier.get().spellPart.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.spellTexture(supplier.get()));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("No texture for " + (Object)((Object)supplier.get()));
            }
        }
        for (RitualTablet ritualTablet : RitualRegistry.getRitualItemMap().values()) {
            try {
                if (!ritualTablet.ritual.getRegistryName().m_135827_().equals("ars_nouveau")) continue;
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(ritualTablet.ritual.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemTexture(ritualTablet));
            }
            catch (Exception e) {
                System.out.println("No texture for " + ritualTablet);
            }
        }
        for (FamiliarScript familiarScript : FamiliarRegistry.getFamiliarScriptMap().values()) {
            try {
                if (!familiarScript.familiar.getRegistryName().m_135827_().equals("ars_nouveau")) continue;
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(familiarScript.familiar.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemTexture(familiarScript));
            }
            catch (Exception e) {
                System.out.println("No texture for " + familiarScript);
            }
        }
        for (PerkItem perkItem : PerkRegistry.getPerkItemMap().values()) {
            try {
                if (!perkItem.perk.getRegistryName().m_135827_().equals("ars_nouveau")) continue;
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(perkItem.perk.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemTexture(perkItem));
            }
            catch (Exception e) {
                System.out.println("No texture for " + perkItem);
            }
        }
        ((ItemModelBuilder)this.getBuilder("stripped_blue_archwood_log")).parent(BlockStatesDatagen.getUncheckedModel("stripped_blue_archwood_log"));
        ((ItemModelBuilder)this.getBuilder("stripped_blue_archwood_wood")).parent(BlockStatesDatagen.getUncheckedModel("stripped_blue_archwood_wood"));
        ((ItemModelBuilder)this.getBuilder("stripped_green_archwood_log")).parent(BlockStatesDatagen.getUncheckedModel("stripped_green_archwood_log"));
        ((ItemModelBuilder)this.getBuilder("stripped_green_archwood_wood")).parent(BlockStatesDatagen.getUncheckedModel("stripped_green_archwood_wood"));
        ((ItemModelBuilder)this.getBuilder("stripped_red_archwood_log")).parent(BlockStatesDatagen.getUncheckedModel("stripped_red_archwood_log"));
        ((ItemModelBuilder)this.getBuilder("stripped_red_archwood_wood")).parent(BlockStatesDatagen.getUncheckedModel("stripped_red_archwood_wood"));
        ((ItemModelBuilder)this.getBuilder("stripped_purple_archwood_log")).parent(BlockStatesDatagen.getUncheckedModel("stripped_purple_archwood_log"));
        ((ItemModelBuilder)this.getBuilder("stripped_purple_archwood_wood")).parent(BlockStatesDatagen.getUncheckedModel("stripped_purple_archwood_wood"));
        ((ItemModelBuilder)this.getBuilder("source_gem_block")).parent(BlockStatesDatagen.getUncheckedModel("source_gem_block"));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(ItemsRegistry.EXPERIENCE_GEM.getRegistryName())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemTexture(ItemsRegistry.EXPERIENCE_GEM.get()));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(ItemsRegistry.GREATER_EXPERIENCE_GEM.getRegistryName())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemTexture(ItemsRegistry.GREATER_EXPERIENCE_GEM.get()));
        ((ItemModelBuilder)this.getBuilder("red_sbed")).parent(BlockStatesDatagen.getUncheckedModel("red_sbed"));
        ((ItemModelBuilder)this.getBuilder("blue_sbed")).parent(BlockStatesDatagen.getUncheckedModel("blue_sbed"));
        ((ItemModelBuilder)this.getBuilder("green_sbed")).parent(BlockStatesDatagen.getUncheckedModel("green_sbed"));
        ((ItemModelBuilder)this.getBuilder("yellow_sbed")).parent(BlockStatesDatagen.getUncheckedModel("yellow_sbed"));
        ((ItemModelBuilder)this.getBuilder("orange_sbed")).parent(BlockStatesDatagen.getUncheckedModel("orange_sbed"));
        ((ItemModelBuilder)this.getBuilder("purple_sbed")).parent(BlockStatesDatagen.getUncheckedModel("purple_sbed"));
        ((ItemModelBuilder)this.getBuilder("agronomic_sourcelink")).parent(BlockStatesDatagen.getUncheckedModel("agronomic_sourcelink"));
        ((ItemModelBuilder)this.getBuilder("volcanic_sourcelink")).parent(BlockStatesDatagen.getUncheckedModel("volcanic_sourcelink"));
        ((ItemModelBuilder)this.getBuilder("vitalic_sourcelink")).parent(BlockStatesDatagen.getUncheckedModel("vitalic_sourcelink"));
        ((ItemModelBuilder)this.getBuilder("mycelial_sourcelink")).parent(BlockStatesDatagen.getUncheckedModel("mycelial_sourcelink"));
        ((ItemModelBuilder)this.getBuilder("alchemical_sourcelink")).parent(BlockStatesDatagen.getUncheckedModel("alchemical_sourcelink"));
        this.blockAsItem("mendosteen_pod");
        this.blockAsItem("bastion_pod");
        this.blockAsItem("frostaya_pod");
        this.blockAsItem("bombegranate_pod");
        this.itemUnchecked(ItemsRegistry.ALCHEMISTS_CROWN);
        this.stateUnchecked("potion_diffuser");
        for (Iterator<Object> iterator : LibBlockNames.DECORATIVE_SOURCESTONE) {
            ((ItemModelBuilder)this.getBuilder((String)((Object)iterator))).parent(BlockStatesDatagen.getUncheckedModel(iterator));
            ((ItemModelBuilder)this.getBuilder(iterator + "_slab")).parent(BlockStatesDatagen.getUncheckedModel(iterator + "_slab"));
            ((ItemModelBuilder)this.getBuilder(iterator + "_stairs")).parent(BlockStatesDatagen.getUncheckedModel(iterator + "_stairs"));
        }
        ((ItemModelBuilder)this.getBuilder("void_prism")).parent(BlockStatesDatagen.getUncheckedModel("void_prism"));
        ((ItemModelBuilder)this.getBuilder("falseweave")).parent(BlockStatesDatagen.getUncheckedModel("falseweave"));
        ((ItemModelBuilder)this.getBuilder("mirrorweave")).parent(BlockStatesDatagen.getUncheckedModel("mirrorweave"));
        ((ItemModelBuilder)this.getBuilder("ghostweave")).parent(BlockStatesDatagen.getUncheckedModel("ghostweave"));
        ((ItemModelBuilder)this.getBuilder("magebloom_block")).parent(BlockStatesDatagen.getUncheckedModel("magebloom_block"));
        ((ItemModelBuilder)this.getBuilder("sconce")).parent(BlockStatesDatagen.getUncheckedModel("sconce"));
        ((ItemModelBuilder)this.getBuilder("archwood_sconce")).parent(BlockStatesDatagen.getUncheckedModel("archwood_sconce"));
        ((ItemModelBuilder)this.getBuilder("sourcestone_sconce")).parent(BlockStatesDatagen.getUncheckedModel("sourcestone_sconce"));
        ((ItemModelBuilder)this.getBuilder("polished_sconce")).parent(BlockStatesDatagen.getUncheckedModel("polished_sconce"));
        ((ItemModelBuilder)this.getBuilder("ritual_brazier")).parent(BlockStatesDatagen.getUncheckedModel("ritual_brazier"));
        ((ItemModelBuilder)this.getBuilder("item_detector")).parent(BlockStatesDatagen.getUncheckedModel("item_detector"));
        this.itemUnchecked(ItemsRegistry.WILD_HUNT);
        this.itemUnchecked(ItemsRegistry.SOUND_OF_GLASS);
    }

    public void blockAsItem(String s) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("ars_nouveau:" + s)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemTexture(s));
    }

    public void blockAsItem(RegistryWrapper<? extends Block> block) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(block.getRegistryName())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemTexture(block.get()));
    }

    public void itemUnchecked(RegistryWrapper<? extends Item> item) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getRegistryName())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemTexture(item.get()));
    }

    public void stateUnchecked(String name) {
        ((ItemModelBuilder)this.getBuilder(name)).parent(BlockStatesDatagen.getUncheckedModel(name));
    }

    public String m_6055_() {
        return "Ars Nouveau Item Models";
    }

    private ResourceLocation registryName(Item item) {
        return (ResourceLocation)Preconditions.checkNotNull((Object)RegistryHelper.getRegistryName(item), (String)"Item %s has a null registry name", (Object)item);
    }

    private ResourceLocation registryName(Block item) {
        return (ResourceLocation)Preconditions.checkNotNull((Object)RegistryHelper.getRegistryName(item), (String)"Item %s has a null registry name", (Object)item);
    }

    private ResourceLocation itemTexture(String item) {
        return new ResourceLocation("ars_nouveau", "item/" + item);
    }

    private ResourceLocation itemTexture(Item item) {
        ResourceLocation name = this.registryName(item);
        return new ResourceLocation(name.m_135827_(), "item/" + name.m_135815_());
    }

    private ResourceLocation itemTexture(Block item) {
        ResourceLocation name = this.registryName(item);
        return new ResourceLocation(name.m_135827_(), "item/" + name.m_135815_());
    }

    private ResourceLocation spellTexture(Item item) {
        ResourceLocation name = this.registryName(item);
        return new ResourceLocation(name.m_135827_(), "item/" + name.m_135815_().replace("glyph_", ""));
    }
}

