/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.api.event.DispelEvent;
import com.hollingsworth.arsnouveau.api.event.ManaRegenCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.event.SpellResolveEvent;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.block.tile.GhostWeaveTile;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectInvisibility;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class ArsEvents {
    @SubscribeEvent
    public static void costCalc(SpellCostCalcEvent e) {
        if (e.context.getCasterTool().m_41619_()) {
            return;
        }
        IWrappedCaster iWrappedCaster = e.context.getCaster();
        if (iWrappedCaster instanceof PlayerCaster) {
            PlayerCaster livingCaster = (PlayerCaster)iWrappedCaster;
            if (e.context.getCasterTool().m_150930_((Item)ItemsRegistry.CASTER_TOME.get())) {
                int maxMana = ManaUtil.getMaxMana(livingCaster.player);
                e.currentCost = e.currentCost > maxMana ? maxMana : (e.currentCost /= 2);
            }
        }
    }

    @SubscribeEvent
    public static void regenCalc(ManaRegenCalcEvent e) {
        if (e.getEntity() != null && e.getEntity().m_21023_((MobEffect)ModPotions.HEX_EFFECT.get())) {
            e.setRegen(e.getRegen() / 2.0);
        }
    }

    @SubscribeEvent
    public static void spellCalc(SpellDamageEvent.Pre e) {
        if (e.caster == null) {
            return;
        }
        if (e.caster.m_21023_((MobEffect)ModPotions.SPELL_DAMAGE_EFFECT.get())) {
            e.damage += 1.5f * (float)(e.caster.m_21124_((MobEffect)ModPotions.SPELL_DAMAGE_EFFECT.get()).m_19564_() + 1);
        }
        if (e.caster.m_21204_().m_22171_((Attribute)PerkAttributes.SPELL_DAMAGE_BONUS.get())) {
            e.damage = (float)((double)e.damage + e.caster.m_21133_((Attribute)PerkAttributes.SPELL_DAMAGE_BONUS.get()));
        }
    }

    @SubscribeEvent
    public static void spellResolve(SpellResolveEvent.Post e) {
        BlockHitResult blockHitResult;
        BlockEntity blockEntity;
        HitResult hitResult;
        if (e.spell.recipe.contains(EffectInvisibility.INSTANCE) && (hitResult = e.rayTraceResult) instanceof BlockHitResult && (blockEntity = e.world.m_7702_((blockHitResult = (BlockHitResult)hitResult).m_82425_())) instanceof GhostWeaveTile) {
            GhostWeaveTile ghostWeaveTile = (GhostWeaveTile)blockEntity;
            ghostWeaveTile.setVisibility(true);
        }
    }

    @SubscribeEvent
    public static void dispelEvent(DispelEvent e) {
        BlockHitResult blockHitResult;
        HitResult hitResult = e.rayTraceResult;
        if (hitResult instanceof BlockHitResult && (hitResult = e.world.m_7702_((blockHitResult = (BlockHitResult)hitResult).m_82425_())) instanceof GhostWeaveTile) {
            GhostWeaveTile ghostWeaveTile = (GhostWeaveTile)hitResult;
            ghostWeaveTile.setVisibility(false);
        }
    }
}

