/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.client.renderer.item.MobJarItemRenderer;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MobJarItem
extends BlockItem
implements GeoItem {
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MobJarItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            MobJarItemRenderer renderer = new MobJarItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_7373_(stack, pLevel, pTooltip, pFlag);
        if (pLevel == null) {
            return;
        }
        Entity entity = MobJarItem.fromItem(stack, pLevel);
        if (entity == null) {
            return;
        }
        pTooltip.add(entity.m_5446_());
        if (entity.m_8077_()) {
            MutableComponent name = entity.m_6095_().m_20676_().m_6881_();
            name.m_130940_(ChatFormatting.GRAY);
            pTooltip.add((Component)name);
        }
    }

    public static Entity fromItem(ItemStack stack, Level level) {
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag blockTag = stack.m_41783_().m_128469_("BlockEntityTag");
        CompoundTag entityTag = blockTag.m_128469_("entityTag");
        if (entityTag.m_128456_()) {
            return null;
        }
        return MobJarTile.loadEntityFromTag(level, entityTag);
    }
}

