/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.tomes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.SpellSoundRegistry;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.sound.SpellSound;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CasterTomeData
implements Recipe<Container> {
    ResourceLocation id;
    String name;
    List<ResourceLocation> spell;
    ResourceLocation type;
    String flavorText;
    public int particleColor;
    ConfiguredSpellSound sound;

    public CasterTomeData(ResourceLocation id, String name, List<ResourceLocation> spell, ResourceLocation type, String flavorText, int particleColor, ConfiguredSpellSound sound) {
        this.name = name;
        this.spell = spell;
        this.id = id;
        this.type = type;
        this.flavorText = flavorText;
        this.particleColor = particleColor;
        this.sound = sound;
    }

    public static ItemStack makeTome(Item tome, String name, Spell spell, String flavorText) {
        ItemStack stack = tome.m_7968_();
        ISpellCaster spellCaster = CasterUtil.getCaster(stack);
        spellCaster.setSpell(spell);
        stack.m_41714_((Component)Component.m_237113_((String)name).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE).m_131155_(Boolean.valueOf(true))));
        spellCaster.setFlavorText(flavorText);
        return stack;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return false;
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        Item tomeType = (Item)ForgeRegistries.ITEMS.getValue(this.type);
        if (tomeType == null) {
            tomeType = ItemsRegistry.CASTER_TOME.m_5456_();
        }
        Spell spell = new Spell();
        spell.name = this.name;
        if (this.particleColor != -1) {
            spell.color = ParticleColor.fromInt(this.particleColor);
        }
        for (ResourceLocation rl : this.spell) {
            AbstractSpellPart part = GlyphRegistry.getSpellpartMap().get(rl);
            if (part == null) continue;
            spell.recipe.add(part);
        }
        spell.sound = this.sound;
        return CasterTomeData.makeTome(tomeType, this.name, spell, this.flavorText);
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.CASTER_TOME_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.CASTER_TOME_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public JsonElement toJson() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_nouveau:caster_tome");
        jsonobject.addProperty("tome_type", this.type.toString());
        jsonobject.addProperty("name", this.name);
        jsonobject.addProperty("flavour_text", this.flavorText);
        jsonobject.addProperty("color", (Number)this.particleColor);
        JsonArray array = new JsonArray();
        for (ResourceLocation part : this.spell) {
            array.add(part.toString());
        }
        jsonobject.add("spell", (JsonElement)array);
        JsonObject object = new JsonObject();
        object.addProperty("family", this.sound.sound == null ? "default" : this.sound.sound.getId().toString());
        object.addProperty("pitch", (Number)Float.valueOf(this.sound.pitch));
        object.addProperty("volume", (Number)Float.valueOf(this.sound.volume));
        jsonobject.add("sound", (JsonElement)object);
        return jsonobject;
    }

    public static class Serializer
    implements RecipeSerializer<CasterTomeData> {
        public CasterTomeData fromJson(ResourceLocation recipeId, JsonObject json) {
            ResourceLocation type = json.has("tome_type") ? ResourceLocation.m_135820_((String)json.get("tome_type").getAsString()) : ItemsRegistry.CASTER_TOME.registryObject.getId();
            String name = json.get("name").getAsString();
            String flavourText = json.has("flavour_text") ? json.get("flavour_text").getAsString() : "";
            int color = json.has("color") ? json.get("color").getAsInt() : -1;
            JsonArray spell = GsonHelper.m_13933_((JsonObject)json, (String)"spell");
            ArrayList<ResourceLocation> parsedSpell = new ArrayList<ResourceLocation>();
            for (JsonElement e : spell) {
                ResourceLocation part = ResourceLocation.m_135820_((String)e.getAsString());
                parsedSpell.add(part);
            }
            ConfiguredSpellSound sound = ConfiguredSpellSound.DEFAULT;
            if (json.has("sound")) {
                JsonObject object = json.getAsJsonObject("sound");
                SpellSound family = SpellSoundRegistry.getSpellSoundsRegistry().get(ResourceLocation.m_135820_((String)object.get("family").getAsString()));
                sound = new ConfiguredSpellSound(family, object.get("volume").getAsFloat(), object.get("pitch").getAsFloat());
            }
            return new CasterTomeData(recipeId, name, parsedSpell, type, flavourText, color, sound);
        }

        public void toNetwork(FriendlyByteBuf buf, CasterTomeData recipe) {
            buf.writeItemStack(recipe.m_8043_(null), false);
        }

        @Nullable
        public CasterTomeData fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack itemStack = buffer.m_130267_();
            ISpellCaster caster = CasterUtil.getCaster(itemStack);
            return new CasterTomeData(recipeId, caster.getSpellName(), caster.getSpell().recipe.stream().map(AbstractSpellPart::getRegistryName).toList(), RegistryHelper.getRegistryName(itemStack.m_41720_()), caster.getFlavorText(), caster.getColor().getColor(), caster.getCurrentSound());
        }
    }
}

