/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.event;

import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class DelayedSpellEvent
implements ITimedEvent {
    private int duration;
    private final Spell spell;
    private final SpellContext context;
    private final HitResult result;
    private final Level world;
    @Nullable
    private final LivingEntity shooter;

    public DelayedSpellEvent(int delay, Spell spell, HitResult result, Level world, @Nullable LivingEntity shooter, SpellContext context) {
        this.duration = delay;
        this.spell = spell;
        this.result = result;
        this.world = world;
        this.shooter = shooter;
        this.context = context;
    }

    @Override
    public void tick(boolean serverSide) {
        --this.duration;
        if (this.duration <= 0 && serverSide) {
            this.resolveSpell();
        } else if (!serverSide && this.result != null) {
            BlockPos hitVec = this.result instanceof EntityHitResult ? ((EntityHitResult)this.result).m_82443_().m_20183_() : BlockPos.m_274446_((Position)this.result.m_82450_());
            ParticleUtil.spawnTouch((ClientLevel)this.world, hitVec, this.context.getColors());
        }
    }

    public void resolveSpell() {
        EntityHitResult ehr;
        HitResult hitResult;
        if (this.world == null || (hitResult = this.result) instanceof EntityHitResult && (ehr = (EntityHitResult)hitResult).m_82443_().m_213877_()) {
            return;
        }
        SpellResolver resolver = new SpellResolver(this.context);
        resolver.onResolveEffect(this.world, this.result);
    }

    @Override
    public boolean isExpired() {
        return this.duration <= 0 || this.world == null;
    }
}

