/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public interface IPotionEffect {
    default public void applyConfigPotion(LivingEntity entity, MobEffect potionEffect, SpellStats spellStats) {
        this.applyConfigPotion(entity, potionEffect, spellStats, true);
    }

    default public void applyConfigPotion(LivingEntity entity, MobEffect potionEffect, SpellStats spellStats, boolean showParticles) {
        this.applyPotion(entity, potionEffect, spellStats, this.getBaseDuration(), this.getExtendTimeDuration(), showParticles);
    }

    default public void applyPotion(LivingEntity entity, MobEffect potionEffect, SpellStats stats, int baseDurationSeconds, int durationBuffSeconds, boolean showParticles) {
        if (entity == null) {
            return;
        }
        int ticks = baseDurationSeconds * 20 + durationBuffSeconds * stats.getDurationInTicks();
        int amp = (int)stats.getAmpMultiplier();
        entity.m_7292_(new MobEffectInstance(potionEffect, ticks, amp, false, showParticles, true));
    }

    public int getBaseDuration();

    public int getExtendTimeDuration();
}

