/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.event.ManaRegenCalcEvent;
import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.mana.IManaDiscountEquipment;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ManaUtil {
    public static int getPlayerDiscounts(LivingEntity e, Spell spell, ItemStack casterStack) {
        if (e == null) {
            return 0;
        }
        AtomicInteger discounts = new AtomicInteger();
        CuriosUtil.getAllWornItems(e).ifPresent(items -> {
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack item = items.getStackInSlot(i);
                Item patt1343$temp = item.m_41720_();
                if (!(patt1343$temp instanceof IManaDiscountEquipment)) continue;
                IManaDiscountEquipment discountItem = (IManaDiscountEquipment)patt1343$temp;
                discounts.addAndGet(discountItem.getManaDiscount(item, spell));
            }
        });
        for (ItemStack armor : e.m_6168_()) {
            Item item = armor.m_41720_();
            if (!(item instanceof IManaDiscountEquipment)) continue;
            IManaDiscountEquipment discountItem = (IManaDiscountEquipment)item;
            discounts.addAndGet(discountItem.getManaDiscount(armor, spell));
        }
        Item item = casterStack.m_41720_();
        if (item instanceof IManaDiscountEquipment) {
            IManaDiscountEquipment discountEquipment = (IManaDiscountEquipment)item;
            discounts.addAndGet(discountEquipment.getManaDiscount(casterStack, spell));
        }
        return discounts.get();
    }

    public static double getCurrentMana(LivingEntity e) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana(e).orElse(null);
        if (mana == null) {
            return 0.0;
        }
        return mana.getCurrentMana();
    }

    public static Mana calcMaxMana(Player e) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana((LivingEntity)e).orElse(null);
        if (mana == null) {
            return new Mana(0, 0.0f);
        }
        double rawMax = PerkUtil.perkValue((LivingEntity)e, (Attribute)PerkAttributes.MAX_MANA.get());
        int tier = mana.getBookTier();
        int numGlyphs = mana.getGlyphBonus();
        rawMax += (double)(numGlyphs * (Integer)ServerConfig.GLYPH_MAX_BONUS.get());
        int max = (int)(rawMax += (double)(tier * (Integer)ServerConfig.TIER_MAX_BONUS.get()));
        MaxManaCalcEvent event = new MaxManaCalcEvent((LivingEntity)e, max);
        MinecraftForge.EVENT_BUS.post((Event)event);
        max = event.getMax();
        float reserve = event.getReserve();
        return new Mana(max, reserve);
    }

    public static int getMaxMana(Player e) {
        return ManaUtil.calcMaxMana(e).getRealMax();
    }

    public static double getManaRegen(Player e) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana((LivingEntity)e).orElse(null);
        if (mana == null) {
            return 0.0;
        }
        double regen = 0.0;
        if (e.m_21051_((Attribute)PerkAttributes.MANA_REGEN_BONUS.get()) != null) {
            regen += e.m_21133_((Attribute)PerkAttributes.MANA_REGEN_BONUS.get());
        }
        int tier = mana.getBookTier();
        double numGlyphs = mana.getGlyphBonus();
        regen += numGlyphs * (Double)ServerConfig.GLYPH_REGEN_BONUS.get();
        ManaRegenCalcEvent event = new ManaRegenCalcEvent((LivingEntity)e, regen += (double)(tier * (Integer)ServerConfig.TIER_REGEN_BONUS.get()));
        MinecraftForge.EVENT_BUS.post((Event)event);
        regen = event.getRegen();
        return regen;
    }

    public record Mana(int Max, float Reserve) {
        public int getRealMax() {
            return (int)((double)this.Max * (1.0 - (double)this.Reserve));
        }
    }
}

