/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.block.tile.ImbuementTile;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ImbuementRecipe
implements Recipe<ImbuementTile> {
    public final Ingredient input;
    public final ItemStack output;
    public final int source;
    public final ResourceLocation id;
    public List<Ingredient> pedestalItems;

    public ImbuementRecipe(ResourceLocation resourceLocation, Ingredient input, ItemStack output, int source, List<Ingredient> pedestalItems) {
        this.id = resourceLocation;
        this.input = input;
        this.output = output;
        this.source = source;
        this.pedestalItems = pedestalItems;
    }

    public ImbuementRecipe(String id, Ingredient ingredient, ItemStack output, int source, List<Ingredient> pedestalItems) {
        this(new ResourceLocation("ars_nouveau", "imbuement_" + id), ingredient, output, source, pedestalItems);
    }

    public ImbuementRecipe(String id, Ingredient ingredient, ItemStack output, int source) {
        this(new ResourceLocation("ars_nouveau", "imbuement_" + id), ingredient, output, source, new ArrayList<Ingredient>());
    }

    public ImbuementRecipe withPedestalItem(Ingredient i) {
        this.pedestalItems.add(i);
        return this;
    }

    public ImbuementRecipe withPedestalItem(RegistryObject<? extends ItemLike> i) {
        return this.withPedestalItem((ItemLike)i.get());
    }

    public ImbuementRecipe withPedestalItem(ItemStack i) {
        this.pedestalItems.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{i}));
        return this;
    }

    public ImbuementRecipe withPedestalItem(ItemLike i) {
        this.pedestalItems.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{i}));
        return this;
    }

    public boolean isMatch(List<ItemStack> pedestalItems, ItemStack reagent, ImbuementTile imbuementTile, @Nullable Player player) {
        pedestalItems = pedestalItems.stream().filter(itemStack -> !itemStack.m_41619_()).collect(Collectors.toList());
        return this.doesReagentMatch(reagent) && this.pedestalItems.size() == pedestalItems.size() && EnchantingApparatusRecipe.doItemsMatch(pedestalItems, this.pedestalItems);
    }

    public boolean doesReagentMatch(ItemStack reag) {
        return this.input.test(reag);
    }

    public boolean matches(ImbuementTile pContainer, Level pLevel) {
        return EnchantingApparatusRecipe.doItemsMatch(pContainer.getPedestalItems(), this.pedestalItems) && this.input.test(pContainer.m_8020_(0));
    }

    public ItemStack assemble(ImbuementTile p_44001_, RegistryAccess p_267165_) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.IMBUEMENT_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ForgeRegistries.RECIPE_TYPES.getValue(new ResourceLocation("ars_nouveau", "imbuement"));
    }

    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_nouveau:imbuement");
        jsonobject.add("input", this.input.m_43942_());
        jsonobject.addProperty("output", RegistryHelper.getRegistryName(this.output.m_41720_()).toString());
        jsonobject.addProperty("count", (Number)this.output.m_41613_());
        jsonobject.addProperty("source", (Number)this.source);
        JsonArray pedestalArr = new JsonArray();
        for (Ingredient i : this.pedestalItems) {
            JsonObject object = new JsonObject();
            object.add("item", i.m_43942_());
            pedestalArr.add((JsonElement)object);
        }
        jsonobject.add("pedestalItems", (JsonElement)pedestalArr);
        return jsonobject;
    }

    public static class Serializer
    implements RecipeSerializer<ImbuementRecipe> {
        public ImbuementRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient inputStack = null;
            inputStack = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"input")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            Item output = GsonHelper.m_13909_((JsonObject)json, (String)"output");
            int count = GsonHelper.m_13927_((JsonObject)json, (String)"count");
            ItemStack outputStack = new ItemStack((ItemLike)output, count);
            int source = GsonHelper.m_13927_((JsonObject)json, (String)"source");
            JsonArray pedestalItems = GsonHelper.m_13933_((JsonObject)json, (String)"pedestalItems");
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (JsonElement e : pedestalItems) {
                JsonObject obj = e.getAsJsonObject();
                Ingredient input = null;
                input = GsonHelper.m_13885_((JsonObject)obj, (String)"item") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)obj, (String)"item")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)obj, (String)"item"));
                stacks.add(input);
            }
            return new ImbuementRecipe(recipeId, inputStack, outputStack, source, stacks);
        }

        public void toNetwork(FriendlyByteBuf buf, ImbuementRecipe recipe) {
            buf.writeInt(recipe.pedestalItems.size());
            for (Ingredient i : recipe.pedestalItems) {
                i.m_43923_(buf);
            }
            recipe.input.m_43923_(buf);
            buf.m_130055_(recipe.output);
            buf.writeInt(recipe.source);
        }

        @Nullable
        public ImbuementRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int length = buffer.readInt();
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            return new ImbuementRecipe(recipeId, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130267_(), buffer.readInt(), stacks);
        }
    }
}

