/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.MageBlock;
import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import com.hollingsworth.arsnouveau.common.entity.goal.ConditionalLeapGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.ConditionalMeleeGoal;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnimBlockSummon
extends TamableAnimal
implements GeoEntity,
ISummon,
IDispellable {
    public BlockState blockState;
    public int color;
    private int ticksLeft;
    public static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(AnimBlockSummon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> CAN_WALK = SynchedEntityData.m_135353_(AnimBlockSummon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean isAlternateSpawn;
    public boolean dropItem = true;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(AnimBlockSummon.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(AnimBlockSummon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AnimBlockSummon(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.isAlternateSpawn = this.f_19796_.m_188499_();
    }

    public AnimBlockSummon(Level pLevel, BlockState state) {
        this((EntityType<? extends TamableAnimal>)((EntityType)ModEntities.ANIMATED_BLOCK.get()), pLevel);
        this.blockState = state;
    }

    public double m_21133_(Attribute pAttribute) {
        if (pAttribute == Attributes.f_22281_) {
            return super.m_21133_(pAttribute) + (double)this.getStateDamageBonus();
        }
        return super.m_21133_(pAttribute);
    }

    public float getStateDamageBonus() {
        float destroySpeed = 1.0f;
        try {
            destroySpeed = this.blockState.m_60800_((BlockGetter)this.f_19853_, this.m_20183_());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return destroySpeed;
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.ANIMATED_BLOCK.get();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new ConditionalLeapGoal((Mob)this, 0.4f, () -> (Boolean)this.f_19804_.m_135370_(CAN_WALK)));
        this.f_21345_.m_25352_(5, (Goal)new ConditionalMeleeGoal((PathfinderMob)this, 1.0, true, () -> (Boolean)this.f_19804_.m_135370_(CAN_WALK)));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AnimBlockSummon.class}).m_26044_(new Class[]{AnimBlockSummon.class}));
    }

    public boolean m_7327_(Entity pEntity) {
        if (this.m_269323_() != null && pEntity.m_7307_((Entity)this.m_269323_())) {
            return false;
        }
        boolean result = super.m_7327_(pEntity);
        if (result) {
            this.ticksLeft -= 400;
        }
        return result;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public boolean m_6779_(LivingEntity pTarget) {
        if (this.getOwnerID() != null) {
            if (pTarget.m_20148_().equals(this.getOwnerID())) {
                return false;
            }
            if (pTarget instanceof ISummon) {
                ISummon summon = (ISummon)pTarget;
                return super.m_6779_(pTarget) && !this.getOwnerID().equals(summon.getOwnerID());
            }
        }
        return super.m_6779_(pTarget);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            --this.ticksLeft;
            this.f_19804_.m_135381_(AGE, (Object)((Integer)this.f_19804_.m_135370_(AGE) + 1));
            if ((Integer)this.f_19804_.m_135370_(AGE) > 20) {
                this.f_19804_.m_135381_(CAN_WALK, (Object)true);
            }
            if (this.ticksLeft <= 0) {
                ParticleUtil.spawnPoof((ServerLevel)this.f_19853_, this.m_20183_());
                this.returnToFallingBlock(this.blockState);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.onSummonDeath(this.f_19853_, null, true);
            }
        }
    }

    public void returnToFallingBlock(BlockState blockState) {
        EnchantedFallingBlock fallingBlock = new EnchantedFallingBlock(this.f_19853_, this.m_20183_(), blockState);
        fallingBlock.m_5602_((Entity)this.m_269323_());
        fallingBlock.m_20256_(this.m_20184_());
        fallingBlock.setColor(ParticleColor.fromInt(this.color));
        fallingBlock.dropItem = this.dropItem;
        if (blockState.m_60734_() instanceof MageBlock) {
            fallingBlock.dropItem = false;
        }
        this.f_19853_.m_7967_((Entity)fallingBlock);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UUID, Optional.of(Util.f_137441_));
        this.f_19804_.m_135372_(COLOR, (Object)ParticleColor.defaultParticleColor().getColor());
        this.f_19804_.m_135372_(AGE, (Object)0);
        this.f_19804_.m_135372_(CAN_WALK, (Object)false);
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.returnToFallingBlock(this.getBlockState());
        this.onSummonDeath(this.f_19853_, cause, false);
    }

    @Nullable
    public LivingEntity m_269323_() {
        return this.f_20890_ ? null : super.m_269323_();
    }

    public boolean m_35506_() {
        return false;
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        return false;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public int m_213860_() {
        return 0;
    }

    @Override
    public int getTicksLeft() {
        return this.ticksLeft;
    }

    @Override
    public void setTicksLeft(int ticks) {
        this.ticksLeft = ticks;
    }

    @Override
    @Nullable
    public UUID getOwnerID() {
        return ((Optional)this.m_20088_().m_135370_(OWNER_UUID)).isEmpty() ? this.m_20148_() : (UUID)((Optional)this.m_20088_().m_135370_(OWNER_UUID)).get();
    }

    @Override
    public void setOwnerID(UUID uuid) {
        this.m_20088_().m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        String spawnAnim = "spawn";
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, spawnAnim, 0, e -> {
            if (!((Boolean)this.f_19804_.m_135370_(CAN_WALK)).booleanValue()) {
                e.getController().setAnimation(RawAnimation.begin().thenPlay(spawnAnim));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "run", 1, e -> {
            if (e.isMoving() && ((Boolean)this.f_19804_.m_135370_(CAN_WALK)).booleanValue()) {
                e.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, Block.m_49956_((BlockState)this.getBlockState()));
    }

    public BlockState getBlockState() {
        return this.blockState != null ? this.blockState : BlockRegistry.MAGE_BLOCK.get().m_49966_();
    }

    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        this.blockState = Block.m_49803_((int)pPacket.m_131509_());
        double d0 = pPacket.m_131500_();
        double d1 = pPacket.m_131501_();
        double d2 = pPacket.m_131502_();
        this.m_6034_(d0, d1, d2);
    }

    public void setColor(int color) {
        this.color = color;
        this.m_20088_().m_135381_(COLOR, (Object)color);
    }

    public boolean m_20223_(CompoundTag pCompound) {
        pCompound.m_128405_("color", this.color);
        return super.m_20223_(pCompound);
    }

    public void m_20258_(CompoundTag pCompound) {
        super.m_20258_(pCompound);
        this.m_20088_().m_135381_(COLOR, (Object)pCompound.m_128451_("color"));
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.ticksLeft = pCompound.m_128451_("left");
        this.color = pCompound.m_128451_("color");
        this.blockState = Block.m_49803_((int)pCompound.m_128451_("blockState"));
        this.m_20088_().m_135381_(AGE, (Object)pCompound.m_128451_("ticksAlive"));
        this.m_20088_().m_135381_(CAN_WALK, (Object)pCompound.m_128471_("canWalk"));
        this.dropItem = !pCompound.m_128441_("dropItem") || pCompound.m_128471_("dropItem");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("left", this.ticksLeft);
        pCompound.m_128405_("color", this.color);
        pCompound.m_128405_("blockState", Block.m_49956_((BlockState)this.blockState));
        pCompound.m_128405_("ticksAlive", ((Integer)this.m_20088_().m_135370_(AGE)).intValue());
        pCompound.m_128379_("canWalk", ((Boolean)this.m_20088_().m_135370_(CAN_WALK)).booleanValue());
        pCompound.m_128379_("dropItem", this.dropItem);
    }

    public int getColor() {
        if (this.color == 0) {
            this.color = (Integer)this.f_19804_.m_135370_(COLOR);
        }
        return this.color;
    }

    @Override
    public boolean onDispel(@NotNull LivingEntity caster) {
        this.setTicksLeft(0);
        return true;
    }
}

