/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.RedstoneAir;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectRedstone
extends AbstractEffect {
    public static EffectRedstone INSTANCE = new EffectRedstone();
    public ForgeConfigSpec.IntValue BONUS_TIME;

    private EffectRedstone() {
        super(GlyphLib.EffectRedstoneID, "Redstone Signal");
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockState state = BlockRegistry.REDSTONE_AIR.defaultBlockState();
        int signalModifier = (int)spellStats.getAmpMultiplier() + 10;
        if (signalModifier < 1) {
            signalModifier = 1;
        }
        if (signalModifier > 15) {
            signalModifier = 15;
        }
        state = (BlockState)state.m_61124_((Property)RedstoneAir.POWER, (Comparable)Integer.valueOf(signalModifier));
        BlockPos pos = rayTraceResult.m_82425_().m_121945_(rayTraceResult.m_82434_());
        if (!world.m_8055_(pos).m_60795_() || world.m_8055_(pos).m_60734_() == BlockRegistry.REDSTONE_AIR.get()) {
            return;
        }
        if (!world.m_46739_(pos)) {
            return;
        }
        int timeBonus = (int)spellStats.getDurationMultiplier();
        world.m_46597_(pos, state);
        int delay = Math.max((Integer)this.GENERIC_INT.get() + timeBonus * (Integer)this.BONUS_TIME.get(), 2);
        world.m_186460_(pos, state.m_60734_(), delay);
        BlockPos hitPos = pos.m_121945_(rayTraceResult.m_82434_().m_122424_());
        BlockUtil.safelyUpdateState(world, pos);
        world.m_46672_(pos, state.m_60734_());
        world.m_46672_(hitPos, state.m_60734_());
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addGenericInt(builder, 5, "Base time in ticks", "base_duration");
        this.BONUS_TIME = builder.comment("Extend time bonus, in ticks").defineInRange("extend_time", 10, 0, Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Creates a brief redstone signal on a block, like a button. The signal starts at strength 10, and may be increased with Amplify, or decreased with Dampen. The duration may be extended with Extend Time or shortened with Duration Down.";
    }

    @Override
    public int getDefaultManaCost() {
        return 0;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

