/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public interface IDamageEffect {
    default public boolean canDamage(LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver, @NotNull Entity entity) {
        LivingEntity living;
        return !(entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21223_() <= 0.0f || entity.m_7307_((Entity)shooter));
    }

    default public boolean attemptDamage(Level world, @NotNull LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver, Entity entity, DamageSource source, float baseDamage) {
        LivingEntity mob;
        if (!this.canDamage(shooter, stats, spellContext, resolver, entity)) {
            return false;
        }
        ServerLevel server = (ServerLevel)world;
        float totalDamage = (float)((double)baseDamage + stats.getDamageModifier() + (shooter.m_21204_().m_22171_((Attribute)PerkAttributes.SPELL_DAMAGE_BONUS.get()) ? shooter.m_21133_((Attribute)PerkAttributes.SPELL_DAMAGE_BONUS.get()) : 0.0));
        if (stats.isRandomized()) {
            totalDamage += (float)(stats.getBuffCount(AugmentRandomize.INSTANCE) * server.f_46441_.m_216332_(-1, 1));
        }
        SpellDamageEvent.Pre preDamage = new SpellDamageEvent.Pre(source, shooter, entity, totalDamage, spellContext);
        MinecraftForge.EVENT_BUS.post((Event)preDamage);
        source = preDamage.damageSource;
        totalDamage = preDamage.damage;
        if (totalDamage <= 0.0f || preDamage.isCanceled()) {
            return false;
        }
        if (!entity.m_6469_(source, totalDamage)) {
            return false;
        }
        shooter.m_21335_(entity);
        SpellDamageEvent.Post postDamage = new SpellDamageEvent.Post(source, shooter, entity, totalDamage, spellContext);
        MinecraftForge.EVENT_BUS.post((Event)postDamage);
        if (entity instanceof LivingEntity && (mob = (LivingEntity)entity).m_21223_() <= 0.0f && !mob.m_213877_() && stats.hasBuff(AugmentFortune.INSTANCE)) {
            ANFakePlayer aNFakePlayer;
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                aNFakePlayer = player;
            } else {
                aNFakePlayer = ANFakePlayer.getPlayer(server);
            }
            ANFakePlayer playerContext = aNFakePlayer;
            int looting = stats.getBuffCount(AugmentFortune.INSTANCE);
            LootParams lootContext = LootUtil.getLootingContext(server, shooter, mob, looting, world.m_269111_().m_269075_((Player)playerContext)).m_287235_(LootContextParamSets.f_81415_);
            ResourceLocation lootTable = mob.m_5743_();
            LootTable loottable = server.m_7654_().m_278653_().m_278676_(lootTable);
            ObjectArrayList items = loottable.m_287195_(lootContext);
            items.forEach(arg_0 -> ((LivingEntity)mob).m_19983_(arg_0));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    default public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        ANFakePlayer aNFakePlayer;
        DamageSources damageSources = world.m_269111_();
        if (!(shooter instanceof Player)) {
            aNFakePlayer = ANFakePlayer.getPlayer((ServerLevel)world);
        } else {
            void var3_3;
            Player player = (Player)shooter;
            aNFakePlayer = var3_3;
        }
        return damageSources.m_269075_((Player)aNFakePlayer);
    }
}

