/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.utils;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.client.gui.utils.TintedVertexConsumer;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class RenderUtils {
    private static final RenderType TRANSLUCENT = RenderType.m_110473_((ResourceLocation)TextureAtlas.f_118259_);
    private static final Matrix4f SCALE_INVERT_Y = new Matrix4f().scaling(1.0f, -1.0f, 1.0f);

    public static void drawSpellPart(AbstractSpellPart objectToBeDrawn, GuiGraphics graphics, int positionX, int positionY, int size, boolean renderTransparent, int zIndex) {
        RenderUtils.renderFakeItemTransparent(graphics.m_280168_(), objectToBeDrawn.glyphItem.m_7968_(), positionX, positionY, size, 0, renderTransparent, zIndex);
    }

    public static void drawSpellPart(AbstractSpellPart objectToBeDrawn, GuiGraphics graphics, int positionX, int positionY, int size, boolean renderTransparent) {
        RenderUtils.renderFakeItemTransparent(graphics.m_280168_(), objectToBeDrawn.glyphItem.m_7968_(), positionX, positionY, size, 0, renderTransparent, 150);
    }

    public static void drawItemAsIcon(ItemStack itemStack, GuiGraphics graphics, int positionX, int positionY, int size, boolean renderTransparent) {
        RenderUtils.renderFakeItemTransparent(graphics.m_280168_(), itemStack, positionX, positionY, size, 0, renderTransparent, 150);
    }

    public static void renderFakeItemTransparent(PoseStack poseStack, ItemStack stack, int x, int y, int scale, int alpha, boolean transparent, int zIndex) {
        if (stack.m_41619_()) {
            return;
        }
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        BakedModel model = renderer.m_174264_(stack, null, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
        RenderUtils.renderItemModel(poseStack, stack, x, y, scale, alpha, model, renderer, transparent, zIndex);
    }

    public static void renderItemModel(PoseStack poseStack, ItemStack stack, int x, int y, int scale, int alpha, BakedModel model, ItemRenderer renderer, boolean transparent, int zIndex) {
        boolean flatLight;
        poseStack.m_85836_();
        poseStack.m_252880_((float)x + 8.0f, (float)y + 8.0f, (float)zIndex);
        poseStack.m_252931_(SCALE_INVERT_Y);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        boolean bl = flatLight = !model.m_7547_();
        if (flatLight) {
            Lighting.m_84930_();
        }
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        renderer.m_115143_(stack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)(transparent ? RenderUtils.transparentBuffer((MultiBufferSource)buffer) : buffer), 0xF000F0, OverlayTexture.f_118083_, model);
        buffer.m_109911_();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
    }

    private static MultiBufferSource transparentBuffer(MultiBufferSource buffer) {
        return renderType -> new TintedVertexConsumer(buffer.m_6299_(TRANSLUCENT), 1.0f, 1.0f, 1.0f, 0.25f);
    }

    public static void colorBlit(PoseStack mStack, int x, int y, int uOffset, int vOffset, int width, int height, int textureWidth, int textureHeight, Color color) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172820_);
        Matrix4f matrix = mStack.m_85850_().m_252922_();
        int maxX = x + width;
        int maxY = y + height;
        float minU = (float)uOffset / (float)textureWidth;
        float minV = (float)vOffset / (float)textureHeight;
        float maxU = minU + (float)width / (float)textureWidth;
        float maxV = minV + (float)height / (float)textureHeight;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int alpha = color.getAlpha();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_252986_(matrix, (float)x, (float)maxY, 0.0f).m_7421_(minU, maxV).m_6122_(r, g, b, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)maxX, (float)maxY, 0.0f).m_7421_(maxU, maxV).m_6122_(r, g, b, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)maxX, (float)y, 0.0f).m_7421_(maxU, minV).m_6122_(r, g, b, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_(minU, minV).m_6122_(r, g, b, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
    }
}

