/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.event.DispelEvent;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.loot.DungeonLootTables;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.recipe.MultiRecipeWrapper;
import com.hollingsworth.arsnouveau.api.registry.CasterTomeRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.RitualEventQueue;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.LavaLily;
import com.hollingsworth.arsnouveau.common.command.AddTomeCommand;
import com.hollingsworth.arsnouveau.common.command.DataDumpCommand;
import com.hollingsworth.arsnouveau.common.command.PathCommand;
import com.hollingsworth.arsnouveau.common.command.ResetCommand;
import com.hollingsworth.arsnouveau.common.command.SummonAnimHeadCommand;
import com.hollingsworth.arsnouveau.common.command.ToggleLightCommand;
import com.hollingsworth.arsnouveau.common.compat.CaelusHandler;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.entity.Whirlisprig;
import com.hollingsworth.arsnouveau.common.items.EnchantersSword;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.items.VoidJar;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketJoinedServer;
import com.hollingsworth.arsnouveau.common.perk.JumpHeightPerk;
import com.hollingsworth.arsnouveau.common.perk.LootingPerk;
import com.hollingsworth.arsnouveau.common.ritual.DenySpawnRitual;
import com.hollingsworth.arsnouveau.common.ritual.RitualFlight;
import com.hollingsworth.arsnouveau.common.ritual.RitualGravity;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGlide;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.hollingsworth.arsnouveau.setup.registry.VillagerRegistry;
import com.hollingsworth.arsnouveau.setup.reward.Rewards;
import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class EventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void resourceLoadEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Object>(){

            protected Object m_5944_(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                return null;
            }

            protected void m_5787_(Object pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                MultiRecipeWrapper.RECIPE_CACHE = new HashMap<Item, MultiRecipeWrapper>();
                ArsNouveauAPI.getInstance().onResourceReload();
                EventQueue.getServerInstance().addEvent(new ITimedEvent(){
                    boolean expired;

                    @Override
                    public void tickEvent(TickEvent event) {
                        if (event instanceof TickEvent.ServerTickEvent) {
                            TickEvent.ServerTickEvent serverTickEvent = (TickEvent.ServerTickEvent)event;
                            CasterTomeRegistry.reloadTomeData(serverTickEvent.getServer().m_129894_(), (Level)((TickEvent.ServerTickEvent)event).getServer().m_129880_(Level.f_46428_));
                        }
                        this.expired = true;
                    }

                    @Override
                    public void tick(boolean serverSide) {
                    }

                    @Override
                    public boolean isExpired() {
                        return this.expired;
                    }
                });
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void itemPickupEvent(EntityItemPickupEvent event) {
        ItemStack pickingUp;
        Player player = event.getEntity();
        boolean voided = VoidJar.tryVoiding(player, pickingUp = event.getItem().m_32055_());
        if (voided) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void itemPickupEvent(PlayerEvent.ItemPickupEvent event) {
        Player player = event.getEntity();
        ItemStack pickingUp = event.getStack();
        VoidJar.tryVoiding(player, pickingUp);
    }

    @SubscribeEvent
    public static void shieldEvent(ShieldBlockEvent e) {
        Player player;
        LivingEntity livingEntity;
        if (!e.getEntity().f_19853_.f_46443_ && (livingEntity = e.getEntity()) instanceof Player && (player = (Player)livingEntity).m_21254_() && player.m_21211_().m_41720_() == ItemsRegistry.ENCHANTERS_SHIELD.m_5456_()) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModPotions.MANA_REGEN_EFFECT.get(), 200, 1));
            player.m_7292_(new MobEffectInstance((MobEffect)ModPotions.SPELL_DAMAGE_EFFECT.get(), 200, 1));
        }
    }

    @SubscribeEvent
    public static void livingHurtEvent(LivingHurtEvent e) {
        if (e.getEntity().f_19853_.f_46443_) {
            return;
        }
        Entity entity = e.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingUser = (LivingEntity)entity;
            if (livingUser instanceof Player) {
                return;
            }
            if (livingUser.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof EnchantersSword && BlockUtil.distanceFrom(livingUser.f_19825_, e.getEntity().f_19825_) < 3.0) {
                livingUser.m_21120_(InteractionHand.MAIN_HAND).m_41720_().m_7579_(livingUser.m_21205_(), e.getEntity(), livingUser);
            }
        }
    }

    @SubscribeEvent
    public static void livingAttackEvent(LivingAttackEvent e) {
        Level world;
        if (e.getSource().m_276093_(DamageTypes.f_268434_) && e.getEntity() != null && !e.getEntity().m_20193_().f_46443_ && (world = e.getEntity().f_19853_).m_8055_(e.getEntity().m_20183_()).m_60734_() instanceof LavaLily) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void livingSpawnEvent(MobSpawnEvent.FinalizeSpawn checkSpawn) {
        ServerLevelAccessor serverLevelAccessor = checkSpawn.getLevel();
        if (serverLevelAccessor instanceof Level) {
            Level level = (Level)serverLevelAccessor;
            if (!level.f_46443_) {
                RitualEventQueue.getRitual(level, DenySpawnRitual.class, ritu -> ritu.denySpawn(checkSpawn));
            }
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent e) {
        if (e.getEntity() != null && e.getEntity().m_21023_((MobEffect)ModPotions.SNARE_EFFECT.get())) {
            e.getEntity().m_20334_(0.0, 0.0, 0.0);
            return;
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        String book_tag;
        CompoundTag tag;
        ServerPlayer serverPlayer;
        boolean isContributor;
        if (e.getEntity().m_20193_().f_46443_) {
            return;
        }
        Player player = e.getEntity();
        if (player instanceof ServerPlayer && (isContributor = Rewards.CONTRIBUTORS.contains((serverPlayer = (ServerPlayer)player).m_20148_()))) {
            Networking.sendToPlayerClient(new PacketJoinedServer(true), (ServerPlayer)e.getEntity());
        }
        if (!(tag = e.getEntity().getPersistentData().m_128469_("PlayerPersisted")).m_128471_(book_tag = "an_book_") && ((Boolean)Config.SPAWN_BOOK.get()).booleanValue()) {
            Player entity = e.getEntity();
            ItemHandlerHelper.giveItemToPlayer((Player)entity, (ItemStack)new ItemStack(ItemsRegistry.WORN_NOTEBOOK));
            tag.m_128379_(book_tag, true);
            e.getEntity().getPersistentData().m_128365_("PlayerPersisted", (Tag)tag);
        }
    }

    @SubscribeEvent
    public static void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++ClientInfo.ticksInGame;
            if (ClientInfo.redTicks()) {
                --ClientInfo.redOverlayTicks;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGlideTick(TickEvent.PlayerTickEvent event) {
        ServerPlayer serverPlayer;
        Player player;
        if (ArsNouveau.caelusLoaded && EffectGlide.canGlide((LivingEntity)event.player)) {
            CaelusHandler.setFlying(event.player);
        }
        if (event.player.m_21023_((MobEffect)ModPotions.FLIGHT_EFFECT.get()) && event.player.f_19853_.m_46467_() % 20L == 0L && event.player.m_21124_((MobEffect)ModPotions.FLIGHT_EFFECT.get()).m_19557_() <= 600 && (player = event.player) instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            RitualEventQueue.getRitual(event.player.f_19853_, RitualFlight.class, flight -> flight.attemptRefresh(serverPlayer));
        }
        if (event.player.f_19853_.m_46467_() % (long)RitualGravity.renewInterval == 0L && (player = event.player) instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            MobEffectInstance gravity = event.player.m_21124_((MobEffect)ModPotions.GRAVITY_EFFECT.get());
            if (gravity == null || gravity.m_19557_() <= RitualGravity.renewThreshold) {
                RitualEventQueue.getRitual(event.player.f_19853_, RitualGravity.class, ritual -> !serverPlayer.m_7500_() && ritual.attemptRefresh(serverPlayer));
            }
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity;
        if (!event.getEntity().f_19853_.f_46443_ && (livingEntity = event.getEntity()) instanceof Player) {
            Player entity = (Player)livingEntity;
            RitualEventQueue.getRitual(entity.f_19853_, RitualFlight.class, flight -> flight.onJumpEvent(event));
        }
    }

    @SubscribeEvent
    public static void entityHurt(LivingHurtEvent e) {
        LivingEntity entity;
        if (e.getEntity() != null && e.getEntity().m_21023_((MobEffect)ModPotions.DEFENCE_EFFECT.get()) && (e.getSource().m_276093_(DamageTypes.f_268515_) || e.getSource().m_276093_(DamageTypes.f_268433_) || e.getSource().m_276093_(DamageTypes.f_268566_)) && (double)e.getAmount() > 0.5) {
            e.setAmount((float)Math.max(0.5, (double)(e.getAmount() - 1.0f - (float)e.getEntity().m_21124_((MobEffect)ModPotions.DEFENCE_EFFECT.get()).m_19564_())));
        }
        if (e.getEntity() != null && e.getSource().m_276093_(DamageTypes.f_268450_) && e.getEntity().m_21023_((MobEffect)ModPotions.SHOCKED_EFFECT.get())) {
            float damage = e.getAmount() + 3.0f + 3.0f * (float)e.getEntity().m_21124_((MobEffect)ModPotions.SHOCKED_EFFECT.get()).m_19564_();
            e.setAmount(Math.max(0.0f, damage));
        }
        if ((entity = e.getEntity()) != null && entity.m_21023_((MobEffect)ModPotions.HEX_EFFECT.get()) && (entity.m_21023_(MobEffects.f_19614_) || entity.m_21023_(MobEffects.f_19615_) || entity.m_6060_() || entity.m_21023_((MobEffect)ModPotions.SHOCKED_EFFECT.get()))) {
            e.setAmount(e.getAmount() + 0.5f + 0.33f * (float)entity.m_21124_((MobEffect)ModPotions.HEX_EFFECT.get()).m_19564_());
        }
        if (entity == null) {
            return;
        }
        double warding = PerkUtil.valueOrZero(entity, (Attribute)PerkAttributes.WARDING.get());
        double feather = PerkUtil.valueOrZero(entity, (Attribute)PerkAttributes.FEATHER.get());
        if (e.getSource().m_276093_(DamageTypes.f_268515_)) {
            e.setAmount((float)((double)e.getAmount() - warding));
        }
        if (e.getSource().m_276093_(DamageTypes.f_268671_)) {
            e.setAmount((float)((double)e.getAmount() - (double)e.getAmount() * feather));
        }
    }

    @SubscribeEvent
    public static void fallEvent(LivingFallEvent fallEvent) {
        LivingEntity livingEntity = fallEvent.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        double jumpBonus = PerkUtil.countForPerk(JumpHeightPerk.INSTANCE, player);
        fallEvent.setDistance((float)((double)fallEvent.getDistance() - jumpBonus / 0.1));
        if (CuriosUtil.hasItem(fallEvent.getEntity(), ItemsRegistry.BELT_OF_LEVITATION.m_5456_())) {
            fallEvent.setDistance(Math.max(0.0f, fallEvent.getDistance() - 6.0f));
        }
    }

    @SubscribeEvent
    public static void entityHeal(LivingHealEvent e) {
        LivingEntity entity = e.getEntity();
        if (entity != null && entity.m_21023_((MobEffect)ModPotions.HEX_EFFECT.get())) {
            e.setAmount(e.getAmount() / 2.0f);
        }
        if (entity != null && entity.m_21023_((MobEffect)ModPotions.RECOVERY_EFFECT.get())) {
            e.setAmount(e.getAmount() + 1.0f + (float)entity.m_21124_((MobEffect)ModPotions.RECOVERY_EFFECT.get()).m_19564_());
        }
    }

    @SubscribeEvent
    public static void eatEvent(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity;
        if (!event.getEntity().f_19853_.f_46443_ && event.getItem().m_41720_().m_41473_() != null && event.getItem().m_41720_().m_41472_() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            FoodData stats = player.m_36324_();
            stats.f_38697_ = (float)((double)stats.f_38697_ * PerkUtil.perkValue((LivingEntity)player, (Attribute)PerkAttributes.WHIRLIESPRIG.get()));
        }
    }

    @SubscribeEvent
    public static void dispelEvent(DispelEvent event) {
        Witch entity;
        EntityHitResult hit;
        HitResult hitResult = event.rayTraceResult;
        if (hitResult instanceof EntityHitResult && (hitResult = (hit = (EntityHitResult)hitResult).m_82443_()) instanceof Witch && (entity = (Witch)hitResult).m_21223_() <= entity.m_21233_() / 2.0f) {
            entity.m_142687_(Entity.RemovalReason.KILLED);
            ParticleUtil.spawnPoof((ServerLevel)event.world, entity.m_20183_());
            event.world.m_7967_((Entity)new ItemEntity(event.world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), new ItemStack(ItemsRegistry.WIXIE_SHARD)));
        }
    }

    @SubscribeEvent
    public static void commandRegister(RegisterCommandsEvent event) {
        ResetCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        DataDumpCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PathCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ToggleLightCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        AddTomeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SummonAnimHeadCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void registerTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerRegistry.SHARDS_TRADER.get()) {
            Int2ObjectMap trades = event.getTrades();
            List level1 = (List)trades.get(1);
            List level2 = (List)trades.get(2);
            List level3 = (List)trades.get(3);
            List level4 = (List)trades.get(4);
            List level5 = (List)trades.get(5);
            level1.add((trader, rand) -> EventHandler.itemToEmer(BlockRegistry.SOURCEBERRY_BUSH, 16, 16, 2));
            level1.add((trader, rand) -> EventHandler.itemToEmer(ItemsRegistry.MAGE_FIBER, 16, 16, 2));
            level1.add((trader, rand) -> EventHandler.itemToEmer(BlockRegistry.BOMBEGRANTE_POD, 6, 16, 2));
            level1.add((trader, rand) -> EventHandler.itemToEmer(BlockRegistry.MENDOSTEEN_POD, 6, 16, 2));
            level1.add((trader, rand) -> EventHandler.itemToEmer(BlockRegistry.FROSTAYA_POD, 6, 16, 2));
            level1.add((trader, rand) -> EventHandler.itemToEmer(BlockRegistry.BASTION_POD, 6, 16, 2));
            level1.add((trader, rand) -> EventHandler.itemToEmer((ItemLike)Items.f_151049_, 32, 16, 2));
            level1.add((trader, rand) -> EventHandler.emerToItem(ItemsRegistry.SOURCE_BERRY_ROLL, 4, 16, 2));
            level2.add((trader, rand) -> EventHandler.emerToItem(BlockRegistry.GHOST_WEAVE, 1, 8, 2));
            level2.add((trader, rand) -> EventHandler.emerToItem(BlockRegistry.MIRROR_WEAVE, 1, 8, 2));
            level2.add((trader, rand) -> EventHandler.emerToItem(BlockRegistry.FALSE_WEAVE, 1, 8, 2));
            level2.add((trader, rand) -> EventHandler.emerToItem(ItemsRegistry.WARP_SCROLL, 1, 8, 2));
            level2.add((trader, rand) -> EventHandler.itemToEmer(ItemsRegistry.WILDEN_HORN, 4, 8, 12));
            level2.add((trader, rand) -> EventHandler.itemToEmer(ItemsRegistry.WILDEN_SPIKE, 4, 8, 12));
            level2.add((trader, rand) -> EventHandler.itemToEmer(ItemsRegistry.WILDEN_WING, 4, 8, 12));
            ArrayList<RitualTablet> tablets = new ArrayList<RitualTablet>(RitualRegistry.getRitualItemMap().values());
            for (RitualTablet tablet : tablets) {
                if (!tablet.ritual.canBeTraded()) continue;
                level3.add((trader, rand) -> EventHandler.emerToItem((ItemLike)tablet, 4, 1, 12));
            }
            for (ItemStack shard : Ingredient.m_204132_(ItemTagProvider.SUMMON_SHARDS_TAG).m_43908_()) {
                level4.add((trader, rand) -> EventHandler.emerToItem((ItemLike)shard.m_41720_(), 20, 1, 20));
            }
            level5.add((trader, rand) -> EventHandler.emerToItem(ItemsRegistry.SOURCE_BERRY_PIE, 4, 8, 2));
            level5.add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 48), DungeonLootTables.getRandomItem(DungeonLootTables.RARE_LOOT), 1, 20, 0.2f));
        }
    }

    public static MerchantOffer emerToItem(ItemLike itemLike, int cost, int uses, int exp) {
        return new VillagerTrades.ItemsForEmeralds(itemLike.m_5456_(), cost, uses, exp).m_213663_(null, null);
    }

    public static MerchantOffer itemToEmer(ItemLike itemLike, int cost, int uses, int exp) {
        return new VillagerTrades.EmeraldForItems((ItemLike)itemLike.m_5456_(), cost, uses, exp).m_213663_(null, null);
    }

    @SubscribeEvent
    public static void onLootingEvent(LootingLevelEvent event) {
        Entity entity;
        if (event.getDamageSource() != null && (entity = event.getDamageSource().m_7639_()) instanceof Player) {
            Player living = (Player)entity;
            event.setLootingLevel(event.getLootingLevel() + Math.round(PerkUtil.countForPerk(LootingPerk.INSTANCE, living)));
        }
    }

    @SubscribeEvent
    public static void potionEvent(MobEffectEvent.Added event) {
        LivingEntity target = event.getEntity();
        Entity applier = event.getEffectSource();
        if (target.f_19853_.f_46443_) {
            return;
        }
        double bonus = 0.0;
        if (event.getEffectInstance().m_19544_().m_19486_()) {
            bonus = PerkUtil.valueOrZero(target, (Attribute)PerkAttributes.WIXIE.get());
        } else if (applier instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)applier;
            bonus = PerkUtil.valueOrZero(living, (Attribute)PerkAttributes.WIXIE.get());
        }
        if (bonus > 0.0) {
            event.getEffectInstance().f_19503_ = (int)((double)event.getEffectInstance().f_19503_ * bonus);
        }
    }

    @SubscribeEvent
    public static void treeGrow(SaplingGrowTreeEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        Set<UUID> sprigs = Whirlisprig.WHIRLI_MAP.getEntities((Level)level);
        ArrayList<UUID> sprigsToRemove = new ArrayList<UUID>();
        for (UUID uuid : sprigs) {
            Entity entity = level.m_8791_(uuid);
            if (entity == null || !(entity instanceof Whirlisprig)) {
                sprigsToRemove.add(uuid);
                continue;
            }
            Whirlisprig whirlisprig = (Whirlisprig)entity;
            if (!(BlockUtil.distanceFrom(entity.m_20183_(), event.getPos()) <= 10.0)) continue;
            whirlisprig.droppingShards = true;
        }
        for (UUID uuid : sprigsToRemove) {
            Whirlisprig.WHIRLI_MAP.removeEntity((Level)level, uuid);
        }
    }

    private EventHandler() {
    }
}

