/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.cubed;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CubedChiselMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final int bitsPerSide;
    private final boolean aligned;
    private final MutableComponent displayName;
    private final MutableComponent multiLineDisplayName;
    private final ResourceLocation iconName;

    CubedChiselMode(int bitsPerSide, boolean aligned, MutableComponent displayName, MutableComponent multiLineDisplayName, ResourceLocation iconName) {
        this.bitsPerSide = bitsPerSide;
        this.aligned = aligned;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(Player playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vec3.m_82528_((Vec3i)face.m_122424_().m_122436_()), Function.identity());
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        context.setComplete();
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                HashMap resultingBitCount = Maps.newHashMap();
                int totalItemDamage = mutator.inWorldMutableStream().mapToInt(state -> {
                    IBlockInformation currentState = state.getBlockInformation();
                    return context.tryDamageItemAndDoOrSetBrokenError(() -> {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    });
                }).sum();
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(Player playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(Player playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vec3.m_82528_((Vec3i)face.m_122436_()), facingVector -> this.aligned ? facingVector : facingVector.m_82542_(1.0, -1.0, 1.0));
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            BlockPos heightPos;
            IBlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(playerEntity);
            if (heldBlockState.isAir()) {
                return ClickProcessingState.DEFAULT;
            }
            int missingBitCount = (int)mutator.stream().filter(state -> state.getBlockInformation().isAir()).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.m_7500_()) {
                if (!playerEntity.m_7500_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getBlockInformation().isAir()).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().m_60734_().m_49954_()));
            }
            if (missingBitCount == 0 && (heightPos = mutator.getInWorldEndBlockPoint()).m_123342_() >= context.getWorld().m_151558_()) {
                MutableComponent component = Component.m_237110_((String)"build.tooHigh", (Object[])new Object[]{context.getWorld().m_151558_() - 1}).m_130940_(ChatFormatting.RED);
                playerEntity.m_213846_((Component)component);
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedRightClicking(Player playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    @Override
    public VoxelShape getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return Shapes.m_83040_();
        }
        return VoxelShapeManager.getInstance().get((IAreaAccessor)context.getMutator().get(), CollisionType.ALL);
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(Player playerEntity, IChiselingContext context, Function<Direction, Vec3> placementFacingAdapter, Function<Vec3, Vec3> fullFacingVectorAdapter) {
        HitResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK || !(rayTraceResult instanceof BlockHitResult)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
        Vec3 hitVector = blockRayTraceResult.m_82450_().m_82549_(placementFacingAdapter.apply(blockRayTraceResult.m_82434_()).m_82542_((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        Vec3 alignmentOffset = Vec3.f_82478_;
        Vec3 fullFacingVector = fullFacingVectorAdapter.apply(this.aligned ? new Vec3(1.0, 1.0, 1.0) : Vec3.m_82528_((Vec3i)RayTracingUtils.getFullFacingVector(playerEntity)));
        if (this.aligned) {
            Vec3 inBlockOffset = hitVector.m_82546_(Vec3.m_82528_((Vec3i)VectorUtils.toInteger(hitVector)));
            BlockPos bitsInBlockOffset = VectorUtils.toBlockPos(inBlockOffset.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
            BlockPos targetedSectionIndices = new BlockPos(bitsInBlockOffset.m_123341_() / this.bitsPerSide, bitsInBlockOffset.m_123342_() / this.bitsPerSide, bitsInBlockOffset.m_123343_() / this.bitsPerSide);
            BlockPos targetedStartPoint = new BlockPos(targetedSectionIndices.m_123341_() * this.bitsPerSide, targetedSectionIndices.m_123342_() * this.bitsPerSide, targetedSectionIndices.m_123343_() * this.bitsPerSide);
            BlockPos targetedBitsInBlockOffset = bitsInBlockOffset.m_121996_((Vec3i)targetedStartPoint);
            alignmentOffset = Vec3.m_82528_((Vec3i)targetedBitsInBlockOffset).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
        }
        Vec3 finalAlignmentOffset = alignmentOffset.m_82559_(fullFacingVector);
        BlockPosStreamProvider.getForRange(this.bitsPerSide).forEach(bitPos -> context.include(hitVector.m_82546_(finalAlignmentOffset).m_82549_(Vec3.m_82528_((Vec3i)bitPos).m_82559_(fullFacingVector).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()))));
        return Optional.empty();
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public Component getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(this.aligned ? ModChiselModeGroups.CUBED_ALIGNED : ModChiselModeGroups.CUBED);
    }
}

