/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import java.util.function.Function;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhood;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhoodBuilder;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockBakedModelManager {
    private static final ChiseledBlockBakedModelManager INSTANCE = new ChiseledBlockBakedModelManager();
    private final SimpleMaxSizedCache<Key, ChiseledBlockBakedModel> cache = new SimpleMaxSizedCache(() -> IClientConfiguration.getInstance().getModelCacheSize().get() * (long)RenderType.m_110506_().size());

    private ChiseledBlockBakedModelManager() {
    }

    public static ChiseledBlockBakedModelManager getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public ChiseledBlockBakedModel get(@NotNull IMultiStateItemStack multiStateItemStack, @NotNull ChiselRenderType chiselRenderType, @NotNull RenderType renderType) {
        try (IProfilerSection ignored = ProfilingManager.getInstance().withSection("Item based chiseled block model");){
            ChiseledBlockBakedModel chiseledBlockBakedModel = this.get(multiStateItemStack, multiStateItemStack.getStatistics().getPrimaryState(), chiselRenderType, null, null, BlockPos.f_121853_, renderType);
            return chiseledBlockBakedModel;
        }
    }

    public ChiseledBlockBakedModel get(@NotNull IAreaAccessor accessor, @NotNull BlockInformation primaryState, @NotNull ChiselRenderType chiselRenderType, @NotNull RenderType renderType) {
        return this.get(accessor, primaryState, chiselRenderType, null, null, BlockPos.f_121853_, renderType);
    }

    public ChiseledBlockBakedModel get(IAreaAccessor accessor, IBlockInformation primaryState, ChiselRenderType chiselRenderType, @Nullable Function<Direction, IBlockInformation> neighborhoodBlockInformationProvider, @Nullable Function<Direction, IAreaAccessor> neighborhoodAreaAccessorProvider, @NotNull BlockPos position, @NotNull RenderType renderType) {
        try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Block based chiseled block model");){
            ChiseledBlockBakedModel chiseledBlockBakedModel = this.get(accessor, primaryState, chiselRenderType, IBlockNeighborhoodBuilder.getInstance().build(neighborhoodBlockInformationProvider, neighborhoodAreaAccessorProvider), position, renderType);
            return chiseledBlockBakedModel;
        }
    }

    public ChiseledBlockBakedModel get(IAreaAccessor accessor, IBlockInformation primaryState, ChiselRenderType chiselRenderType, @NotNull IBlockNeighborhood blockNeighborhood, @NotNull BlockPos position, @NotNull RenderType renderType) {
        try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Block based chiseled block model");){
            long primaryStateRenderSeed = primaryState.getBlockState().m_60726_(position);
            Key key = new Key(accessor.createNewShapeIdentifier(), primaryState, chiselRenderType, blockNeighborhood, primaryStateRenderSeed, renderType);
            ChiseledBlockBakedModel chiseledBlockBakedModel = this.cache.get(key, () -> {
                try (IProfilerSection ignored3 = ProfilingManager.getInstance().withSection("Cache mis");){
                    ChiseledBlockBakedModel chiseledBlockBakedModel = new ChiseledBlockBakedModel(primaryState, chiselRenderType, accessor, targetOffset -> {
                        Vec3 nominalTargetOffset = Vec3.f_82478_.m_82549_(targetOffset);
                        BlockPos nominalTargetBlockOffset = VectorUtils.toBlockPos(nominalTargetOffset);
                        Vec3 inBlockOffset = nominalTargetOffset.m_82546_(Vec3.m_82528_((Vec3i)nominalTargetBlockOffset));
                        Vec3 inBlockOffsetTarget = VectorUtils.makePositive(inBlockOffset);
                        Direction offsetDirection = Direction.m_122372_((float)nominalTargetBlockOffset.m_123341_(), (float)nominalTargetBlockOffset.m_123342_(), (float)nominalTargetBlockOffset.m_123343_());
                        IAreaAccessor neighborAccessor = targetOffset.m_7096_() >= 0.0 && targetOffset.m_7096_() < 1.0 && targetOffset.m_7098_() >= 0.0 && targetOffset.m_7098_() < 1.0 && targetOffset.m_7094_() >= 0.0 && targetOffset.m_7094_() < 1.0 ? accessor : blockNeighborhood.getAreaAccessor(offsetDirection);
                        if (neighborAccessor != null) {
                            return neighborAccessor.getInAreaTarget(inBlockOffsetTarget).map(IStateEntryInfo::getBlockInformation).orElse(BlockInformation.AIR);
                        }
                        return blockNeighborhood.getBlockInformation(offsetDirection);
                    }, primaryStateRenderSeed);
                    return chiseledBlockBakedModel;
                }
            });
            return chiseledBlockBakedModel;
        }
    }

    private record Key(IAreaShapeIdentifier identifier, IBlockInformation primaryState, ChiselRenderType chiselRenderType, IBlockNeighborhood neighborhood, long renderSeed, RenderType renderType) {
    }
}

