/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.inventory.bit;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.inventory.bit.watchable.IWatch;
import mod.chiselsandbits.api.inventory.bit.watchable.IWatchableBitInventory;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.api.util.INBTSerializable;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.inventory.bit.AbstractBitInventory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SlottedBitInventory
extends AbstractBitInventory
implements IWatchableBitInventory,
INBTSerializable<CompoundTag> {
    protected final int size;
    protected final Int2ObjectMap<BitSlot> slotMap = new Int2ObjectArrayMap();
    private final Map<UUID, Runnable> onChangeCallbacks = Maps.newConcurrentMap();

    public SlottedBitInventory(int size) {
        this.size = size;
    }

    @Override
    protected ItemStack getItem(int index) {
        BitSlot bitSlot = (BitSlot)this.slotMap.get(index);
        if (bitSlot == null) {
            return ItemStack.f_41583_;
        }
        return bitSlot.internalStack;
    }

    @Override
    protected int getInventorySize() {
        return this.size;
    }

    @Override
    protected void setSlotContents(int index, ItemStack stack) {
        if (stack.m_41619_()) {
            this.slotMap.remove(index);
            this.onChange();
            return;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof IBitItem)) {
            throw new IllegalArgumentException("Can not insert a none bit item into the inventory.");
        }
        IBitItem bitItem = (IBitItem)item;
        IBlockInformation state = bitItem.getBlockInformation(stack);
        BitSlot slot = (BitSlot)this.slotMap.get(index);
        if (slot == null) {
            slot = new BitSlot();
        }
        slot.setBlockInformation(state);
        slot.setCount(stack.m_41613_());
        if (!this.slotMap.containsKey(index)) {
            this.slotMap.put(index, (Object)slot);
        }
        this.onChange();
    }

    @Override
    public IWatch startWatching(Runnable onChangeCallback) {
        UUID id = UUID.randomUUID();
        this.onChangeCallbacks.put(id, onChangeCallback);
        return () -> this.onChangeCallbacks.remove(id);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag data = new CompoundTag();
        this.slotMap.forEach((index, slot) -> data.m_128365_(index.toString(), (Tag)slot.serializeNBT()));
        return data;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.slotMap.clear();
        nbt.m_128431_().forEach(indexRep -> {
            int index = Integer.parseInt(indexRep);
            BitSlot slot = new BitSlot();
            slot.deserializeNBT(nbt.m_128469_(indexRep));
            this.slotMap.put(index, (Object)slot);
        });
        this.onChange();
    }

    protected Collection<BitSlot> getContents() {
        return this.slotMap.values();
    }

    protected void onChange() {
        this.onChangeCallbacks.values().forEach(Runnable::run);
    }

    @Override
    public boolean m_7983_() {
        return this.slotMap.isEmpty() || this.slotMap.values().stream().allMatch(slot -> slot.getCount() == 0);
    }

    protected static final class BitSlot
    implements INBTSerializable<CompoundTag>,
    IPacketBufferSerializable {
        private IBlockInformation blockInformation = BlockInformation.AIR;
        private ItemStack internalStack = ItemStack.f_41583_;

        public BitSlot() {
        }

        public BitSlot(IBlockInformation blockInformation, int count) {
            this.blockInformation = blockInformation;
            this.internalStack = IBitItemManager.getInstance().create(blockInformation, count);
        }

        @Override
        public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
            this.blockInformation.serializeInto(packetBuffer);
            packetBuffer.m_130130_(this.getCount());
        }

        @Override
        public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
            this.blockInformation = new BlockInformation(packetBuffer);
            int count = packetBuffer.m_130242_();
            this.internalStack = IBitItemManager.getInstance().create(this.blockInformation, count);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag data = new CompoundTag();
            data.m_128365_("block_information", this.blockInformation.serializeNBT());
            data.m_128405_("count", this.getCount());
            return data;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            this.blockInformation = new BlockInformation(nbt.m_128469_("block_information"));
            int count = nbt.m_128451_("count");
            this.internalStack = IBitItemManager.getInstance().create(this.blockInformation, count);
        }

        public IBlockInformation getBlockInformation() {
            return this.blockInformation;
        }

        public int getCount() {
            return this.internalStack.m_41613_();
        }

        public void setBlockInformation(IBlockInformation blockInformation) {
            if (this.blockInformation.equals(blockInformation)) {
                return;
            }
            this.blockInformation = blockInformation;
            this.internalStack = IBitItemManager.getInstance().create(blockInformation, 1);
        }

        public void setCount(int count) {
            this.internalStack.m_41764_(count);
        }
    }
}

