/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import com.communi.suggestu.scena.core.dist.Dist;
import com.communi.suggestu.scena.core.dist.DistExecutor;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.measuring.IMeasuringTapeItem;
import mod.chiselsandbits.api.measuring.MeasuringMode;
import mod.chiselsandbits.api.util.BlockHitResultUtils;
import mod.chiselsandbits.api.util.HelpTextUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.keys.KeyBindingManager;
import mod.chiselsandbits.measures.MeasuringManager;
import mod.chiselsandbits.network.packets.MeasurementsResetPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeasuringTapeItem
extends Item
implements IMeasuringTapeItem {
    public MeasuringTapeItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @NotNull
    public MeasuringMode getMode(ItemStack stack) {
        if (!stack.m_41784_().m_128441_("mode")) {
            return MeasuringMode.WHITE_BIT;
        }
        return MeasuringMode.valueOf(stack.m_41784_().m_128461_("mode"));
    }

    @Override
    public void setMode(ItemStack stack, MeasuringMode mode) {
        if (mode == null) {
            return;
        }
        stack.m_41784_().m_128359_("mode", mode.toString());
    }

    @Override
    @NotNull
    public Collection<MeasuringMode> getPossibleModes() {
        return Lists.newArrayList((Object[])MeasuringMode.values());
    }

    @Override
    public ClickProcessingState handleRightClickProcessing(Player playerEntity, InteractionHand hand, BlockPos position, Direction face, ClickProcessingState currentState) {
        ClickProcessingState result = ClickProcessingState.DEFAULT;
        ItemStack stack = playerEntity.m_21120_(hand);
        if (stack.m_41720_() == this) {
            if (((Boolean)DistExecutor.unsafeRunForDist(() -> () -> KeyBindingManager.getInstance().isResetMeasuringTapeKeyPressed(), () -> () -> false)).booleanValue()) {
                this.clear(stack);
                ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new MeasurementsResetPacket());
            } else {
                HitResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
                if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK && rayTraceResult instanceof BlockHitResult) {
                    BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
                    Optional<Vec3> startPointHandler = this.getStart(stack);
                    if (startPointHandler.isEmpty()) {
                        this.setStart(stack, this.getMode(stack).getType().adaptClickedPosition(blockRayTraceResult));
                    } else {
                        Vec3 startPoint = startPointHandler.get();
                        Vec3 hitVector = BlockHitResultUtils.getCenterOfHitObject(blockRayTraceResult, this.getMode(stack).getType().getResolution());
                        MeasuringManager.getInstance().createAndSend(startPoint, this.getMode(stack).getType().adaptClickedPosition(blockRayTraceResult), blockRayTraceResult.m_82434_(), this.getMode(stack));
                        this.clear(stack);
                    }
                    result = ClickProcessingState.ALLOW;
                }
            }
        }
        return result;
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.m_5776_()) {
            return;
        }
        if (!(entityIn instanceof Player)) {
            return;
        }
        Player playerEntity = (Player)entityIn;
        if (stack.m_41720_() != this) {
            return;
        }
        Optional<Vec3> startPointHandler = this.getStart(stack);
        if (startPointHandler.isEmpty()) {
            return;
        }
        if (KeyBindingManager.getInstance().isResetMeasuringTapeKeyPressed()) {
            this.clear(stack);
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new MeasurementsResetPacket());
            return;
        }
        HitResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK || !(rayTraceResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
        Vec3 hitVector = blockRayTraceResult.m_82450_();
        Vec3 startPoint = startPointHandler.get();
        MeasuringManager.getInstance().createAndSend(startPoint, this.getMode(stack).getType().adaptClickedPosition(blockRayTraceResult), blockRayTraceResult.m_82434_(), this.getMode(stack));
    }

    @Override
    @NotNull
    public Optional<Vec3> getStart(@NotNull ItemStack stack) {
        if (!stack.m_41784_().m_128441_("start")) {
            return Optional.empty();
        }
        CompoundTag start = stack.m_41784_().m_128469_("start");
        return Optional.of(new Vec3(start.m_128459_("x"), start.m_128459_("y"), start.m_128459_("z")));
    }

    @Override
    public void setStart(@NotNull ItemStack stack, @NotNull Vec3 start) {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128347_("x", start.m_7096_());
        compoundNBT.m_128347_("y", start.m_7098_());
        compoundNBT.m_128347_("z", start.m_7094_());
        stack.m_41784_().m_128365_("start", (Tag)compoundNBT);
    }

    @Override
    public void clear(@NotNull ItemStack stack) {
        stack.m_41784_().m_128473_("start");
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (KeyBindingManager.getInstance().hasBeenInitialized()) {
                HelpTextUtils.build(LocalStrings.HelpTapeMeasure, tooltip, Minecraft.m_91087_().f_91066_.f_92095_.m_90863_(), Minecraft.m_91087_().f_91066_.f_92095_.m_90863_(), KeyBindingManager.getInstance().getResetMeasuringTapeKeyBinding().m_90863_(), KeyBindingManager.getInstance().getOpenToolMenuKeybinding().m_90863_());
            }
        });
    }
}

