/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.connected.plane;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.IQuadFunction;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.registrars.ModMetadataKeys;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ConnectedPlaneChiselingMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final int depth;
    private final MutableComponent displayName;
    private final MutableComponent multiLineDisplayName;
    private final ResourceLocation iconName;

    public ConnectedPlaneChiselingMode(int depth, MutableComponent displayName, MutableComponent multiLineDisplayName, ResourceLocation iconName) {
        this.depth = depth;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(Player playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, Direction::m_122424_, face -> Vec3.m_82528_((Vec3i)face.m_122424_().m_122436_()), IQuadFunction.fourthIdentity(), position -> IMutatorFactory.getInstance().in(context.getWorld(), VectorUtils.toBlockPos(position)), direction -> Vec3i.f_123288_);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                context.setComplete();
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(builder -> (Predicate)builder.apply(mutator)).orElse(state -> true);
                int totalDamage = mutator.inWorldMutableStream().filter(filter).mapToInt(state -> {
                    IBlockInformation currentState = state.getBlockInformation();
                    return context.tryDamageItemAndDoOrSetBrokenError(() -> {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    });
                }).sum();
                if (totalDamage == 0) {
                    context.setError(LocalStrings.ChiselAttemptFailedNoValidStateFound.getText());
                }
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(Player playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(Player playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, UnaryOperator.identity(), face -> Vec3.m_82528_((Vec3i)face.m_122436_()), (hitPos, inBlockTargetedPosition, hitFace, candidatePosition) -> {
            if (inBlockTargetedPosition.equals(candidatePosition)) {
                return Vec3.m_82528_((Vec3i)hitPos).m_82549_(inBlockTargetedPosition).m_82549_(Vec3.m_82528_((Vec3i)hitFace.m_122424_().m_122436_()).m_82559_(StateEntrySize.current().getSizePerBitScalingVector()));
            }
            Vec3 relevantAxisCandidate = candidatePosition.m_82542_((double)Math.abs(hitFace.m_122436_().m_123341_()), (double)Math.abs(hitFace.m_122436_().m_123342_()), (double)Math.abs(hitFace.m_122436_().m_123343_()));
            Vec3 noneRelevantAxisCandidates = candidatePosition.m_82546_(relevantAxisCandidate);
            Vec3 relevantAxisTarget = inBlockTargetedPosition.m_82542_((double)Math.abs(hitFace.m_122436_().m_123341_()), (double)Math.abs(hitFace.m_122436_().m_123342_()), (double)Math.abs(hitFace.m_122436_().m_123343_()));
            Vec3 offset = candidatePosition.m_82546_(inBlockTargetedPosition);
            Vec3 relevantAxisOffset = offset.m_82542_((double)Math.abs(hitFace.m_122436_().m_123341_()), (double)Math.abs(hitFace.m_122436_().m_123342_()), (double)Math.abs(hitFace.m_122436_().m_123343_()));
            return noneRelevantAxisCandidates.m_82549_(relevantAxisTarget).m_82546_(relevantAxisOffset).m_82520_((double)hitPos.m_123341_(), (double)hitPos.m_123342_(), (double)hitPos.m_123343_()).m_82549_(Vec3.m_82528_((Vec3i)hitFace.m_122424_().m_122436_()).m_82559_(StateEntrySize.current().getSizePerBitScalingVector()));
        }, position -> IMutatorFactory.getInstance().covering(context.getWorld(), VectorUtils.toBlockPos(position.m_82492_(1.0, 1.0, 1.0)), VectorUtils.toBlockPos(position.m_82520_(1.0, 1.0, 1.0))), direction -> new Vec3i(direction.m_122436_().m_123341_() * this.depth, direction.m_122436_().m_123342_() * this.depth, direction.m_122436_().m_123343_() * this.depth));
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            IBlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(playerEntity);
            if (heldBlockState.isAir()) {
                context.setError(LocalStrings.ChiselAttemptFailedNoPlaceableBitHeld.getText());
                return ClickProcessingState.DEFAULT;
            }
            Predicate<IStateEntryInfo> filter = context.getStateFilter().map(builder -> (Predicate)builder.apply(mutator)).orElse(state -> true);
            int missingBitCount = (int)mutator.stream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.m_7500_()) {
                if (!playerEntity.m_7500_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().m_60734_().m_49954_()));
            }
            if (missingBitCount == 0) {
                BlockPos heightPos = mutator.getInWorldEndBlockPoint();
                if (heightPos.m_123342_() >= context.getWorld().m_151558_()) {
                    context.setError(LocalStrings.ChiselAttemptFailedAttemptTooHigh.getText());
                } else if (heightPos.m_123342_() <= context.getWorld().m_141937_()) {
                    context.setError(LocalStrings.ChiselAttemptFailedAttemptTooLow.getText());
                }
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedRightClicking(Player playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    @Override
    public boolean isStillValid(Player playerEntity, IChiselingContext context, ChiselingOperation modeOfOperation) {
        Optional<Set<Vec3i>> validPositions = context.getMetadata(ModMetadataKeys.VALID_POSITIONS.get());
        Optional<Direction> targetedSide = context.getMetadata(ModMetadataKeys.TARGETED_SIDE.get());
        Optional<BlockPos> targetedBlockPos = context.getMetadata(ModMetadataKeys.TARGETED_BLOCK.get());
        if (validPositions.isEmpty() || targetedSide.isEmpty() || targetedBlockPos.isEmpty()) {
            return false;
        }
        HitResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK || !(rayTraceResult instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
        if (blockRayTraceResult.m_82434_() != targetedSide.get()) {
            return false;
        }
        Function<Direction, Vec3> placementFacingAdapter = modeOfOperation == ChiselingOperation.CHISELING ? face -> Vec3.m_82528_((Vec3i)face.m_122424_().m_122436_()) : face -> Vec3.m_82528_((Vec3i)face.m_122436_());
        Vec3 hitVector = blockRayTraceResult.m_82450_().m_82549_(placementFacingAdapter.apply(blockRayTraceResult.m_82434_()).m_82542_((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        BlockPos hitPos = VectorUtils.toBlockPos(hitVector);
        Vec3 hitBlockPosVector = Vec3.m_82528_((Vec3i)hitPos);
        Vec3 inBlockHitVector = hitVector.m_82546_(hitBlockPosVector);
        Vec3i selectedPosition = VectorUtils.toInteger(inBlockHitVector.m_7096_() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.m_7098_() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.m_7094_() * (double)StateEntrySize.current().getBitsPerBlockSide());
        return validPositions.get().contains(selectedPosition) && hitPos.equals((Object)targetedBlockPos.get());
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(Player playerEntity, IChiselingContext context, UnaryOperator<Direction> searchDirectionAdapter, Function<Direction, Vec3> placementFacingAdapter, IQuadFunction<BlockPos, Vec3, Direction, Vec3, Vec3> stateExtractionAdapter, Function<Vec3, IAreaAccessor> areaAccessorBuilder, Function<Direction, Vec3i> filterOffsetProducer) {
        HitResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK || !(rayTraceResult instanceof BlockHitResult)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
        Vec3 hitVector = blockRayTraceResult.m_82450_().m_82549_(placementFacingAdapter.apply(blockRayTraceResult.m_82434_()).m_82542_((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        BlockPos hitPos = VectorUtils.toBlockPos(hitVector);
        Vec3 hitBlockPosVector = Vec3.m_82528_((Vec3i)hitPos);
        Vec3 inBlockHitVector = hitVector.m_82546_(hitBlockPosVector);
        LinkedList<Vec3i> toProcess = new LinkedList<Vec3i>();
        IAreaAccessor worldAccessor = areaAccessorBuilder.apply(hitVector);
        HashSet<Vec3i> processed = new HashSet<Vec3i>();
        HashSet<Vec3i> validPositions = new HashSet<Vec3i>();
        HashSet<Vec3i> offsets = new HashSet<Vec3i>();
        offsets.add(((Direction)searchDirectionAdapter.apply(blockRayTraceResult.m_82434_())).m_122436_());
        Arrays.stream(Direction.values()).filter(direction -> direction.m_122434_() != blockRayTraceResult.m_82434_().m_122434_()).map(Direction::m_122436_).forEach(offsets::add);
        Vec3i selectedPosition = VectorUtils.toInteger(inBlockHitVector.m_7096_() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.m_7098_() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.m_7094_() * (double)StateEntrySize.current().getBitsPerBlockSide());
        toProcess.addLast(selectedPosition);
        Vec3i relevantSelectedAxisVector = new Vec3i(selectedPosition.m_123341_() * Math.abs(blockRayTraceResult.m_82434_().m_122436_().m_123341_()), selectedPosition.m_123342_() * Math.abs(blockRayTraceResult.m_82434_().m_122436_().m_123342_()), selectedPosition.m_123343_() * Math.abs(blockRayTraceResult.m_82434_().m_122436_().m_123343_()));
        Vec3 selectedInBlockPosition = Vec3.m_82528_((Vec3i)selectedPosition).m_82559_(StateEntrySize.current().getSizePerBitScalingVector());
        Optional<IStateEntryInfo> targetedInfo = worldAccessor.getInAreaTarget(stateExtractionAdapter.apply(hitPos, selectedInBlockPosition, blockRayTraceResult.m_82434_(), selectedInBlockPosition));
        if (targetedInfo.isEmpty()) {
            context.setError(LocalStrings.ChiselAttemptFailedTargetedBlockNotChiselable.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        while (!toProcess.isEmpty()) {
            IStateEntryInfo target;
            Vec3i targetedPosition = (Vec3i)toProcess.removeFirst();
            Vec3 targetedInBlockPosition = Vec3.m_82528_((Vec3i)targetedPosition).m_82559_(StateEntrySize.current().getSizePerBitScalingVector());
            Optional<IStateEntryInfo> targetCandidate = worldAccessor.getInAreaTarget(stateExtractionAdapter.apply(hitPos, selectedInBlockPosition, blockRayTraceResult.m_82434_(), targetedInBlockPosition));
            processed.add(targetedPosition);
            if (targetCandidate.isEmpty() || !(target = targetCandidate.get()).getBlockInformation().equals(targetedInfo.get().getBlockInformation())) continue;
            validPositions.add(targetedPosition);
            offsets.forEach(offset -> {
                Vec3i newTarget = new Vec3i(targetedPosition.m_123341_() + offset.m_123341_(), targetedPosition.m_123342_() + offset.m_123342_(), targetedPosition.m_123343_() + offset.m_123343_());
                if (newTarget.m_123341_() >= 0 && newTarget.m_123341_() < StateEntrySize.current().getBitsPerBlockSide() && newTarget.m_123342_() >= 0 && newTarget.m_123342_() < StateEntrySize.current().getBitsPerBlockSide() && newTarget.m_123343_() >= 0 && newTarget.m_123343_() < StateEntrySize.current().getBitsPerBlockSide()) {
                    Vec3i relevantNewTargetAxisVector = new Vec3i(newTarget.m_123341_() * Math.abs(blockRayTraceResult.m_82434_().m_122436_().m_123341_()), newTarget.m_123342_() * Math.abs(blockRayTraceResult.m_82434_().m_122436_().m_123342_()), newTarget.m_123343_() * Math.abs(blockRayTraceResult.m_82434_().m_122436_().m_123343_()));
                    int targetedDepth = Math.abs(relevantSelectedAxisVector.m_123304_(blockRayTraceResult.m_82434_().m_122434_()) - relevantNewTargetAxisVector.m_123304_(blockRayTraceResult.m_82434_().m_122434_()));
                    if (targetedDepth <= this.depth - 1 && !processed.contains(newTarget) && !toProcess.contains(newTarget)) {
                        toProcess.addLast(newTarget);
                    }
                } else {
                    processed.add(newTarget);
                }
            });
        }
        context.include(hitPos, Vec3.f_82478_);
        context.include(hitPos, new Vec3(0.9999, 0.9999, 0.9999));
        context.setStateFilter(accessor -> new SelectedBitStateFilter((Vec3i)filterOffsetProducer.apply(blockRayTraceResult.m_82434_()), validPositions));
        context.setMetadata(ModMetadataKeys.VALID_POSITIONS.get(), validPositions);
        context.setMetadata(ModMetadataKeys.TARGETED_SIDE.get(), blockRayTraceResult.m_82434_());
        context.setMetadata(ModMetadataKeys.TARGETED_BLOCK.get(), hitPos);
        return Optional.empty();
    }

    @Override
    public VoxelShape getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return Shapes.m_83040_();
        }
        return VoxelShapeManager.getInstance().get((IAreaAccessor)context.getMutator().get(), CollisionType.ALL);
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.CONNECTED_PLANE);
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public Component getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    private static final class SelectedBitStateFilter
    implements Predicate<IStateEntryInfo> {
        private final Vec3i offset;
        private final Set<Vec3i> validPositions;

        public SelectedBitStateFilter(Vec3i offset, Set<Vec3i> validPositions) {
            this.offset = offset;
            this.validPositions = validPositions;
        }

        @Override
        public boolean test(IStateEntryInfo iStateEntryInfo) {
            Vec3i position = VectorUtils.toInteger(iStateEntryInfo.getStartPoint().m_7096_() * (double)StateEntrySize.current().getBitsPerBlockSide(), iStateEntryInfo.getStartPoint().m_7098_() * (double)StateEntrySize.current().getBitsPerBlockSide(), iStateEntryInfo.getStartPoint().m_7094_() * (double)StateEntrySize.current().getBitsPerBlockSide());
            return this.validPositions.contains(position);
        }

        public int hashCode() {
            int result = this.offset.hashCode();
            result = 31 * result + this.validPositions.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SelectedBitStateFilter)) {
                return false;
            }
            SelectedBitStateFilter that = (SelectedBitStateFilter)o;
            if (!this.offset.equals((Object)that.offset)) {
                return false;
            }
            return this.validPositions.equals(that.validPositions);
        }

        public String toString() {
            return "SelectedBitStateFilter{offset=" + this.offset + ", validPositions=" + this.validPositions + "}";
        }
    }
}

