/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.cutting.operation;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.cutting.operation.ICuttingOperation;
import mod.chiselsandbits.api.cutting.operation.ICuttingOperationGroup;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IGenerallyModifiableAreaMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.multistate.mutator.MutatorFactory;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CutAcrossCenterAxisCuttingOperation
extends AbstractCustomRegistryEntry
implements ICuttingOperation {
    private final Direction.Axis axis;

    public CutAcrossCenterAxisCuttingOperation(Direction.Axis axis) {
        this.axis = axis;
    }

    @Override
    public Collection<IAreaAccessor> apply(IAreaAccessor source) {
        AABB box = source.getBoundingBox();
        Vec3 size = new Vec3(box.m_82362_(), box.m_82376_(), box.m_82385_());
        IGenerallyModifiableAreaMutator preAxisMutator = MutatorFactory.getInstance().clonedFromAccessor(source);
        IGenerallyModifiableAreaMutator postAxisMutator = MutatorFactory.getInstance().clonedFromAccessor(source);
        Function<Vec3, Double> axisValueSelectorFunction = vec3 -> vec3.m_82507_(this.axis);
        double sizeAxisSeparator = size.m_82507_(this.axis);
        Predicate<IStateEntryInfo> preAxisPredicate = info -> (Double)axisValueSelectorFunction.apply(info.getStartPoint()) < sizeAxisSeparator;
        Predicate<IStateEntryInfo> postAxisPredicate = info -> (Double)axisValueSelectorFunction.apply(info.getEndPoint()) >= sizeAxisSeparator;
        preAxisMutator.mutableStream().filter(preAxisPredicate).forEach(IMutableStateEntryInfo::clear);
        postAxisMutator.mutableStream().filter(postAxisPredicate).forEach(IMutableStateEntryInfo::clear);
        return ImmutableList.of((Object)preAxisMutator, (Object)postAxisMutator);
    }

    @Override
    @NotNull
    public Optional<ICuttingOperationGroup> getGroup() {
        return Optional.empty();
    }

    @Override
    public Component getDisplayName() {
        return switch (this.axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> LocalStrings.PatternCuttingAcrossXAxis.getText();
            case Direction.Axis.Y -> LocalStrings.PatternCuttingAcrossYAxis.getText();
            case Direction.Axis.Z -> LocalStrings.PatternCuttingAcrossZAxis.getText();
        };
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return null;
    }
}

