/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked;

import com.communi.suggestu.scena.core.client.models.vertices.IVertexConsumer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import mod.chiselsandbits.utils.LightUtil;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;

public class BakedQuadBuilder
implements IVertexConsumer {
    private static final int SIZE = DefaultVertexFormat.f_85811_.m_86023_().size();
    private final float[][][] unpackedData = new float[4][SIZE][4];
    private int tint = -1;
    private Direction orientation;
    private TextureAtlasSprite texture;
    private boolean applyDiffuseLighting = true;
    private int vertices = 0;
    private int elements = 0;
    private boolean full = false;

    public BakedQuadBuilder(TextureAtlasSprite texture) {
        this.texture = texture;
    }

    protected BakedQuadBuilder() {
    }

    public VertexFormat getVertexFormat() {
        return DefaultVertexFormat.f_85811_;
    }

    public void setQuadTint(int tint) {
        this.tint = tint;
    }

    public void setQuadOrientation(Direction orientation) {
        this.orientation = orientation;
    }

    public void setTexture(TextureAtlasSprite texture) {
        this.texture = texture;
    }

    public void setApplyDiffuseLighting(boolean diffuse) {
        this.applyDiffuseLighting = diffuse;
    }

    public void put(int vertexIndex, int element, float ... data) {
        for (int i = 0; i < 4; ++i) {
            this.unpackedData[this.vertices][element][i] = i < data.length ? data[i] : 0.0f;
        }
        ++this.elements;
        if (this.elements == SIZE) {
            ++this.vertices;
            this.elements = 0;
        }
        if (this.vertices == 4) {
            this.full = true;
        }
    }

    public BakedQuad build() {
        if (!this.full) {
            throw new IllegalStateException("not enough data");
        }
        if (this.texture == null) {
            throw new IllegalStateException("texture not set");
        }
        int[] packed = new int[DefaultVertexFormat.f_85811_.m_86017_() * 4];
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < SIZE; ++e) {
                LightUtil.pack(this.unpackedData[v][e], packed, v, e);
            }
        }
        return new BakedQuad(packed, this.tint, this.orientation, this.texture, this.applyDiffuseLighting);
    }
}

