/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import com.communi.suggestu.scena.core.client.models.IModelManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.client.culling.ICullTest;
import mod.chiselsandbits.client.model.baked.base.BaseBakedBlockModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockModelBuilder;
import mod.chiselsandbits.client.model.baked.face.FaceRegion;
import mod.chiselsandbits.client.util.QuadGenerationUtils;
import mod.chiselsandbits.profiling.ProfilingManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ChiseledBlockBakedModel
extends BaseBakedBlockModel {
    public static final ChiseledBlockBakedModel EMPTY = new ChiseledBlockBakedModel(BlockInformation.AIR, ChiselRenderType.SOLID, null, vector3d -> BlockInformation.AIR, 0L);
    private static final Direction[] X_Faces = new Direction[]{Direction.EAST, Direction.WEST};
    private static final Direction[] Y_Faces = new Direction[]{Direction.UP, Direction.DOWN};
    private static final Direction[] Z_Faces = new Direction[]{Direction.SOUTH, Direction.NORTH};
    private final ChiselRenderType chiselRenderType;
    private BakedQuad[] up;
    private BakedQuad[] down;
    private BakedQuad[] north;
    private BakedQuad[] south;
    private BakedQuad[] east;
    private BakedQuad[] west;
    private BakedQuad[] generic;

    private List<BakedQuad> getList(Direction side) {
        if (side != null) {
            switch (side) {
                case DOWN: {
                    return this.asList(this.down);
                }
                case EAST: {
                    return this.asList(this.east);
                }
                case NORTH: {
                    return this.asList(this.north);
                }
                case SOUTH: {
                    return this.asList(this.south);
                }
                case UP: {
                    return this.asList(this.up);
                }
                case WEST: {
                    return this.asList(this.west);
                }
            }
        }
        return this.asList(this.generic);
    }

    private List<BakedQuad> asList(BakedQuad[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public ChiseledBlockBakedModel(IBlockInformation state, ChiselRenderType layer, IAreaAccessor data, Function<Vec3, IBlockInformation> neighborStateSupplier, long primaryStateRenderSeed) {
        this.chiselRenderType = layer;
        BakedModel originalModel = null;
        if (state != null && !state.isAir()) {
            originalModel = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(state.getBlockState());
            originalModel = IModelManager.getInstance().adaptToPlatform(originalModel);
        }
        if (originalModel != null && data != null) {
            boolean shouldLayerRender;
            try (IProfilerSection ignoredLayerCheck = ProfilingManager.getInstance().withSection("check");){
                shouldLayerRender = layer.isRequiredForRendering(data);
            }
            if (shouldLayerRender) {
                ChiseledBlockModelBuilder builder = new ChiseledBlockModelBuilder();
                try (IProfilerSection ignoredFaceGeneration = ProfilingManager.getInstance().withSection("facegeneration");){
                    this.generateFaces(builder, data, neighborStateSupplier, primaryStateRenderSeed);
                }
                try (IProfilerSection ignoredFinalize = ProfilingManager.getInstance().withSection("finalize");){
                    this.up = builder.getSide(Direction.UP);
                    this.down = builder.getSide(Direction.DOWN);
                    this.east = builder.getSide(Direction.EAST);
                    this.west = builder.getSide(Direction.WEST);
                    this.north = builder.getSide(Direction.NORTH);
                    this.south = builder.getSide(Direction.SOUTH);
                    this.generic = builder.getSide(null);
                }
            }
        }
    }

    public boolean isEmpty() {
        boolean trulyEmpty = this.getList(null).isEmpty();
        for (Direction e : Direction.values()) {
            trulyEmpty = trulyEmpty && this.getList(e).isEmpty();
        }
        return trulyEmpty;
    }

    private void generateFaces(ChiseledBlockModelBuilder builder, IAreaAccessor accessor, Function<Vec3, IBlockInformation> neighborStateSupplier, long primaryStateRenderSeed) {
        ArrayList<List<FaceRegion>> resultingFaces = new ArrayList<List<FaceRegion>>();
        try (IProfilerSection ignoredFaceProcessing = ProfilingManager.getInstance().withSection("processing");){
            try (IProfilerSection ignoredXFaces = ProfilingManager.getInstance().withSection("x");){
                this.processFaces(accessor, resultingFaces, IPositionMutator.xzy(), X_Faces, Vec3::m_7096_, Vec3::m_7094_, neighborStateSupplier);
            }
            ignoredXFaces = ProfilingManager.getInstance().withSection("y");
            try {
                this.processFaces(accessor, resultingFaces, IPositionMutator.zxy(), Y_Faces, Vec3::m_7098_, Vec3::m_7094_, neighborStateSupplier);
            }
            finally {
                if (ignoredXFaces != null) {
                    ignoredXFaces.close();
                }
            }
            ignoredXFaces = ProfilingManager.getInstance().withSection("z");
            try {
                this.processFaces(accessor, resultingFaces, IPositionMutator.zyx(), Z_Faces, Vec3::m_7094_, Vec3::m_7098_, neighborStateSupplier);
            }
            finally {
                if (ignoredXFaces != null) {
                    ignoredXFaces.close();
                }
            }
        }
        try (IProfilerSection ignoredFaceBuilding = ProfilingManager.getInstance().withSection("building");){
            try (IProfilerSection ignoredMerging = ProfilingManager.getInstance().withSection("merging");){
                for (List list : resultingFaces) {
                    this.mergeFaces(list);
                }
            }
            try (IProfilerSection ignoredQuadGeneration = ProfilingManager.getInstance().withSection("quadGeneration");){
                for (List list : resultingFaces) {
                    for (FaceRegion region : list) {
                        Direction cullDirection = region.getFace();
                        Vector3f from = region.minVector();
                        Vector3f to = region.maxVector();
                        List<BakedQuad> target = builder.getList(null);
                        if (region.isEdge()) {
                            target = builder.getList(cullDirection);
                        }
                        QuadGenerationUtils.generateQuads(target, primaryStateRenderSeed, this.chiselRenderType.layer, region.getBlockInformation(), cullDirection, from, to);
                    }
                }
            }
        }
    }

    private void mergeFaces(List<FaceRegion> src) {
        boolean restart;
        block0: do {
            restart = false;
            int size = src.size();
            int sizeMinusOne = size - 1;
            for (int x = 0; x < sizeMinusOne; ++x) {
                FaceRegion faceA = src.get(x);
                for (int y = x + 1; y < size; ++y) {
                    FaceRegion faceB = src.get(y);
                    if (!faceA.extend(faceB)) continue;
                    src.set(y, src.get(sizeMinusOne));
                    src.remove(sizeMinusOne);
                    restart = true;
                    continue block0;
                }
            }
        } while (restart);
    }

    private void processFaces(final IAreaAccessor accessor, final List<List<FaceRegion>> resultingRegions, IPositionMutator analysisOrder, Direction[] potentialDirections, final Function<Vec3, Double> regionBuildingAxisValueExtractor, final Function<Vec3, Double> faceBuildingAxisValueExtractor, final Function<Vec3, IBlockInformation> neighborStateSupplier) {
        final ArrayList regions = Lists.newArrayList();
        final ICullTest test = this.chiselRenderType.getTest();
        for (final Direction facing : potentialDirections) {
            final FaceBuildingState state = new FaceBuildingState();
            accessor.forEachWithPositionMutator(analysisOrder, new Consumer<IStateEntryInfo>(){

                @Override
                public void accept(IStateEntryInfo stateEntryInfo) {
                    if (!ChiseledBlockBakedModel.this.chiselRenderType.isRequiredForRendering(stateEntryInfo)) {
                        return;
                    }
                    if (state.getRegionBuildingAxisValue() != ((Double)regionBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint())).doubleValue()) {
                        if (!regions.isEmpty()) {
                            resultingRegions.add(Lists.newArrayList((Iterable)regions));
                        }
                        regions.clear();
                        state.setCurrentRegion(null);
                    }
                    state.setRegionBuildingAxisValue((Double)regionBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint()));
                    if (state.getFaceBuildingAxisValue() != ((Double)faceBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint())).doubleValue()) {
                        state.setCurrentRegion(null);
                    }
                    state.setFaceBuildingAxisValue((Double)faceBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint()));
                    Optional<FaceRegion> potentialRegionData = ChiseledBlockBakedModel.this.buildFaceRegion(accessor, facing, stateEntryInfo, test, neighborStateSupplier);
                    if (potentialRegionData.isEmpty()) {
                        state.setCurrentRegion(null);
                        return;
                    }
                    if (state.getCurrentRegion() != null && state.getCurrentRegion().extend(potentialRegionData.get())) {
                        return;
                    }
                    state.setCurrentRegion(potentialRegionData.get());
                    regions.add(potentialRegionData.get());
                }
            });
            if (!regions.isEmpty()) {
                resultingRegions.add(Lists.newArrayList((Iterable)regions));
            }
            regions.clear();
        }
    }

    private Optional<FaceRegion> buildFaceRegion(IAreaAccessor blob, Direction facing, IStateEntryInfo target, ICullTest test, Function<Vec3, IBlockInformation> neighborStateSupplier) {
        return Optional.of(target).filter(stateEntryInfo -> {
            Vec3 faceOffSet = Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            Vec3 offsetTarget = stateEntryInfo.getStartPoint().m_82549_(faceOffSet);
            if (!blob.isInside(offsetTarget)) {
                IBlockInformation externalNeighborState = (IBlockInformation)neighborStateSupplier.apply(offsetTarget);
                return Optional.of(externalNeighborState).map(neighborState -> test.isVisible((IStateEntryInfo)stateEntryInfo, (IBlockInformation)neighborState, facing)).orElseGet(() -> !stateEntryInfo.getBlockInformation().isAir());
            }
            return blob.getInAreaTarget(offsetTarget).map(IStateEntryInfo::getBlockInformation).map(neighborState -> test.isVisible((IStateEntryInfo)stateEntryInfo, (IBlockInformation)neighborState, facing)).orElseGet(() -> !stateEntryInfo.getBlockInformation().isAir());
        }).map(stateEntryInfo -> {
            Vec3 faceOffSet = Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            Vec3 offsetTarget = stateEntryInfo.getStartPoint().m_82549_(faceOffSet);
            return FaceRegion.createFrom3DObjectWithFacing(stateEntryInfo.getStartPoint(), stateEntryInfo.getEndPoint(), facing, stateEntryInfo.getBlockInformation(), !blob.isInside(offsetTarget));
        });
    }

    @NotNull
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return this.getList(side);
    }

    public boolean m_7547_() {
        return true;
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
    }

    private static final class FaceBuildingState {
        private double regionBuildingAxis = -1.0;
        private double faceBuildingAxis = -1.0;
        private FaceRegion currentRegion;

        private FaceBuildingState() {
        }

        public double getRegionBuildingAxisValue() {
            return this.regionBuildingAxis;
        }

        public void setRegionBuildingAxisValue(double regionBuildingAxis) {
            this.regionBuildingAxis = regionBuildingAxis;
        }

        public double getFaceBuildingAxisValue() {
            return this.faceBuildingAxis;
        }

        public void setFaceBuildingAxisValue(double faceBuildingAxis) {
            this.faceBuildingAxis = faceBuildingAxis;
        }

        public FaceRegion getCurrentRegion() {
            return this.currentRegion;
        }

        public void setCurrentRegion(FaceRegion currentRegion) {
            this.currentRegion = currentRegion;
        }
    }
}

