/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import com.communi.suggestu.scena.core.client.models.data.IBlockModelData;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.client.model.baked.base.BaseSmartModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.model.baked.simple.CombinedModel;
import mod.chiselsandbits.client.model.baked.simple.NullBakedModel;
import mod.chiselsandbits.client.util.BlockInformationUtils;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.registrars.ModModelProperties;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataAwareChiseledBlockBakedModel
extends BaseSmartModel {
    private static final SimpleMaxSizedCache<CompoundTag, BakedModel> STACK_MODEL_CACHE = new SimpleMaxSizedCache(((Supplier<Long>)IClientConfiguration.getInstance().getStackModelCacheSize())::get);

    @Override
    public boolean m_7541_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    @Override
    public BakedModel handleBlockState(BlockState state, RandomSource random, IBlockModelData modelData) {
        if (!modelData.hasProperty(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY)) {
            return NullBakedModel.instance;
        }
        return (BakedModel)modelData.getData(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY);
    }

    @Override
    public BakedModel handleBlockState(BlockState state, RandomSource random, IBlockModelData modelData, @Nullable RenderType renderType) {
        if (!modelData.hasProperty(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY) && !modelData.hasProperty(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY)) {
            return NullBakedModel.instance;
        }
        if (!modelData.hasProperty(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY) || renderType == null) {
            return (BakedModel)modelData.getData(ModModelProperties.UNKNOWN_LAYER_MODEL_PROPERTY);
        }
        return ((Map)modelData.getData(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY)).getOrDefault(renderType, NullBakedModel.instance);
    }

    @Override
    @NotNull
    public Collection<RenderType> getSupportedRenderTypes(BlockState blockState, RandomSource randomSource, IBlockModelData iBlockModelData) {
        if (!iBlockModelData.hasProperty(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY)) {
            return super.getSupportedRenderTypes(blockState, randomSource, iBlockModelData);
        }
        return ((Map)iBlockModelData.getData(ModModelProperties.KNOWN_LAYER_MODEL_PROPERTY)).keySet();
    }

    @Override
    public BakedModel handleItemStack(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof IMultiStateItem)) {
            return NullBakedModel.instance;
        }
        IMultiStateItem multiStateItem = (IMultiStateItem)item;
        CompoundTag cacheKey = stack.m_41739_(new CompoundTag());
        return STACK_MODEL_CACHE.get(cacheKey, () -> {
            BakedModel[] typedModels;
            IMultiStateItemStack multiStateItemStack = multiStateItem.createItemStack(stack);
            try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Building individual render type models");){
                typedModels = (BakedModel[])BlockInformationUtils.extractRenderTypes(multiStateItemStack.getStatistics().getContainedStates()).stream().flatMap(type -> {
                    ChiseledBlockBakedModel fluidModel = ChiseledBlockBakedModelManager.getInstance().get(multiStateItemStack, ChiselRenderType.fromLayer(type, true), (RenderType)type);
                    ChiseledBlockBakedModel solidModel = ChiseledBlockBakedModelManager.getInstance().get(multiStateItemStack, ChiselRenderType.fromLayer(type, false), (RenderType)type);
                    return Stream.of(fluidModel, solidModel);
                }).toArray(BakedModel[]::new);
            }
            if (typedModels.length == 0) {
                return ChiseledBlockBakedModel.EMPTY;
            }
            ignored1 = ProfilingManager.getInstance().withSection("Combining model data");
            try {
                CombinedModel combinedModel = new CombinedModel(typedModels);
                return combinedModel;
            }
            finally {
                if (ignored1 != null) {
                    ignored1.close();
                }
            }
        });
    }
}

