/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Consumer;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.client.model.baked.BakedQuadBuilder;
import mod.chiselsandbits.client.model.baked.face.model.BaseModelReader;
import mod.chiselsandbits.client.model.baked.face.model.ModelLightMapReader;
import mod.chiselsandbits.client.model.baked.face.model.ModelVertexDataReader;
import mod.chiselsandbits.client.model.baked.face.model.VertexData;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;

public record ModelQuadLayer(VertexData[] vertexData, TextureAtlasSprite sprite, int light, int color, int tint, boolean shade, Direction cullDirection, BakedQuad sourceQuad) {

    public static final class Builder
    extends BaseModelReader {
        private final IBlockInformation blockInformation;
        private final Collection<VertexData> manualVertexData = new ArrayList<VertexData>();
        private final ModelLightMapReader lightValueExtractor = new ModelLightMapReader();
        private final ModelVertexDataReader uvExtractor = new ModelVertexDataReader();
        private TextureAtlasSprite sprite;
        private int light;
        private int color = -1;
        private int tint = -1;
        private boolean shade;
        private Direction cullDirection;
        private BakedQuad sourceQuad;

        private Builder(IBlockInformation blockInformation) {
            this.blockInformation = blockInformation;
        }

        public static Builder create(IBlockInformation blockInformation) {
            return new Builder(blockInformation);
        }

        public Builder withVertexData(Consumer<VertexData.Builder> vertexDataConsumer) {
            VertexData.Builder vertexDataBuilder = VertexData.Builder.create();
            vertexDataConsumer.accept(vertexDataBuilder);
            this.manualVertexData.add(vertexDataBuilder.build());
            return this;
        }

        public Builder withSprite(TextureAtlasSprite sprite) {
            this.sprite = sprite;
            return this;
        }

        public Builder withLight(int light) {
            this.light = light;
            return this;
        }

        public Builder withColor(int color) {
            this.color = color;
            return this;
        }

        public Builder withTint(int tint) {
            this.tint = tint;
            return this;
        }

        public Builder withShade(boolean shade) {
            this.shade = shade;
            return this;
        }

        public Builder withSourceQuad(BakedQuad sourceQuad) {
            this.sourceQuad = sourceQuad;
            return this;
        }

        private Builder withCullDirection(Direction orientation) {
            this.cullDirection = orientation;
            return this;
        }

        @Override
        public void put(int vertexIndex, int element, float ... data) {
            this.uvExtractor.put(vertexIndex, element, data);
            this.lightValueExtractor.put(vertexIndex, element, data);
        }

        @Override
        public void setQuadTint(int tint) {
            this.withTint(tint);
        }

        @Override
        public void setApplyDiffuseLighting(boolean diffuse) {
            this.withShade(diffuse);
        }

        @Override
        public void setQuadOrientation(@NotNull Direction orientation) {
            this.withCullDirection(orientation);
        }

        @Override
        public void setTexture(@NotNull TextureAtlasSprite texture) {
            this.withSprite(texture);
        }

        public void onComplete() {
            this.uvExtractor.onComplete();
            this.lightValueExtractor.onComplete();
        }

        public ModelQuadLayer build() {
            this.light = Math.max(this.light, this.lightValueExtractor.getLv());
            int n = this.color = this.tint != -1 ? this.color : -1;
            if (0 <= this.tint && this.tint <= 255) {
                this.color = -1;
                this.tint = IBlockStateIdManager.getInstance().getIdFrom(this.blockInformation.getBlockState()) << 8 | this.tint;
            } else {
                this.tint = -1;
            }
            BakedQuad sourceQuad = this.sourceQuad == null ? this.buildSourceQuad() : this.sourceQuad;
            Collection<VertexData> vertexData = this.manualVertexData.size() != 0 ? this.manualVertexData.stream().sorted(Comparator.comparing(VertexData::vertexIndex)).toList() : this.uvExtractor.getVertexData();
            return new ModelQuadLayer((VertexData[])vertexData.toArray(VertexData[]::new), this.sprite, this.light, this.color, this.tint, this.shade, this.cullDirection, sourceQuad);
        }

        private BakedQuad buildSourceQuad() {
            if (this.manualVertexData.size() != 4) {
                throw new IllegalStateException("Cannot build a source quad without 4 vertex data");
            }
            VertexData[] verticesData = (VertexData[])this.manualVertexData.stream().sorted(Comparator.comparing(VertexData::vertexIndex)).toArray(VertexData[]::new);
            BakedQuadBuilder builder = new BakedQuadBuilder(this.sprite);
            builder.setQuadOrientation(this.cullDirection);
            builder.setQuadTint(this.tint);
            for (int vertexIndex = 0; vertexIndex < verticesData.length; ++vertexIndex) {
                VertexData vertexData = verticesData[vertexIndex];
                block7: for (int elementIndex = 0; elementIndex < DefaultVertexFormat.f_85811_.m_86023_().size(); ++elementIndex) {
                    VertexFormatElement element = (VertexFormatElement)DefaultVertexFormat.f_85811_.m_86023_().get(elementIndex);
                    switch (element.m_86048_()) {
                        case POSITION: {
                            builder.put(vertexIndex, elementIndex, vertexData.positionData());
                            continue block7;
                        }
                        case COLOR: {
                            builder.put(vertexIndex, elementIndex, 1.0f, 1.0f, 1.0f, 1.0f);
                            continue block7;
                        }
                        case NORMAL: {
                            builder.put(vertexIndex, elementIndex, this.cullDirection.m_122429_(), this.cullDirection.m_122430_(), this.cullDirection.m_122431_());
                            continue block7;
                        }
                        case UV: {
                            if (element.m_86049_() == 0) {
                                builder.put(vertexIndex, elementIndex, vertexData.uvData());
                                continue block7;
                            }
                            if (element.m_86049_() == 1) {
                                builder.put(vertexIndex, elementIndex, 0.0f, 0.0f);
                                continue block7;
                            }
                            builder.put(vertexIndex, elementIndex, 1.0f, 1.0f);
                            continue block7;
                        }
                        default: {
                            builder.put(vertexIndex, elementIndex, new float[0]);
                        }
                    }
                }
            }
            builder.setApplyDiffuseLighting(true);
            builder.onComplete();
            return builder.build();
        }
    }
}

