/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.reloading;

import com.google.common.collect.Sets;
import java.util.Set;
import mod.chiselsandbits.api.reloading.ICacheClearingHandler;
import mod.chiselsandbits.client.besr.BitStorageBESR;
import mod.chiselsandbits.client.model.baked.bit.BitBlockBakedModelManager;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.model.baked.face.FaceManager;
import mod.chiselsandbits.reloading.DataReloadingResourceManager;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ClientResourceReloadingManager
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ClientResourceReloadingManager INSTANCE = new ClientResourceReloadingManager();
    private final Set<ICacheClearingHandler> cacheClearingHandlers = Sets.newConcurrentHashSet();

    public static ClientResourceReloadingManager getInstance() {
        return INSTANCE;
    }

    private ClientResourceReloadingManager() {
    }

    public void m_6213_(@NotNull ResourceManager manager) {
        this.clearCaches();
    }

    public ClientResourceReloadingManager registerCacheClearer(ICacheClearingHandler cacheClearingHandler) {
        this.cacheClearingHandlers.add(cacheClearingHandler);
        return this;
    }

    public static void setup() {
        LOGGER.info("Setting up client reloading resource manager.");
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        if (resourceManager instanceof ReloadableResourceManager) {
            ReloadableResourceManager reloadableResourceManager = (ReloadableResourceManager)resourceManager;
            reloadableResourceManager.m_7217_((PreparableReloadListener)ClientResourceReloadingManager.getInstance());
        }
        ClientResourceReloadingManager.getInstance().registerCacheClearer(BitStorageBESR::clearCache).registerCacheClearer(BitBlockBakedModelManager.getInstance()::clearCache).registerCacheClearer(ChiseledBlockBakedModelManager.getInstance()::clearCache).registerCacheClearer(FaceManager.getInstance()::clearCache);
    }

    public void clearCaches() {
        LOGGER.info("Resetting client caches");
        this.cacheClearingHandlers.forEach(ICacheClearingHandler::clear);
        DataReloadingResourceManager.getInstance().clearCaches();
    }
}

