/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.util;

import com.communi.suggestu.scena.core.client.rendering.type.IRenderTypeManager;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.client.variant.state.IClientStateVariantManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.ThreadSafeLegacyRandomSource;
import net.minecraft.world.level.material.FluidState;

public final class BlockInformationUtils {
    private static final RandomSource RANDOM = new ThreadSafeLegacyRandomSource(42L);

    private BlockInformationUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: IMultiStateObjectStatisticsUtils. This is a utility class");
    }

    public static Set<RenderType> extractRenderTypes(IBlockInformation blockInformation) {
        return BlockInformationUtils.extractRenderTypes(Sets.newHashSet((Object[])new IBlockInformation[]{blockInformation}));
    }

    public static Set<RenderType> extractRenderTypes(Set<IBlockInformation> blocks) {
        HashSet renderTypes = Sets.newHashSet();
        for (IBlockInformation blockInformation : blocks) {
            if (blockInformation.isAir()) continue;
            if (blockInformation.isFluid()) {
                renderTypes.add(ItemBlockRenderTypes.m_109287_((FluidState)blockInformation.getBlockState().m_60819_()));
                continue;
            }
            BakedModel bakedModel = Minecraft.m_91087_().m_91289_().m_110910_(blockInformation.getBlockState());
            renderTypes.addAll(IRenderTypeManager.getInstance().getRenderTypesFor(bakedModel, blockInformation.getBlockState(), RANDOM, IClientStateVariantManager.getInstance().getBlockModelData(blockInformation)));
        }
        return renderTypes;
    }
}

