/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.AllCreativeModeTabs;
import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllEntityDataSerializers;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllInteractionBehaviours;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllMenuTypes;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllStructureProcessorTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.CreateClient;
import com.simibubi.create.api.behaviour.BlockSpoutingBehaviour;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.compat.curios.Curios;
import com.simibubi.create.content.contraptions.ContraptionMovementSetting;
import com.simibubi.create.content.decoration.palettes.AllPaletteBlocks;
import com.simibubi.create.content.equipment.potatoCannon.BuiltinPotatoProjectileTypes;
import com.simibubi.create.content.fluids.tank.BoilerHeaters;
import com.simibubi.create.content.kinetics.TorquePropagator;
import com.simibubi.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes;
import com.simibubi.create.content.redstone.displayLink.AllDisplayBehaviours;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.content.schematics.SchematicInstances;
import com.simibubi.create.content.schematics.ServerSchematicLoader;
import com.simibubi.create.content.trains.GlobalRailwayManager;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.block.CopperRegistries;
import com.simibubi.create.foundation.damageTypes.DamageTypeDataProvider;
import com.simibubi.create.foundation.damageTypes.DamageTypeTagGen;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.LangMerger;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.data.recipe.MechanicalCraftingRecipeGen;
import com.simibubi.create.foundation.data.recipe.ProcessingRecipeGen;
import com.simibubi.create.foundation.data.recipe.SequencedAssemblyRecipeGen;
import com.simibubi.create.foundation.data.recipe.StandardRecipeGen;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.utility.AttachedRegistry;
import com.simibubi.create.infrastructure.command.ServerLagger;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.worldgen.AllFeatures;
import com.simibubi.create.infrastructure.worldgen.AllPlacementModifiers;
import com.simibubi.create.infrastructure.worldgen.WorldgenDataProvider;
import java.util.Random;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="create")
public class Create {
    public static final String ID = "create";
    public static final String NAME = "Create";
    public static final String VERSION = "0.5.1d";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @Deprecated
    public static final Random RANDOM = new Random();
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create("create");
    public static final ServerSchematicLoader SCHEMATIC_RECEIVER;
    public static final RedstoneLinkNetworkHandler REDSTONE_LINK_NETWORK_HANDLER;
    public static final TorquePropagator TORQUE_PROPAGATOR;
    public static final GlobalRailwayManager RAILWAYS;
    public static final ServerLagger LAGGER;

    public Create() {
        Create.onCtor();
    }

    public static void onCtor() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        REGISTRATE.registerEventListeners(modEventBus);
        AllSoundEvents.prepare();
        AllTags.init();
        AllBlocks.register();
        AllItems.register();
        AllFluids.register();
        AllPaletteBlocks.register();
        AllMenuTypes.register();
        AllEntityTypes.register();
        AllBlockEntityTypes.register();
        AllEnchantments.register();
        AllRecipeTypes.register(modEventBus);
        AllParticleTypes.register(modEventBus);
        AllStructureProcessorTypes.register(modEventBus);
        AllEntityDataSerializers.register(modEventBus);
        AllFeatures.register(modEventBus);
        AllPlacementModifiers.register(modEventBus);
        AllCreativeModeTabs.register(modEventBus);
        BogeySizes.init();
        AllBogeyStyles.register();
        AllConfigs.register(modLoadingContext);
        AllMovementBehaviours.registerDefaults();
        AllInteractionBehaviours.registerDefaults();
        AllDisplayBehaviours.registerDefaults();
        ContraptionMovementSetting.registerDefaults();
        AllArmInteractionPointTypes.register();
        BlockSpoutingBehaviour.registerDefaults();
        ComputerCraftProxy.register();
        ForgeMod.enableMilkFluid();
        CopperRegistries.inject();
        modEventBus.addListener(Create::init);
        modEventBus.addListener(EventPriority.LOW, Create::gatherData);
        modEventBus.addListener(AllSoundEvents::register);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateClient.onCtorClient(modEventBus, forgeEventBus));
        Mods.CURIOS.executeIfInstalled(() -> () -> Curios.init(modEventBus, forgeEventBus));
    }

    public static void init(FMLCommonSetupEvent event) {
        AllPackets.registerPackets();
        SchematicInstances.register();
        BuiltinPotatoProjectileTypes.register();
        event.enqueueWork(() -> {
            AttachedRegistry.unwrapAll();
            AllAdvancements.register();
            AllTriggers.register();
            BoilerHeaters.registerDefaults();
            AllFluids.registerFluidInteractions();
        });
    }

    public static void gatherData(GatherDataEvent event) {
        TagGen.datagen();
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        if (event.includeClient()) {
            gen.addProvider(true, (DataProvider)AllSoundEvents.provider(gen));
            LangMerger.attachToRegistrateProvider(gen, output);
        }
        if (event.includeServer()) {
            gen.addProvider(true, (DataProvider)new AllAdvancements(output));
            gen.addProvider(true, (DataProvider)new StandardRecipeGen(output));
            gen.addProvider(true, (DataProvider)new MechanicalCraftingRecipeGen(output));
            gen.addProvider(true, (DataProvider)new SequencedAssemblyRecipeGen(output));
            ProcessingRecipeGen.registerAll(gen, output);
            gen.addProvider(true, WorldgenDataProvider.makeFactory(event.getLookupProvider()));
            gen.addProvider(true, DamageTypeDataProvider.makeFactory(event.getLookupProvider()));
            gen.addProvider(true, (DataProvider)new DamageTypeTagGen(output, event.getLookupProvider(), event.getExistingFileHelper()));
        }
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(ID, path);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier((Item)item, TooltipHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull(KineticStats.create(item))));
        SCHEMATIC_RECEIVER = new ServerSchematicLoader();
        REDSTONE_LINK_NETWORK_HANDLER = new RedstoneLinkNetworkHandler();
        TORQUE_PROPAGATOR = new TorquePropagator();
        RAILWAYS = new GlobalRailwayManager();
        LAGGER = new ServerLagger();
    }
}

