/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.AllDamageTypes;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.NetworkEvent;

public class TrainCollisionPacket
extends SimplePacketBase {
    int damage;
    int contraptionEntityId;

    public TrainCollisionPacket(int damage, int contraptionEntityId) {
        this.damage = damage;
        this.contraptionEntityId = contraptionEntityId;
    }

    public TrainCollisionPacket(FriendlyByteBuf buffer) {
        this.contraptionEntityId = buffer.readInt();
        this.damage = buffer.readInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.contraptionEntityId);
        buffer.writeInt(this.damage);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            Level level = player.m_9236_();
            Entity entity = level.m_6815_(this.contraptionEntityId);
            if (!(entity instanceof CarriageContraptionEntity)) {
                return;
            }
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            player.m_6469_(AllDamageTypes.RUN_OVER.source((LevelAccessor)level, cce), (float)this.damage);
            player.m_9236_().m_5594_((Player)player, entity.m_20183_(), SoundEvents.f_12313_, SoundSource.NEUTRAL, 1.0f, 0.75f);
        });
        return true;
    }
}

