/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink;

import com.simibubi.create.Create;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import com.simibubi.create.content.redstone.displayLink.source.ComputerDisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.DeathCounterDisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.EnchantPowerDisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.RedstonePowerDisplaySource;
import com.simibubi.create.content.redstone.displayLink.source.ScoreboardDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.target.LecternDisplayTarget;
import com.simibubi.create.content.redstone.displayLink.target.SignDisplayTarget;
import com.simibubi.create.foundation.utility.AttachedRegistry;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class AllDisplayBehaviours {
    public static final Map<ResourceLocation, DisplayBehaviour> GATHERER_BEHAVIOURS = new HashMap<ResourceLocation, DisplayBehaviour>();
    private static final AttachedRegistry<Block, List<DisplaySource>> SOURCES_BY_BLOCK = new AttachedRegistry(ForgeRegistries.BLOCKS);
    private static final AttachedRegistry<BlockEntityType<?>, List<DisplaySource>> SOURCES_BY_BLOCK_ENTITY = new AttachedRegistry(ForgeRegistries.BLOCK_ENTITY_TYPES);
    private static final AttachedRegistry<Block, DisplayTarget> TARGETS_BY_BLOCK = new AttachedRegistry(ForgeRegistries.BLOCKS);
    private static final AttachedRegistry<BlockEntityType<?>, DisplayTarget> TARGETS_BY_BLOCK_ENTITY = new AttachedRegistry(ForgeRegistries.BLOCK_ENTITY_TYPES);

    public static DisplayBehaviour register(ResourceLocation id, DisplayBehaviour behaviour) {
        behaviour.id = id;
        GATHERER_BEHAVIOURS.put(id, behaviour);
        return behaviour;
    }

    public static void assignBlock(DisplayBehaviour behaviour, ResourceLocation block) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_BLOCK.get((Block)block);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_BLOCK.register((Block)block, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_BLOCK.register((Block)block, target);
        }
    }

    public static void assignBlockEntity(DisplayBehaviour behaviour, ResourceLocation beType) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_BLOCK_ENTITY.get((BlockEntityType<?>)beType);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_BLOCK_ENTITY.register((BlockEntityType<?>)beType, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_BLOCK_ENTITY.register((BlockEntityType<?>)beType, target);
        }
    }

    public static void assignBlock(DisplayBehaviour behaviour, Block block) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_BLOCK.get(block);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_BLOCK.register(block, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_BLOCK.register(block, target);
        }
    }

    public static void assignBlockEntity(DisplayBehaviour behaviour, BlockEntityType<?> beType) {
        if (behaviour instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)behaviour;
            List<DisplaySource> sources = SOURCES_BY_BLOCK_ENTITY.get(beType);
            if (sources == null) {
                sources = new ArrayList<DisplaySource>();
                SOURCES_BY_BLOCK_ENTITY.register(beType, sources);
            }
            sources.add(source);
        }
        if (behaviour instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)behaviour;
            TARGETS_BY_BLOCK_ENTITY.register(beType, target);
        }
    }

    public static <B extends Block> NonNullConsumer<? super B> assignDataBehaviour(DisplayBehaviour behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            ResourceLocation registryName = RegisteredObjects.getKeyOrThrow(b);
            Object object = idSuffix = behaviour instanceof DisplaySource ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(new ResourceLocation(registryName.m_135827_(), registryName.m_135815_() + (String)idSuffix), behaviour), registryName);
        };
    }

    public static <B extends BlockEntityType<?>> NonNullConsumer<? super B> assignDataBehaviourBE(DisplayBehaviour behaviour, String ... suffix) {
        return b -> {
            Object idSuffix;
            ResourceLocation registryName = RegisteredObjects.getKeyOrThrow(b);
            Object object = idSuffix = behaviour instanceof DisplaySource ? "_source" : "_target";
            if (suffix.length > 0) {
                idSuffix = (String)idSuffix + "_" + suffix[0];
            }
            AllDisplayBehaviours.assignBlockEntity(AllDisplayBehaviours.register(new ResourceLocation(registryName.m_135827_(), registryName.m_135815_() + (String)idSuffix), behaviour), registryName);
        };
    }

    @Nullable
    public static DisplaySource getSource(ResourceLocation resourceLocation) {
        DisplayBehaviour available = GATHERER_BEHAVIOURS.getOrDefault(resourceLocation, null);
        if (available instanceof DisplaySource) {
            DisplaySource source = (DisplaySource)available;
            return source;
        }
        return null;
    }

    @Nullable
    public static DisplayTarget getTarget(ResourceLocation resourceLocation) {
        DisplayBehaviour available = GATHERER_BEHAVIOURS.getOrDefault(resourceLocation, null);
        if (available instanceof DisplayTarget) {
            DisplayTarget target = (DisplayTarget)available;
            return target;
        }
        return null;
    }

    public static List<DisplaySource> sourcesOf(Block block) {
        List<DisplaySource> sources = SOURCES_BY_BLOCK.get(block);
        if (sources == null) {
            return Collections.emptyList();
        }
        return sources;
    }

    public static List<DisplaySource> sourcesOf(BlockState state) {
        return AllDisplayBehaviours.sourcesOf(state.m_60734_());
    }

    public static List<DisplaySource> sourcesOf(BlockEntityType<?> blockEntityType) {
        List<DisplaySource> sources = SOURCES_BY_BLOCK_ENTITY.get(blockEntityType);
        if (sources == null) {
            return Collections.emptyList();
        }
        return sources;
    }

    public static List<DisplaySource> sourcesOf(BlockEntity blockEntity) {
        return AllDisplayBehaviours.sourcesOf(blockEntity.m_58903_());
    }

    @Nullable
    public static DisplayTarget targetOf(Block block) {
        return TARGETS_BY_BLOCK.get(block);
    }

    @Nullable
    public static DisplayTarget targetOf(BlockState state) {
        return AllDisplayBehaviours.targetOf(state.m_60734_());
    }

    @Nullable
    public static DisplayTarget targetOf(BlockEntityType<?> blockEntityType) {
        return TARGETS_BY_BLOCK_ENTITY.get(blockEntityType);
    }

    @Nullable
    public static DisplayTarget targetOf(BlockEntity blockEntity) {
        return AllDisplayBehaviours.targetOf(blockEntity.m_58903_());
    }

    public static List<DisplaySource> sourcesOf(LevelAccessor level, BlockPos pos) {
        List<Object> sourcesOfBlockEntity;
        BlockState blockState = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        List<DisplaySource> sourcesOfBlock = AllDisplayBehaviours.sourcesOf(blockState);
        List<Object> list = sourcesOfBlockEntity = blockEntity == null ? Collections.emptyList() : AllDisplayBehaviours.sourcesOf(blockEntity);
        if (sourcesOfBlockEntity.isEmpty()) {
            return sourcesOfBlock;
        }
        return sourcesOfBlockEntity;
    }

    @Nullable
    public static DisplayTarget targetOf(LevelAccessor level, BlockPos pos) {
        DisplayTarget targetOfBlockEntity;
        BlockState blockState = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        DisplayTarget targetOfBlock = AllDisplayBehaviours.targetOf(blockState);
        DisplayTarget displayTarget = targetOfBlockEntity = blockEntity == null ? null : AllDisplayBehaviours.targetOf(blockEntity);
        if (targetOfBlockEntity == null && blockEntity instanceof SignBlockEntity) {
            targetOfBlockEntity = AllDisplayBehaviours.targetOf(BlockEntityType.f_58924_);
        }
        if (targetOfBlockEntity == null) {
            return targetOfBlock;
        }
        return targetOfBlockEntity;
    }

    public static void registerDefaults() {
        AllDisplayBehaviours.assignBlockEntity(AllDisplayBehaviours.register(Create.asResource("sign_display_target"), new SignDisplayTarget()), BlockEntityType.f_58924_);
        AllDisplayBehaviours.assignBlockEntity(AllDisplayBehaviours.register(Create.asResource("lectern_display_target"), new LecternDisplayTarget()), BlockEntityType.f_58908_);
        AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(Create.asResource("death_count_display_source"), new DeathCounterDisplaySource()), Blocks.f_50724_);
        AllDisplayBehaviours.assignBlockEntity(AllDisplayBehaviours.register(Create.asResource("scoreboard_display_source"), new ScoreboardDisplaySource()), BlockEntityType.f_58938_);
        AllDisplayBehaviours.assignBlockEntity(AllDisplayBehaviours.register(Create.asResource("enchant_power_display_source"), new EnchantPowerDisplaySource()), BlockEntityType.f_58928_);
        AllDisplayBehaviours.assignBlock(AllDisplayBehaviours.register(Create.asResource("redstone_power_display_source"), new RedstonePowerDisplaySource()), Blocks.f_50716_);
        Mods.COMPUTERCRAFT.executeIfInstalled(() -> () -> {
            DisplayBehaviour computerDisplaySource = AllDisplayBehaviours.register(Create.asResource("computer_display_source"), new ComputerDisplaySource());
            AllDisplayBehaviours.assignBlockEntity(computerDisplaySource, new ResourceLocation(Mods.COMPUTERCRAFT.asId(), "wired_modem_full"));
            AllDisplayBehaviours.assignBlockEntity(computerDisplaySource, new ResourceLocation(Mods.COMPUTERCRAFT.asId(), "computer_normal"));
            AllDisplayBehaviours.assignBlockEntity(computerDisplaySource, new ResourceLocation(Mods.COMPUTERCRAFT.asId(), "computer_advanced"));
            AllDisplayBehaviours.assignBlockEntity(computerDisplaySource, new ResourceLocation(Mods.COMPUTERCRAFT.asId(), "computer_command"));
        });
    }
}

