/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.content.contraptions.behaviour.DoorMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.LeverMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.behaviour.TrapdoorMovingInteraction;
import com.simibubi.create.foundation.utility.AttachedRegistry;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class AllInteractionBehaviours {
    private static final AttachedRegistry<Block, MovingInteractionBehaviour> BLOCK_BEHAVIOURS = new AttachedRegistry(ForgeRegistries.BLOCKS);
    private static final List<BehaviourProvider> GLOBAL_BEHAVIOURS = new ArrayList<BehaviourProvider>();

    public static void registerBehaviour(ResourceLocation block, MovingInteractionBehaviour provider) {
        BLOCK_BEHAVIOURS.register((Block)block, provider);
    }

    public static void registerBehaviour(Block block, MovingInteractionBehaviour provider) {
        BLOCK_BEHAVIOURS.register(block, provider);
    }

    public static void registerBehaviourProvider(BehaviourProvider provider) {
        GLOBAL_BEHAVIOURS.add(provider);
    }

    @Nullable
    public static MovingInteractionBehaviour getBehaviour(BlockState state) {
        MovingInteractionBehaviour behaviour = BLOCK_BEHAVIOURS.get(state.m_60734_());
        if (behaviour != null) {
            return behaviour;
        }
        for (BehaviourProvider provider : GLOBAL_BEHAVIOURS) {
            behaviour = provider.getBehaviour(state);
            if (behaviour == null) continue;
            return behaviour;
        }
        return null;
    }

    public static <B extends Block> NonNullConsumer<? super B> interactionBehaviour(MovingInteractionBehaviour behaviour) {
        return b -> AllInteractionBehaviours.registerBehaviour(b, behaviour);
    }

    static void registerDefaults() {
        AllInteractionBehaviours.registerBehaviour(Blocks.f_50164_, (MovingInteractionBehaviour)new LeverMovingInteraction());
        DoorMovingInteraction doorBehaviour = new DoorMovingInteraction();
        AllInteractionBehaviours.registerBehaviourProvider(state -> {
            if (state.m_204336_(BlockTags.f_13095_)) {
                return doorBehaviour;
            }
            return null;
        });
        TrapdoorMovingInteraction trapdoorBehaviour = new TrapdoorMovingInteraction();
        AllInteractionBehaviours.registerBehaviourProvider(state -> {
            if (state.m_204336_(BlockTags.f_13102_)) {
                return trapdoorBehaviour;
            }
            return null;
        });
    }

    public static interface BehaviourProvider {
        @Nullable
        public MovingInteractionBehaviour getBehaviour(BlockState var1);
    }
}

