/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedSpout;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

@ParametersAreNonnullByDefault
public class SpoutCategory
extends CreateRecipeCategory<FillingRecipe> {
    private final AnimatedSpout spout = new AnimatedSpout();

    public SpoutCategory(CreateRecipeCategory.Info<FillingRecipe> info) {
        super(info);
    }

    public static void consumeRecipes(Consumer<FillingRecipe> consumer, IIngredientManager ingredientManager) {
        Collection fluidStacks = ingredientManager.getAllIngredients((IIngredientType)ForgeTypes.FLUID_STACK);
        for (ItemStack stack : ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
            if (stack.m_41720_() instanceof PotionItem) {
                FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(stack);
                Ingredient bottle = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_});
                consumer.accept(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("potions")).withItemIngredients(bottle).withFluidIngredients(FluidIngredient.fromFluidStack(fluidFromPotionItem)).withSingleItemOutput(stack).build());
                continue;
            }
            LazyOptional capability = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (!capability.isPresent()) continue;
            for (FluidStack fluidStack : fluidStacks) {
                ItemStack copy = stack.m_41777_();
                copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fhi -> {
                    if (!GenericItemFilling.isFluidHandlerValid(copy, fhi)) {
                        return;
                    }
                    FluidStack fluidCopy = fluidStack.copy();
                    fluidCopy.setAmount(1000);
                    fhi.fill(fluidCopy, IFluidHandler.FluidAction.EXECUTE);
                    ItemStack container = fhi.getContainer();
                    if (ItemHelper.sameItem(container, copy)) {
                        return;
                    }
                    if (container.m_41619_()) {
                        return;
                    }
                    Ingredient bucket = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
                    ResourceLocation itemName = RegisteredObjects.getKeyOrThrow(stack.m_41720_());
                    ResourceLocation fluidName = RegisteredObjects.getKeyOrThrow(fluidCopy.getFluid());
                    consumer.accept(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("fill_" + itemName.m_135827_() + "_" + itemName.m_135815_() + "_with_" + fluidName.m_135827_() + "_" + fluidName.m_135815_())).withItemIngredients(bucket).withFluidIngredients(FluidIngredient.fromFluidStack(fluidCopy)).withSingleItemOutput(container).build());
                });
            }
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FillingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 27, 51).setBackground(SpoutCategory.getRenderedSlot(), -1, -1).addIngredients((Ingredient)recipe.m_7527_().get(0));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 27, 32).setBackground(SpoutCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, SpoutCategory.withImprovedVisibility(recipe.getRequiredFluid().getMatchingFluidStacks()))).addTooltipCallback(SpoutCategory.addFluidTooltip(recipe.getRequiredFluid().getRequiredAmount()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 132, 51).setBackground(SpoutCategory.getRenderedSlot(), -1, -1).addItemStack(SpoutCategory.getResultItem(recipe));
    }

    public void draw(FillingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 62, 57);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 126, 29);
        this.spout.withFluids(recipe.getRequiredFluid().getMatchingFluidStacks()).draw(graphics, this.getBackground().getWidth() / 2 - 13, 22);
    }
}

