/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.copycat;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.decoration.copycat.CopycatSpecialCases;
import com.simibubi.create.content.decoration.copycat.WaterloggedCopycatBlock;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CopycatPanelBlock
extends WaterloggedCopycatBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public CopycatPanelBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    @Override
    public boolean isAcceptedRegardless(BlockState material) {
        return CopycatSpecialCases.isBarsMaterial(material) || CopycatSpecialCases.isTrapdoorMaterial(material);
    }

    @Override
    public BlockState prepareMaterial(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer, InteractionHand pHand, BlockHitResult pHit, BlockState material) {
        if (!CopycatSpecialCases.isTrapdoorMaterial(material)) {
            return super.prepareMaterial(pLevel, pPos, pState, pPlayer, pHand, pHit, material);
        }
        Direction panelFacing = (Direction)pState.m_61143_((Property)FACING);
        if (panelFacing == Direction.DOWN) {
            material = (BlockState)material.m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)Half.TOP);
        }
        if (panelFacing.m_122434_() == Direction.Axis.Y) {
            return (BlockState)((BlockState)material.m_61124_((Property)TrapDoorBlock.f_54117_, (Comparable)pPlayer.m_6350_())).m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(false));
        }
        boolean clickedNearTop = pHit.m_82450_().f_82480_ - 0.5 > (double)pPos.m_123342_();
        return (BlockState)((BlockState)((BlockState)material.m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)(clickedNearTop ? Half.TOP : Half.BOTTOM))).m_61124_((Property)TrapDoorBlock.f_54117_, (Comparable)panelFacing);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (!player.m_6144_() && player.m_36326_()) {
            ItemStack heldItem = player.m_21120_(hand);
            IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
            if (placementHelper.matchesItem(heldItem)) {
                placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, ray);
    }

    @Override
    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState toState = reader.m_8055_(toPos);
        if (!toState.m_60713_((Block)this)) {
            return facing != face.m_122424_();
        }
        BlockPos diff = fromPos.m_121996_((Vec3i)toPos);
        int coord = facing.m_122434_().m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        return facing == ((Direction)toState.m_61143_((Property)FACING)).m_122424_() && (coord == 0 || coord != facing.m_122421_().m_122540_());
    }

    @Override
    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState toState = reader.m_8055_(toPos);
        if (toPos.equals((Object)fromPos.m_121945_(facing))) {
            return false;
        }
        BlockPos diff = fromPos.m_121996_((Vec3i)toPos);
        int coord = facing.m_122434_().m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        if (!toState.m_60713_((Block)this)) {
            return coord != -facing.m_122421_().m_122540_();
        }
        if (CopycatPanelBlock.isOccluded(state, toState, facing)) {
            return true;
        }
        return toState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) == state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) && coord == 0;
    }

    @Override
    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122424_() == face;
    }

    @Override
    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return this.canFaceBeOccluded(state, face.m_122424_());
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.m_5573_(pContext);
        return (BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)pContext.m_7820_().m_122424_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{FACING}));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.CASING_3PX.get((Direction)pState.m_61143_((Property)FACING));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if (state.m_60713_((Block)this) == neighborState.m_60713_((Block)this)) {
            if (CopycatSpecialCases.isBarsMaterial(CopycatPanelBlock.getMaterial(level, pos)) && CopycatSpecialCases.isBarsMaterial(CopycatPanelBlock.getMaterial(level, pos.m_121945_(dir)))) {
                return state.m_61143_((Property)FACING) == neighborState.m_61143_((Property)FACING);
            }
            if (CopycatPanelBlock.getMaterial(level, pos).m_60719_(CopycatPanelBlock.getMaterial(level, pos.m_121945_(dir)), dir.m_122424_())) {
                return CopycatPanelBlock.isOccluded(state, neighborState, dir.m_122424_());
            }
        }
        return state.m_61143_((Property)FACING) == dir.m_122424_() && CopycatPanelBlock.getMaterial(level, pos).m_60719_(neighborState, dir.m_122424_());
    }

    public static boolean isOccluded(BlockState state, BlockState other, Direction pDirection) {
        state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        other = (BlockState)other.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing.m_122424_() == other.m_61143_((Property)FACING) && pDirection == facing) {
            return true;
        }
        if (other.m_61143_((Property)FACING) != facing) {
            return false;
        }
        return pDirection.m_122434_() != facing.m_122434_();
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> AllBlocks.COPYCAT_PANEL.isIn(arg_0);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> AllBlocks.COPYCAT_PANEL.has(arg_0);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.m_82450_(), ((Direction)state.m_61143_((Property)FACING)).m_122434_(), (Direction dir) -> world.m_8055_(pos.m_121945_(dir)).m_247087_());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.m_121945_(directions.get(0)), s -> (BlockState)s.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
        }
    }
}

