/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.PipeConnection;
import com.simibubi.create.content.fluids.pipes.AxisPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.VanillaFluidTargets;
import com.simibubi.create.content.fluids.pump.PumpBlock;
import com.simibubi.create.content.fluids.pump.PumpBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class FluidPropagator {
    public static CreateAdvancement[] getSharedTriggers() {
        return new CreateAdvancement[]{AllAdvancements.WATER_SUPPLY, AllAdvancements.CROSS_STREAMS, AllAdvancements.HONEY_DRAIN};
    }

    public static void propagateChangedPipe(LevelAccessor world, BlockPos pipePos, BlockState pipeState) {
        ArrayList<Pair<Integer, BlockPos>> frontier = new ArrayList<Pair<Integer, BlockPos>>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        HashSet<Pair<PumpBlockEntity, Direction>> discoveredPumps = new HashSet<Pair<PumpBlockEntity, Direction>>();
        frontier.add(Pair.of(0, pipePos));
        while (!frontier.isEmpty()) {
            Pair pair2 = (Pair)frontier.remove(0);
            BlockPos currentPos = (BlockPos)pair2.getSecond();
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            BlockState currentState = currentPos.equals((Object)pipePos) ? pipeState : world.m_8055_(currentPos);
            FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)world, currentPos);
            if (pipe == null) continue;
            pipe.wipePressure();
            for (Direction direction : FluidPropagator.getPipeConnections(currentState, pipe)) {
                Integer distance;
                FluidTransportBehaviour targetPipe;
                Level l;
                BlockPos target = currentPos.m_121945_(direction);
                if (world instanceof Level && !(l = (Level)world).m_46749_(target)) continue;
                BlockEntity blockEntity = world.m_7702_(target);
                BlockState targetState = world.m_8055_(target);
                if (blockEntity instanceof PumpBlockEntity) {
                    if (!AllBlocks.MECHANICAL_PUMP.has(targetState) || ((Direction)targetState.m_61143_((Property)PumpBlock.FACING)).m_122434_() != direction.m_122434_()) continue;
                    discoveredPumps.add(Pair.of((PumpBlockEntity)blockEntity, direction.m_122424_()));
                    continue;
                }
                if (visited.contains(target) || (targetPipe = FluidPropagator.getPipe((BlockGetter)world, target)) == null || (distance = (Integer)pair2.getFirst()) >= FluidPropagator.getPumpRange() && !targetPipe.hasAnyPressure() || !targetPipe.canHaveFlowToward(targetState, direction.m_122424_())) continue;
                frontier.add(Pair.of(distance + 1, target));
            }
        }
        discoveredPumps.forEach(pair -> ((PumpBlockEntity)pair.getFirst()).updatePipesOnSide((Direction)pair.getSecond()));
    }

    public static void resetAffectedFluidNetworks(Level world, BlockPos start, Direction side) {
        ArrayList<BlockPos> frontier = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        frontier.add(start);
        while (!frontier.isEmpty()) {
            BlockPos pos = (BlockPos)frontier.remove(0);
            if (visited.contains(pos)) continue;
            visited.add(pos);
            FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)world, pos);
            if (pipe == null) continue;
            for (Direction d : Iterate.directions) {
                PipeConnection connection;
                BlockPos target;
                if (pos.equals((Object)start) && d != side || visited.contains(target = pos.m_121945_(d)) || (connection = pipe.getConnection(d)) == null || !connection.hasFlow()) continue;
                PipeConnection.Flow flow = connection.flow.get();
                if (!flow.inbound) continue;
                connection.resetNetwork();
                frontier.add(target);
            }
        }
    }

    public static Direction validateNeighbourChange(BlockState state, Level world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        if (world.f_46443_) {
            return null;
        }
        otherBlock = world.m_8055_(neighborPos).m_60734_();
        if (otherBlock instanceof FluidPipeBlock) {
            return null;
        }
        if (otherBlock instanceof AxisPipeBlock) {
            return null;
        }
        if (otherBlock instanceof PumpBlock) {
            return null;
        }
        if (otherBlock instanceof LiquidBlock) {
            return null;
        }
        if (FluidPropagator.getStraightPipeAxis(state) == null && !AllBlocks.ENCASED_FLUID_PIPE.has(state)) {
            return null;
        }
        for (Direction d : Iterate.directions) {
            if (!pos.m_121945_(d).equals((Object)neighborPos)) continue;
            return d;
        }
        return null;
    }

    public static FluidTransportBehaviour getPipe(BlockGetter reader, BlockPos pos) {
        return BlockEntityBehaviour.get(reader, pos, FluidTransportBehaviour.TYPE);
    }

    public static boolean isOpenEnd(BlockGetter reader, BlockPos pos, Direction side) {
        BlockPos connectedPos = pos.m_121945_(side);
        BlockState connectedState = reader.m_8055_(connectedPos);
        FluidTransportBehaviour pipe = FluidPropagator.getPipe(reader, connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, side.m_122424_())) {
            return false;
        }
        if (PumpBlock.isPump(connectedState) && ((Direction)connectedState.m_61143_((Property)PumpBlock.FACING)).m_122434_() == side.m_122434_()) {
            return false;
        }
        if (VanillaFluidTargets.shouldPipesConnectTo(connectedState)) {
            return true;
        }
        if (BlockHelper.hasBlockSolidSide(connectedState, reader, connectedPos, side.m_122424_()) && !AllTags.AllBlockTags.FAN_TRANSPARENT.matches(connectedState)) {
            return false;
        }
        if (FluidPropagator.hasFluidCapability(reader, connectedPos, side.m_122424_())) {
            return false;
        }
        return connectedState.m_247087_() && connectedState.m_60800_(reader, connectedPos) != -1.0f || connectedState.m_61138_((Property)BlockStateProperties.f_61362_);
    }

    public static List<Direction> getPipeConnections(BlockState state, FluidTransportBehaviour pipe) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        for (Direction d : Iterate.directions) {
            if (!pipe.canHaveFlowToward(state, d)) continue;
            list.add(d);
        }
        return list;
    }

    public static int getPumpRange() {
        return (Integer)AllConfigs.server().fluids.mechanicalPumpRange.get();
    }

    public static boolean hasFluidCapability(BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity == null) {
            return false;
        }
        LazyOptional capability = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, side);
        return capability.isPresent();
    }

    @Nullable
    public static Direction.Axis getStraightPipeAxis(BlockState state) {
        if (state.m_60734_() instanceof PumpBlock) {
            return ((Direction)state.m_61143_((Property)PumpBlock.FACING)).m_122434_();
        }
        if (state.m_60734_() instanceof AxisPipeBlock) {
            return (Direction.Axis)state.m_61143_((Property)AxisPipeBlock.f_55923_);
        }
        if (!FluidPipeBlock.isPipe(state)) {
            return null;
        }
        Direction.Axis axisFound = null;
        int connections = 0;
        for (Direction.Axis axis : Iterate.axes) {
            Direction d1 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
            Direction d2 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
            boolean openAt1 = FluidPipeBlock.isOpenAt(state, d1);
            boolean openAt2 = FluidPipeBlock.isOpenAt(state, d2);
            if (openAt1) {
                ++connections;
            }
            if (openAt2) {
                ++connections;
            }
            if (!openAt1 || !openAt2) continue;
            if (axisFound != null) {
                return null;
            }
            axisFound = axis;
        }
        return connections == 2 ? axisFound : null;
    }
}

