/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.tank;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.utility.AttachedRegistry;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BoilerHeaters {
    private static final AttachedRegistry<Block, Heater> BLOCK_HEATERS = new AttachedRegistry(ForgeRegistries.BLOCKS);
    private static final List<HeaterProvider> GLOBAL_HEATERS = new ArrayList<HeaterProvider>();

    public static void registerHeater(ResourceLocation block, Heater heater) {
        BLOCK_HEATERS.register((Block)block, heater);
    }

    public static void registerHeater(Block block, Heater heater) {
        BLOCK_HEATERS.register(block, heater);
    }

    public static void registerHeaterProvider(HeaterProvider provider) {
        GLOBAL_HEATERS.add(provider);
    }

    public static float getActiveHeat(Level level, BlockPos pos, BlockState state) {
        Heater heater = BLOCK_HEATERS.get(state.m_60734_());
        if (heater != null) {
            return heater.getActiveHeat(level, pos, state);
        }
        for (HeaterProvider provider : GLOBAL_HEATERS) {
            heater = provider.getHeater(level, pos, state);
            if (heater == null) continue;
            return heater.getActiveHeat(level, pos, state);
        }
        return -1.0f;
    }

    public static void registerDefaults() {
        BoilerHeaters.registerHeater((Block)AllBlocks.BLAZE_BURNER.get(), (Level level, BlockPos pos, BlockState state) -> {
            BlazeBurnerBlock.HeatLevel value = (BlazeBurnerBlock.HeatLevel)((Object)((Object)state.m_61143_(BlazeBurnerBlock.HEAT_LEVEL)));
            if (value == BlazeBurnerBlock.HeatLevel.NONE) {
                return -1.0f;
            }
            if (value == BlazeBurnerBlock.HeatLevel.SEETHING) {
                return 2.0f;
            }
            if (value.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
                return 1.0f;
            }
            return 0.0f;
        });
        BoilerHeaters.registerHeaterProvider((level, pos, state) -> {
            if (AllTags.AllBlockTags.PASSIVE_BOILER_HEATERS.matches(state) && BlockHelper.isNotUnheated(state)) {
                return (level1, pos1, state1) -> 0.0f;
            }
            return null;
        });
    }

    public static interface Heater {
        public float getActiveHeat(Level var1, BlockPos var2, BlockState var3);
    }

    public static interface HeaterProvider {
        @Nullable
        public Heater getHeater(Level var1, BlockPos var2, BlockState var3);
    }
}

