/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics;

import com.simibubi.create.foundation.utility.Couple;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class BlockStressDefaults {
    public static final int FORCED_UPDATE_VERSION = 2;
    public static final Map<ResourceLocation, Double> DEFAULT_IMPACTS = new HashMap<ResourceLocation, Double>();
    public static final Map<ResourceLocation, Double> DEFAULT_CAPACITIES = new HashMap<ResourceLocation, Double>();
    public static final Map<ResourceLocation, Supplier<Couple<Integer>>> GENERATOR_SPEEDS = new HashMap<ResourceLocation, Supplier<Couple<Integer>>>();

    public static void setDefaultImpact(ResourceLocation blockId, double impact) {
        DEFAULT_IMPACTS.put(blockId, impact);
    }

    public static void setDefaultCapacity(ResourceLocation blockId, double capacity) {
        DEFAULT_CAPACITIES.put(blockId, capacity);
    }

    public static void setGeneratorSpeed(ResourceLocation blockId, Supplier<Couple<Integer>> provider) {
        GENERATOR_SPEEDS.put(blockId, provider);
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setNoImpact() {
        return BlockStressDefaults.setImpact(0.0);
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setImpact(double impact) {
        return b -> {
            BlockStressDefaults.setDefaultImpact(new ResourceLocation(b.getOwner().getModid(), b.getName()), impact);
            return b;
        };
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setCapacity(double capacity) {
        return b -> {
            BlockStressDefaults.setDefaultCapacity(new ResourceLocation(b.getOwner().getModid(), b.getName()), capacity);
            return b;
        };
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setGeneratorSpeed(Supplier<Couple<Integer>> provider) {
        return b -> {
            BlockStressDefaults.setGeneratorSpeed(new ResourceLocation(b.getOwner().getModid(), b.getName()), provider);
            return b;
        };
    }
}

