/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.steamEngine;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineValueBox;
import com.simibubi.create.content.kinetics.steamEngine.SteamJetParticleData;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class SteamEngineBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public WeakReference<PoweredShaftBlockEntity> target;
    public WeakReference<FluidTankBlockEntity> source = new WeakReference<Object>(null);
    float prevAngle = 0.0f;

    public SteamEngineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.target = new WeakReference<Object>(null);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.movementDirection = new ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection>(WindmillBearingBlockEntity.RotationDirection.class, (Component)Lang.translateDirect("contraptions.windmill.rotation_direction", new Object[0]), this, new SteamEngineValueBox());
        this.movementDirection.onlyActiveWhen(() -> {
            PoweredShaftBlockEntity shaft = this.getShaft();
            return shaft == null || !shaft.hasSource();
        });
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add(this.movementDirection);
        this.registerAwardables(behaviours, AllAdvancements.STEAM_ENGINE);
    }

    private void onDirectionChanged() {
    }

    @Override
    public void tick() {
        int conveyedSpeedLevel;
        float efficiency;
        super.tick();
        FluidTankBlockEntity tank = this.getTank();
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (tank == null || shaft == null) {
            if (this.f_58857_.m_5776_()) {
                return;
            }
            if (shaft == null) {
                return;
            }
            if (!shaft.m_58899_().m_121996_((Vec3i)this.f_58858_).equals((Object)shaft.enginePos)) {
                return;
            }
            if (shaft.engineEfficiency == 0.0f) {
                return;
            }
            Direction facing = SteamEngineBlock.getFacing(this.m_58900_());
            if (this.f_58857_.m_46749_(this.f_58858_.m_121945_(facing.m_122424_()))) {
                shaft.update(this.f_58858_, 0, 0.0f);
            }
            return;
        }
        boolean verticalTarget = false;
        BlockState shaftState = shaft.m_58900_();
        Direction.Axis targetAxis = Direction.Axis.X;
        Block block = shaftState.m_60734_();
        if (block instanceof IRotate) {
            IRotate ir = (IRotate)block;
            targetAxis = ir.getRotationAxis(shaftState);
        }
        verticalTarget = targetAxis == Direction.Axis.Y;
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.STEAM_ENGINE.has(blockState)) {
            return;
        }
        Direction facing = SteamEngineBlock.getFacing(blockState);
        if (facing.m_122434_() == Direction.Axis.Y) {
            facing = (Direction)blockState.m_61143_((Property)SteamEngineBlock.f_54117_);
        }
        if ((efficiency = Mth.m_14036_((float)tank.boiler.getEngineEfficiency(tank.getTotalTankSize()), (float)0.0f, (float)1.0f)) > 0.0f) {
            this.award(AllAdvancements.STEAM_ENGINE);
        }
        int n = efficiency == 0.0f ? 1 : (conveyedSpeedLevel = verticalTarget ? 1 : (int)GeneratingKineticBlockEntity.convertToDirection(1.0f, facing));
        if (targetAxis == Direction.Axis.Z) {
            conveyedSpeedLevel *= -1;
        }
        if (this.movementDirection.get() == WindmillBearingBlockEntity.RotationDirection.COUNTER_CLOCKWISE) {
            conveyedSpeedLevel *= -1;
        }
        float shaftSpeed = shaft.getTheoreticalSpeed();
        if (shaft.hasSource() && shaftSpeed != 0.0f && conveyedSpeedLevel != 0 && shaftSpeed > 0.0f != conveyedSpeedLevel > 0) {
            this.movementDirection.setValue(1 - this.movementDirection.get().ordinal());
            conveyedSpeedLevel *= -1;
        }
        shaft.update(this.f_58858_, conveyedSpeedLevel, efficiency);
        if (!this.f_58857_.f_46443_) {
            return;
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::spawnParticles);
    }

    @Override
    public void remove() {
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (shaft != null) {
            shaft.remove(this.f_58858_);
        }
        super.remove();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(2.0);
    }

    public PoweredShaftBlockEntity getShaft() {
        PoweredShaftBlockEntity shaft = (PoweredShaftBlockEntity)this.target.get();
        if (shaft == null || shaft.m_58901_() || !shaft.canBePoweredBy(this.f_58858_)) {
            PoweredShaftBlockEntity ps;
            Direction facing;
            BlockEntity anyShaftAt;
            if (shaft != null) {
                this.target = new WeakReference<Object>(null);
            }
            if ((anyShaftAt = this.f_58857_.m_7702_(this.f_58858_.m_5484_(facing = SteamEngineBlock.getFacing(this.m_58900_()), 2))) instanceof PoweredShaftBlockEntity && (ps = (PoweredShaftBlockEntity)anyShaftAt).canBePoweredBy(this.f_58858_)) {
                shaft = ps;
                this.target = new WeakReference<PoweredShaftBlockEntity>(shaft);
            }
        }
        return shaft;
    }

    public FluidTankBlockEntity getTank() {
        FluidTankBlockEntity tank = (FluidTankBlockEntity)this.source.get();
        if (tank == null || tank.m_58901_()) {
            Direction facing;
            BlockEntity be;
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.f_58857_.m_7702_(this.f_58858_.m_121945_((facing = SteamEngineBlock.getFacing(this.m_58900_())).m_122424_()))) instanceof FluidTankBlockEntity) {
                FluidTankBlockEntity tankBe;
                tank = tankBe = (FluidTankBlockEntity)be;
                this.source = new WeakReference<FluidTankBlockEntity>(tank);
            }
        }
        if (tank == null) {
            return null;
        }
        return tank.getControllerBE();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        FluidTankBlockEntity controller;
        float angle;
        Float targetAngle = this.getTargetAngle();
        PoweredShaftBlockEntity ste = (PoweredShaftBlockEntity)this.target.get();
        if (ste == null) {
            return;
        }
        if (!ste.isPoweredBy(this.f_58858_) || ste.engineEfficiency == 0.0f) {
            return;
        }
        if (targetAngle == null) {
            return;
        }
        angle += (angle = AngleHelper.deg(targetAngle.floatValue())) < 0.0f ? -105.0f : 285.0f;
        angle %= 360.0f;
        PoweredShaftBlockEntity shaft = this.getShaft();
        if (shaft == null || shaft.getSpeed() == 0.0f) {
            return;
        }
        if (!(!(angle >= 0.0f) || this.prevAngle > 180.0f && angle < 180.0f)) {
            this.prevAngle = angle;
            return;
        }
        if (!(!(angle < 0.0f) || this.prevAngle < -180.0f && angle > -180.0f)) {
            this.prevAngle = angle;
            return;
        }
        FluidTankBlockEntity sourceBE = (FluidTankBlockEntity)this.source.get();
        if (sourceBE != null && (controller = sourceBE.getControllerBE()) != null && controller.boiler != null) {
            float volume = 3.0f / (float)Math.max(2, controller.boiler.attachedEngines / 6);
            float pitch = 1.18f - this.f_58857_.f_46441_.m_188501_() * 0.25f;
            this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_144098_, SoundSource.BLOCKS, volume, pitch, false);
            AllSoundEvents.STEAM.playAt(this.f_58857_, (Vec3i)this.f_58858_, volume / 16.0f, 0.8f, false);
        }
        Direction facing = SteamEngineBlock.getFacing(this.m_58900_());
        Vec3 offset = VecHelper.rotate(new Vec3(0.0, 0.0, 1.0).m_82549_(VecHelper.offsetRandomly(Vec3.f_82478_, this.f_58857_.f_46441_, 1.0f).m_82542_(1.0, 1.0, 0.0).m_82541_().m_82490_(0.5)), AngleHelper.verticalAngle(facing), Direction.Axis.X);
        offset = VecHelper.rotate(offset, AngleHelper.horizontalAngle(facing), Direction.Axis.Y);
        Vec3 v = offset.m_82490_(0.5).m_82549_(Vec3.m_82512_((Vec3i)this.f_58858_));
        Vec3 m = offset.m_82546_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(0.75));
        this.f_58857_.m_7106_((ParticleOptions)new SteamJetParticleData(1.0f), v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        this.prevAngle = angle;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Float getTargetAngle() {
        float angle = 0.0f;
        BlockState blockState = this.m_58900_();
        if (!AllBlocks.STEAM_ENGINE.has(blockState)) {
            return null;
        }
        Direction facing = SteamEngineBlock.getFacing(blockState);
        PoweredShaftBlockEntity shaft = this.getShaft();
        Direction.Axis facingAxis = facing.m_122434_();
        Direction.Axis axis = Direction.Axis.Y;
        if (shaft == null) {
            return null;
        }
        axis = KineticBlockEntityRenderer.getRotationAxisOf(shaft);
        angle = KineticBlockEntityRenderer.getAngleForTe(shaft, shaft.m_58899_(), axis);
        if (axis == facingAxis) {
            return null;
        }
        if (axis.m_122479_() && facingAxis == Direction.Axis.X ^ facing.m_122421_() == Direction.AxisDirection.POSITIVE) {
            angle *= -1.0f;
        }
        if (axis == Direction.Axis.X && facing == Direction.DOWN) {
            angle *= -1.0f;
        }
        return Float.valueOf(angle);
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        PoweredShaftBlockEntity shaft = this.getShaft();
        return shaft == null ? false : shaft.addToEngineTooltip(tooltip, isPlayerSneaking);
    }
}

