/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.depot;

import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class DepotItemHandler
implements IItemHandler {
    private static final int MAIN_SLOT = 0;
    private DepotBehaviour behaviour;

    public DepotItemHandler(DepotBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    public int getSlots() {
        return 9;
    }

    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.behaviour.getHeldItemStack() : this.behaviour.processingOutputBuffer.getStackInSlot(slot - 1);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot != 0) {
            return stack;
        }
        if (!this.behaviour.getHeldItemStack().m_41619_() && !this.behaviour.canMergeItems()) {
            return stack;
        }
        if (!this.behaviour.isOutputEmpty() && !this.behaviour.canMergeItems()) {
            return stack;
        }
        ItemStack remainder = this.behaviour.insert(new TransportedItemStack(stack), simulate);
        if (!simulate && remainder != stack) {
            this.behaviour.blockEntity.notifyUpdate();
        }
        return remainder;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 0) {
            return this.behaviour.processingOutputBuffer.extractItem(slot - 1, amount, simulate);
        }
        TransportedItemStack held = this.behaviour.heldItem;
        if (held == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = held.stack.m_41777_();
        ItemStack extracted = stack.m_41620_(amount);
        if (!simulate) {
            this.behaviour.heldItem.stack = stack;
            if (stack.m_41619_()) {
                this.behaviour.heldItem = null;
            }
            this.behaviour.blockEntity.notifyUpdate();
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        return slot == 0 ? this.behaviour.maxStackSize.get() : 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot == 0 && this.behaviour.isItemValid(stack);
    }
}

