/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.ponder.scenes;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.sandPaper.SandPaperItem;
import com.simibubi.create.content.kinetics.deployer.DeployerBlock;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.BeltItemElement;
import com.simibubi.create.foundation.ponder.element.EntityElement;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.ponder.instruction.EmitParticlesInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DeployerScenes {
    public static void filter(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer", "Using the Deployer");
        scene.configureBasePlate(0, 0, 5);
        BlockPos potPosition = util.grid.at(1, 1, 2);
        BlockPos deployerPos = util.grid.at(3, 1, 2);
        Selection deployerSelection = util.select.position(deployerPos);
        scene.world.setBlock(potPosition, Blocks.f_50016_.m_49966_(), false);
        scene.world.showSection(util.select.layer(0).add(util.select.position(1, 1, 2)), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 3, 3, 1, 5), Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(deployerSelection, Direction.SOUTH);
        scene.idle(10);
        scene.overlay.showText(60).placeNearTarget().pointAt(util.vector.topOf(deployerPos)).text("Given Rotational Force, a Deployer can imitate player interactions");
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(44);
        scene.overlay.showSelectionWithText(util.select.position(deployerPos.m_122025_(2)), 60).text("It will always interact with the position 2 blocks in front of itself").attachKeyFrame().placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame();
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(20);
        scene.world.showSection(util.select.fromTo(2, 1, 3, 2, 1, 1), Direction.DOWN);
        scene.idle(24);
        scene.overlay.showText(50).pointAt(util.vector.topOf(deployerPos.m_122024_())).text("Blocks directly in front will not obstruct it").placeNearTarget();
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(34);
        scene.world.hideSection(util.select.fromTo(2, 1, 3, 2, 1, 1), Direction.UP);
        scene.idle(20);
        String[] actions = new String[]{"Place Blocks,", "Use Items,", "Activate Blocks,", "Harvest blocks", "and Attack Mobs"};
        scene.overlay.showText(80).attachKeyFrame().independent(40).placeNearTarget().text("Deployers can:");
        int y = 60;
        for (String s : actions) {
            scene.idle(15);
            scene.overlay.showText(50).colored(PonderPalette.MEDIUM).placeNearTarget().independent(y).text(s);
            y += 16;
        }
        scene.idle(50);
        ItemStack pot = new ItemStack((ItemLike)Items.f_42618_);
        Vec3 frontVec = util.vector.blockSurface(deployerPos, Direction.WEST).m_82520_(-0.125, 0.0, 0.0);
        scene.overlay.showControls(new InputWindowElement(frontVec, Pointing.DOWN).rightClick().withItem(pot), 40);
        scene.idle(7);
        Class<DeployerBlockEntity> teType = DeployerBlockEntity.class;
        scene.world.modifyBlockEntityNBT(deployerSelection, teType, nbt -> nbt.m_128365_("HeldItem", (Tag)pot.serializeNBT()));
        scene.idle(10);
        scene.overlay.showText(40).attachKeyFrame().placeNearTarget().pointAt(frontVec).text("Right-click the front to give it an Item to use");
        scene.idle(40);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.restoreBlocks(util.select.position(potPosition));
        scene.world.modifyBlockEntityNBT(deployerSelection, teType, nbt -> nbt.m_128365_("HeldItem", (Tag)ItemStack.f_41583_.serializeNBT()));
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(20);
        scene.world.showSection(util.select.position(deployerPos.m_7494_()), Direction.DOWN);
        ItemStack tulip = new ItemStack((ItemLike)Items.f_41944_);
        Vec3 entitySpawn = util.vector.topOf(deployerPos.m_6630_(3));
        ElementLink<EntityElement> entity1 = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.2, 0.0), tulip);
        scene.idle(17);
        scene.world.modifyEntity(entity1, Entity::m_146870_);
        scene.world.modifyBlockEntityNBT(deployerSelection, teType, nbt -> nbt.m_128365_("HeldItem", (Tag)tulip.serializeNBT()));
        scene.idle(10);
        scene.overlay.showText(40).placeNearTarget().pointAt(util.vector.of(3.0, 2.5, 3.0)).text("Items can also be inserted automatically");
        scene.idle(30);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.setBlock(potPosition, Blocks.f_50237_.m_49966_(), false);
        scene.world.modifyBlockEntityNBT(deployerSelection, teType, nbt -> nbt.m_128365_("HeldItem", (Tag)ItemStack.f_41583_.serializeNBT()));
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(25);
        scene.world.hideSection(util.select.position(potPosition), Direction.UP);
        scene.world.hideSection(util.select.position(deployerPos.m_7494_()), Direction.EAST);
        scene.idle(20);
        Vec3 filterSlot = util.vector.topOf(deployerPos).m_82520_(0.125, 0.0, 0.0);
        scene.overlay.showFilterSlotInput(filterSlot, Direction.UP, 80);
        scene.overlay.showText(40).attachKeyFrame().placeNearTarget().pointAt(filterSlot).text("Deployers carry a filter slot");
        scene.idle(50);
        ItemStack shears = new ItemStack((ItemLike)Items.f_42574_);
        scene.overlay.showControls(new InputWindowElement(filterSlot, Pointing.DOWN).rightClick().withItem(shears), 40);
        scene.idle(7);
        scene.world.setFilterData(deployerSelection, teType, shears);
        scene.overlay.showText(60).placeNearTarget().pointAt(filterSlot).text("When a filter is set, it activates only while holding a matching item");
        scene.idle(70);
        ElementLink<EntityElement> sheep = scene.world.createEntity(w -> {
            Sheep entity = (Sheep)EntityType.f_20520_.m_20615_(w);
            entity.m_29855_(DyeColor.PINK);
            Vec3 p = util.vector.topOf(util.grid.at(1, 0, 2));
            entity.m_6034_(p.f_82479_, p.f_82480_, p.f_82481_);
            entity.f_19854_ = p.f_82479_;
            entity.f_19855_ = p.f_82480_;
            entity.f_19856_ = p.f_82481_;
            WalkAnimationState animation = entity.f_267362_;
            animation.m_267566_(-animation.m_267756_(), 1.0f);
            animation.m_267771_(1.0f);
            entity.f_19859_ = 210.0f;
            entity.m_146922_(210.0f);
            entity.f_20886_ = 210.0f;
            entity.f_20885_ = 210.0f;
            return entity;
        });
        scene.idle(20);
        scene.world.showSection(util.select.position(deployerPos.m_7494_()), Direction.WEST);
        entity1 = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.2, 0.0), shears);
        scene.idle(17);
        scene.world.modifyEntity(entity1, Entity::m_146870_);
        scene.world.modifyBlockEntityNBT(deployerSelection, teType, nbt -> nbt.m_128365_("HeldItem", (Tag)shears.serializeNBT()));
        scene.idle(10);
        scene.overlay.showText(60).placeNearTarget().pointAt(util.vector.of(3.0, 2.5, 3.0)).text("Only items matching the filter can now be inserted...");
        scene.idle(70);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.modifyEntity(sheep, e -> ((Sheep)e).m_29878_(true));
        scene.effects.emitParticles(util.vector.topOf(deployerPos.m_122025_(2)).m_82520_(0.0, -0.25, 0.0), EmitParticlesInstruction.Emitter.withinBlockSpace(new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50100_.m_49966_()), util.vector.of(0.0, 0.0, 0.0)), 25.0f, 1);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.world.showSection(util.select.position(deployerPos.m_122012_()), Direction.SOUTH);
        scene.idle(25);
        scene.overlay.showText(80).placeNearTarget().pointAt(util.vector.of(3.5, 1.25, 1.25)).text("...and only non-matching items will be extracted");
        scene.world.flapFunnel(deployerPos.m_122012_(), true);
        scene.world.createItemEntity(util.vector.centerOf(deployerPos.m_122012_()).m_82492_(0.0, 0.45, 0.0), util.vector.of(0.0, 0.0, -0.1), new ItemStack((ItemLike)Items.f_41876_));
        scene.markAsFinished();
        for (int i = 0; i < 10; ++i) {
            scene.idle(26);
            scene.world.moveDeployer(deployerPos, 1.0f, 25);
            scene.idle(26);
            scene.world.moveDeployer(deployerPos, -1.0f, 25);
            scene.idle(26);
        }
    }

    public static void modes(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer_modes", "Modes of the Deployer");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 3, 3, 1, 5), Direction.DOWN);
        scene.idle(10);
        BlockPos deployerPos = util.grid.at(3, 1, 2);
        Vec3 frontVec = util.vector.blockSurface(deployerPos, Direction.WEST).m_82520_(-0.125, 0.0, 0.0);
        Selection grassBlock = util.select.position(1, 1, 2);
        Selection deployerSelection = util.select.position(deployerPos);
        scene.world.showSection(deployerSelection, Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(grassBlock, Direction.DOWN);
        scene.idle(10);
        ItemStack tool = new ItemStack((ItemLike)Items.f_42434_);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(deployerPos), Pointing.DOWN).withItem(tool), 30);
        scene.idle(7);
        scene.world.modifyBlockEntityNBT(deployerSelection, DeployerBlockEntity.class, nbt -> nbt.m_128365_("HeldItem", (Tag)tool.serializeNBT()));
        scene.idle(45);
        scene.world.setKineticSpeed(util.select.position(2, 0, 5), 16.0f);
        scene.world.setKineticSpeed(util.select.layer(1), -32.0f);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 1, 2)).text("By default, a Deployer imitates a Right-click interaction");
        scene.idle(26);
        scene.world.replaceBlocks(grassBlock, Blocks.f_50093_.m_49966_(), false);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.idle(46);
        scene.overlay.showControls(new InputWindowElement(frontVec, Pointing.LEFT).rightClick().withWrench(), 40);
        scene.idle(7);
        scene.world.modifyBlockEntityNBT(deployerSelection, DeployerBlockEntity.class, nbt -> nbt.m_128359_("Mode", "PUNCH"));
        scene.idle(45);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 1, 2)).text("Using a Wrench, it can be set to imitate a Left-click instead");
        BlockPos breakingPos = deployerPos.m_122025_(2);
        for (int i = 0; i < 4; ++i) {
            scene.idle(26);
            scene.world.moveDeployer(deployerPos, 1.0f, 25);
            scene.idle(26);
            scene.world.incrementBlockBreakingProgress(breakingPos);
            scene.world.incrementBlockBreakingProgress(breakingPos);
            scene.world.incrementBlockBreakingProgress(breakingPos);
            scene.world.moveDeployer(deployerPos, -1.0f, 25);
            if (i == 3) {
                scene.world.createItemEntity(util.vector.centerOf(breakingPos), util.vector.of(0.0, 0.0, 0.0), new ItemStack((ItemLike)Blocks.f_50493_));
            }
            scene.idle(26);
            if (i != 0) continue;
            scene.markAsFinished();
        }
    }

    public static void processing(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer_processing", "Processing Items using Deployers");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        ElementLink<WorldSectionElement> depot = scene.world.showIndependentSection(util.select.position(2, 1, 1), Direction.DOWN);
        scene.world.moveSection(depot, util.vector.of(0.0, 0.0, 1.0), 0);
        scene.idle(10);
        Selection pressS = util.select.position(2, 3, 2);
        BlockPos pressPos = util.grid.at(2, 3, 2);
        BlockPos depotPos = util.grid.at(2, 1, 1);
        scene.world.setKineticSpeed(pressS, 0.0f);
        scene.world.showSection(pressS, Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(util.select.fromTo(2, 1, 3, 2, 1, 5), Direction.NORTH);
        scene.idle(3);
        scene.world.showSection(util.select.position(2, 2, 3), Direction.SOUTH);
        scene.idle(3);
        scene.world.showSection(util.select.position(2, 3, 3), Direction.NORTH);
        scene.world.setKineticSpeed(pressS, -32.0f);
        scene.effects.indicateSuccess(pressPos);
        scene.idle(10);
        ItemStack tool = AllItems.SAND_PAPER.asStack();
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(pressPos.m_7495_(), Direction.EAST).m_82520_(0.0, 0.15, 0.0), Pointing.RIGHT).withItem(tool), 30);
        scene.idle(7);
        scene.world.modifyBlockEntityNBT(pressS, DeployerBlockEntity.class, nbt -> nbt.m_128365_("HeldItem", (Tag)tool.serializeNBT()));
        scene.idle(25);
        Vec3 pressSide = util.vector.blockSurface(pressPos, Direction.WEST);
        scene.overlay.showText(60).pointAt(pressSide).placeNearTarget().attachKeyFrame().text("With a fitting held item, Deployers can process items provided beneath them");
        scene.idle(80);
        scene.overlay.showText(60).pointAt(pressSide.m_82492_(0.0, 2.0, 0.0)).placeNearTarget().text("The Input items can be dropped or placed on a Depot under the Deployer");
        scene.idle(50);
        ItemStack quartz = AllItems.ROSE_QUARTZ.asStack();
        scene.world.createItemOnBeltLike(depotPos, Direction.NORTH, quartz);
        Vec3 depotCenter = util.vector.centerOf(depotPos.m_122019_());
        scene.overlay.showControls(new InputWindowElement(depotCenter, Pointing.UP).withItem(quartz), 30);
        scene.idle(10);
        Vec3 targetV = util.vector.centerOf(pressPos).m_82492_(0.0, 1.65, 0.0);
        scene.world.moveDeployer(pressPos, 1.0f, 30);
        scene.idle(30);
        scene.world.moveDeployer(pressPos, -1.0f, 30);
        scene.debug.enqueueCallback(s -> SandPaperItem.spawnParticles(targetV, quartz, s.getWorld()));
        scene.world.removeItemsFromBelt(depotPos);
        ItemStack polished = AllItems.POLISHED_ROSE_QUARTZ.asStack();
        scene.world.createItemOnBeltLike(depotPos, Direction.UP, polished);
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(depotCenter, Pointing.UP).withItem(polished), 50);
        scene.idle(60);
        scene.world.hideIndependentSection(depot, Direction.NORTH);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 3, 0, 2, 3), Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(util.select.fromTo(4, 1, 2, 0, 2, 2), Direction.SOUTH);
        scene.idle(20);
        BlockPos beltPos = util.grid.at(0, 1, 2);
        scene.overlay.showText(40).pointAt(util.vector.blockSurface(beltPos, Direction.WEST)).placeNearTarget().attachKeyFrame().text("When items are provided on a belt...");
        scene.idle(30);
        ElementLink<BeltItemElement> ingot = scene.world.createItemOnBelt(beltPos, Direction.SOUTH, quartz);
        scene.idle(15);
        ElementLink<BeltItemElement> ingot2 = scene.world.createItemOnBelt(beltPos, Direction.SOUTH, quartz);
        scene.idle(15);
        scene.world.stallBeltItem(ingot, true);
        scene.world.moveDeployer(pressPos, 1.0f, 30);
        scene.overlay.showText(50).pointAt(pressSide).placeNearTarget().attachKeyFrame().text("The Deployer will hold and process them automatically");
        scene.idle(30);
        scene.world.moveDeployer(pressPos, -1.0f, 30);
        scene.debug.enqueueCallback(s -> SandPaperItem.spawnParticles(targetV, quartz, s.getWorld()));
        scene.world.removeItemsFromBelt(pressPos.m_6625_(2));
        ingot = scene.world.createItemOnBelt(pressPos.m_6625_(2), Direction.UP, polished);
        scene.world.stallBeltItem(ingot, true);
        scene.idle(15);
        scene.world.stallBeltItem(ingot, false);
        scene.idle(15);
        scene.world.stallBeltItem(ingot2, true);
        scene.world.moveDeployer(pressPos, 1.0f, 30);
        scene.idle(30);
        scene.world.moveDeployer(pressPos, -1.0f, 30);
        scene.debug.enqueueCallback(s -> SandPaperItem.spawnParticles(targetV, quartz, s.getWorld()));
        scene.world.removeItemsFromBelt(pressPos.m_6625_(2));
        ingot2 = scene.world.createItemOnBelt(pressPos.m_6625_(2), Direction.UP, polished);
        scene.world.stallBeltItem(ingot2, true);
        scene.idle(15);
        scene.world.stallBeltItem(ingot2, false);
    }

    public static void redstone(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer_redstone", "Controlling Deployers with Redstone");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 5, 3, 1, 3), Direction.DOWN);
        BlockPos deployerPos = util.grid.at(3, 1, 3);
        Selection redstone = util.select.fromTo(3, 1, 1, 3, 1, 2);
        BlockPos leverPos = util.grid.at(3, 1, 1);
        scene.world.toggleRedstonePower(redstone);
        scene.idle(26);
        scene.world.moveDeployer(deployerPos, 1.0f, 30);
        scene.idle(31);
        scene.world.moveDeployer(deployerPos, -1.0f, 30);
        scene.world.showSection(redstone, Direction.SOUTH);
        scene.idle(31);
        scene.world.toggleRedstonePower(redstone);
        scene.effects.indicateRedstone(leverPos);
        scene.idle(10);
        scene.overlay.showText(60).colored(PonderPalette.RED).attachKeyFrame().pointAt(util.vector.topOf(deployerPos)).placeNearTarget().text("When powered by Redstone, Deployers will not activate");
        scene.idle(70);
        scene.world.toggleRedstonePower(redstone);
        scene.idle(10);
        scene.world.moveDeployer(deployerPos, 1.0f, 30);
        scene.idle(10);
        scene.world.toggleRedstonePower(redstone);
        scene.effects.indicateRedstone(leverPos);
        scene.idle(21);
        scene.overlay.showText(60).pointAt(util.vector.topOf(deployerPos)).placeNearTarget().text("Before stopping, the Deployer will finish any started cycles");
        scene.world.moveDeployer(deployerPos, -1.0f, 30);
        scene.idle(70);
        scene.world.toggleRedstonePower(redstone);
        scene.idle(3);
        scene.world.toggleRedstonePower(redstone);
        scene.effects.indicateRedstone(leverPos);
        scene.world.moveDeployer(deployerPos, 1.0f, 30);
        scene.overlay.showText(100).colored(PonderPalette.GREEN).attachKeyFrame().pointAt(util.vector.topOf(deployerPos)).placeNearTarget().text("Thus, a negative pulse can be used to trigger exactly one activation cycle");
        scene.idle(31);
        scene.world.moveDeployer(deployerPos, -1.0f, 30);
        scene.idle(40);
    }

    public static void contraption(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("deployer_contraption", "Using Deployers on Contraptions");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.9f);
        Selection flowers = util.select.fromTo(4, 1, 1, 1, 1, 1);
        scene.world.replaceBlocks(flowers, Blocks.f_50016_.m_49966_(), false);
        Selection kinetics = util.select.fromTo(5, 1, 6, 5, 1, 3);
        BlockPos deployerPos = util.grid.at(4, 1, 3);
        Selection deployerSelection = util.select.position(deployerPos);
        scene.world.cycleBlockProperty(deployerPos, (Property<?>)DeployerBlock.AXIS_ALONG_FIRST_COORDINATE);
        scene.world.showSection(util.select.layer(0).add(flowers), Direction.UP);
        scene.idle(5);
        ElementLink<WorldSectionElement> pistonHead = scene.world.showIndependentSection(util.select.fromTo(5, 1, 2, 8, 1, 2), Direction.DOWN);
        scene.world.moveSection(pistonHead, util.vector.of(0.0, 0.0, 1.0), 0);
        scene.world.showSection(kinetics, Direction.DOWN);
        scene.idle(5);
        ElementLink<WorldSectionElement> contraption = scene.world.showIndependentSection(deployerSelection, Direction.DOWN);
        scene.idle(5);
        scene.world.glueBlockOnto(util.grid.at(4, 2, 3), Direction.DOWN, contraption);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(deployerPos, Direction.WEST)).text("Whenever Deployers are moved as part of an animated Contraption...");
        scene.idle(70);
        scene.world.setKineticSpeed(util.select.position(4, 0, 6), -8.0f);
        scene.world.setKineticSpeed(kinetics, 16.0f);
        scene.world.moveSection(pistonHead, util.vector.of(-3.0, 0.0, 0.0), 100);
        scene.world.moveSection(contraption, util.vector.of(-3.0, 0.0, 0.0), 100);
        for (int x = 0; x < 4; ++x) {
            scene.world.moveDeployer(deployerPos, 1.0f, 9);
            scene.idle(10);
            scene.world.moveDeployer(deployerPos, -1.0f, 9);
            scene.world.restoreBlocks(util.select.position(4 - x, 1, 1));
            scene.idle(18);
        }
        scene.overlay.showSelectionWithText(flowers, 90).attachKeyFrame().colored(PonderPalette.GREEN).text("They activate at each visited location, using items from inventories anywhere on the contraption");
        scene.idle(100);
        scene.world.hideSection(flowers, Direction.UP);
        scene.idle(15);
        scene.world.replaceBlocks(flowers, Blocks.f_50016_.m_49966_(), false);
        scene.world.showSection(flowers, Direction.UP);
        Vec3 filterSlot = util.vector.blockSurface(deployerPos.m_122025_(3), Direction.WEST).m_82520_(0.0, 0.0, 0.125);
        scene.overlay.showFilterSlotInput(filterSlot, Direction.WEST, 80);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(filterSlot).text("The Filter slot can be used to specify which items to pull");
        scene.idle(70);
        ItemStack poppy = new ItemStack((ItemLike)Items.f_41940_);
        scene.overlay.showControls(new InputWindowElement(filterSlot, Pointing.DOWN).withItem(poppy), 30);
        scene.idle(7);
        scene.world.setFilterData(deployerSelection, DeployerBlockEntity.class, poppy);
        scene.idle(25);
        scene.world.setKineticSpeed(util.select.position(4, 0, 6), 8.0f);
        scene.world.setKineticSpeed(kinetics, -16.0f);
        scene.world.moveSection(pistonHead, util.vector.of(3.0, 0.0, 0.0), 100);
        scene.world.moveSection(contraption, util.vector.of(3.0, 0.0, 0.0), 100);
        for (int x = 0; x < 4; ++x) {
            scene.world.moveDeployer(deployerPos, 1.0f, 9);
            scene.idle(10);
            scene.world.moveDeployer(deployerPos, -1.0f, 9);
            scene.world.setBlock(util.grid.at(1 + x, 1, 1), Blocks.f_50112_.m_49966_(), false);
            scene.idle(18);
        }
    }
}

