/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;

public class CuriosHelper
implements ICuriosHelper {
    private static final Map<String, SlotAttributeWrapper> SLOT_ATTRIBUTES = new HashMap<String, SlotAttributeWrapper>();
    private static TriConsumer<String, Integer, LivingEntity> brokenCurioConsumerLegacy;
    private static Consumer<SlotContext> brokenCurioConsumer;

    @Override
    public LazyOptional<ICurio> getCurio(ItemStack stack) {
        return stack.getCapability(CuriosCapability.ITEM);
    }

    @Override
    public LazyOptional<ICuriosItemHandler> getCuriosHandler(@Nonnull LivingEntity livingEntity) {
        return livingEntity.getCapability(CuriosCapability.INVENTORY);
    }

    @Override
    public Set<String> getCurioTags(Item item) {
        return item.m_204114_().m_203616_().map(TagKey::f_203868_).filter(resourceLocation -> resourceLocation.m_135827_().equals("curios")).map(ResourceLocation::m_135815_).collect(Collectors.toSet());
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getEquippedCurios(LivingEntity livingEntity) {
        return CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).lazyMap(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            IItemHandlerModifiable[] itemHandlers = new IItemHandlerModifiable[curios.size()];
            int index = 0;
            for (ICurioStacksHandler stacksHandler : curios.values()) {
                if (index >= itemHandlers.length) continue;
                itemHandlers[index] = stacksHandler.getStacks();
                ++index;
            }
            return new CombinedInvWrapper(itemHandlers);
        });
    }

    @Override
    public void setEquippedCurio(@NotNull LivingEntity livingEntity, String identifier, int index, ItemStack stack) {
        this.getCuriosHandler(livingEntity).ifPresent(handler -> {
            IDynamicStackHandler stackHandler;
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            ICurioStacksHandler stacksHandler = curios.get(identifier);
            if (stacksHandler != null && index < (stackHandler = stacksHandler.getStacks()).getSlots()) {
                stackHandler.setStackInSlot(index, stack);
            }
        });
    }

    @Override
    public Optional<SlotResult> findFirstCurio(@Nonnull LivingEntity livingEntity, Item item) {
        return this.findFirstCurio(livingEntity, (ItemStack stack) -> stack.m_41720_() == item);
    }

    @Override
    public Optional<SlotResult> findFirstCurio(@Nonnull LivingEntity livingEntity, Predicate<ItemStack> filter) {
        SlotResult result = this.getCuriosHandler(livingEntity).map(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            for (String id : curios.keySet()) {
                ICurioStacksHandler stacksHandler = curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.m_41619_() || !filter.test(stack)) continue;
                    NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                    return new SlotResult(new SlotContext(id, livingEntity, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false), stack);
                }
            }
            return new SlotResult(null, ItemStack.f_41583_);
        }).orElse(new SlotResult(null, ItemStack.f_41583_));
        return result.stack().m_41619_() ? Optional.empty() : Optional.of(result);
    }

    @Override
    public List<SlotResult> findCurios(@Nonnull LivingEntity livingEntity, Item item) {
        return this.findCurios(livingEntity, (ItemStack stack) -> stack.m_41720_() == item);
    }

    @Override
    public List<SlotResult> findCurios(@Nonnull LivingEntity livingEntity, Predicate<ItemStack> filter) {
        ArrayList<SlotResult> result = new ArrayList<SlotResult>();
        this.getCuriosHandler(livingEntity).ifPresent(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            for (String id : curios.keySet()) {
                ICurioStacksHandler stacksHandler = curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.m_41619_() || !filter.test(stack)) continue;
                    NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                    result.add(new SlotResult(new SlotContext(id, livingEntity, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false), stack));
                }
            }
        });
        return result;
    }

    @Override
    public List<SlotResult> findCurios(@NotNull LivingEntity livingEntity, String ... identifiers) {
        ArrayList<SlotResult> result = new ArrayList<SlotResult>();
        HashSet<String> ids = new HashSet<String>(List.of(identifiers));
        this.getCuriosHandler(livingEntity).ifPresent(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            for (String id : curios.keySet()) {
                if (!ids.contains(id)) continue;
                ICurioStacksHandler stacksHandler = curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                    result.add(new SlotResult(new SlotContext(id, livingEntity, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false), stack));
                }
            }
        });
        return result;
    }

    @Override
    public Optional<SlotResult> findCurio(@Nonnull LivingEntity livingEntity, String identifier, int index) {
        SlotResult result = this.getCuriosHandler(livingEntity).map(handler -> {
            ItemStack stack;
            IDynamicStackHandler stackHandler;
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            ICurioStacksHandler stacksHandler = curios.get(identifier);
            if (stacksHandler != null && index < (stackHandler = stacksHandler.getStacks()).getSlots() && !(stack = stackHandler.getStackInSlot(index)).m_41619_()) {
                NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                return new SlotResult(new SlotContext(identifier, livingEntity, index, false, renderStates.size() > index && (Boolean)renderStates.get(index) != false), stack);
            }
            return new SlotResult(null, ItemStack.f_41583_);
        }).orElse(new SlotResult(null, ItemStack.f_41583_));
        return result.stack().m_41619_() ? Optional.empty() : Optional.of(result);
    }

    @Override
    @Nonnull
    public Optional<ImmutableTriple<String, Integer, ItemStack>> findEquippedCurio(Item item, @Nonnull LivingEntity livingEntity) {
        return this.findEquippedCurio((ItemStack stack) -> stack.m_41720_() == item, livingEntity);
    }

    @Override
    @Nonnull
    public Optional<ImmutableTriple<String, Integer, ItemStack>> findEquippedCurio(Predicate<ItemStack> filter, @Nonnull LivingEntity livingEntity) {
        ImmutableTriple result = this.getCuriosHandler(livingEntity).map(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            for (String id : curios.keySet()) {
                ICurioStacksHandler stacksHandler = curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.m_41619_() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
            }
            return new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.f_41583_);
        }).orElse(new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.f_41583_));
        return ((String)result.getLeft()).isEmpty() ? Optional.empty() : Optional.of(result);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier, ItemStack stack) {
        return this.getAttributeModifiers(new SlotContext(identifier, null, 0, false, true), UUID.randomUUID(), stack);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_("CurioAttributeModifiers", 9)) {
            ListTag listnbt = stack.m_41783_().m_128437_("CurioAttributeModifiers", 10);
            String identifier = slotContext.identifier();
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundTag compoundnbt = listnbt.m_128728_(i);
                if (!compoundnbt.m_128461_("Slot").equals(identifier)) continue;
                ResourceLocation rl = ResourceLocation.m_135820_((String)compoundnbt.m_128461_("AttributeName"));
                UUID id = uuid;
                if (rl == null) continue;
                if (compoundnbt.m_128441_("UUID")) {
                    id = compoundnbt.m_128342_("UUID");
                }
                if (id.getLeastSignificantBits() == 0L || id.getMostSignificantBits() == 0L) continue;
                AttributeModifier.Operation operation = AttributeModifier.Operation.m_22236_((int)compoundnbt.m_128451_("Operation"));
                double amount = compoundnbt.m_128459_("Amount");
                String name = compoundnbt.m_128461_("Name");
                if (rl.m_135827_().equals("curios")) {
                    String identifier1 = rl.m_135815_();
                    if (!CuriosApi.getSlot(identifier1).isPresent()) continue;
                    CuriosApi.getCuriosHelper().addSlotModifier((Multimap<Attribute, AttributeModifier>)multimap, identifier1, id, amount, operation);
                    continue;
                }
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(rl);
                if (attribute == null) continue;
                multimap.put((Object)attribute, (Object)new AttributeModifier(id, name, amount, operation));
            }
        } else {
            multimap = (Multimap)this.getCurio(stack).map(curio -> curio.getAttributeModifiers(slotContext, uuid)).orElse(multimap);
        }
        CurioAttributeModifierEvent evt = new CurioAttributeModifierEvent(stack, slotContext, uuid, (Multimap<Attribute, AttributeModifier>)multimap);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.getModifiers();
    }

    @Override
    public void addSlotModifier(Multimap<Attribute, AttributeModifier> map, String identifier, UUID uuid, double amount, AttributeModifier.Operation operation) {
        map.put((Object)CuriosHelper.getOrCreateSlotAttribute(identifier), (Object)new AttributeModifier(uuid, identifier, amount, operation));
    }

    @Override
    public void addSlotModifier(ItemStack stack, String identifier, String name, UUID uuid, double amount, AttributeModifier.Operation operation, String slot) {
        this.addModifier(stack, CuriosHelper.getOrCreateSlotAttribute(identifier), name, uuid, amount, operation, slot);
    }

    @Override
    public void addModifier(ItemStack stack, Attribute attribute, String name, UUID uuid, double amount, AttributeModifier.Operation operation, String slot) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128425_("CurioAttributeModifiers", 9)) {
            tag.m_128365_("CurioAttributeModifiers", (Tag)new ListTag());
        }
        ListTag listtag = tag.m_128437_("CurioAttributeModifiers", 10);
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128359_("Name", name);
        compoundtag.m_128347_("Amount", amount);
        compoundtag.m_128405_("Operation", operation.m_22235_());
        if (uuid != null) {
            compoundtag.m_128362_("UUID", uuid);
        }
        Object id = "";
        if (attribute instanceof SlotAttributeWrapper) {
            SlotAttributeWrapper wrapper = (SlotAttributeWrapper)attribute;
            id = "curios:" + wrapper.identifier;
        } else {
            ResourceLocation rl = ForgeRegistries.ATTRIBUTES.getKey((Object)attribute);
            if (rl != null) {
                id = rl.toString();
            }
        }
        if (!((String)id).isEmpty()) {
            compoundtag.m_128359_("AttributeName", (String)id);
        }
        compoundtag.m_128359_("Slot", slot);
        listtag.add((Object)compoundtag);
    }

    @Override
    public boolean isStackValid(SlotContext slotContext, ItemStack stack) {
        String id = slotContext.identifier();
        Set<String> tags = this.getCurioTags(stack.m_41720_());
        return !tags.isEmpty() && id.equals(SlotTypePreset.CURIO.getIdentifier()) || tags.contains(id) || tags.contains(SlotTypePreset.CURIO.getIdentifier());
    }

    @Override
    public void onBrokenCurio(SlotContext slotContext) {
        brokenCurioConsumer.accept(slotContext);
    }

    @Override
    public void setBrokenCurioConsumer(Consumer<SlotContext> consumer) {
        if (brokenCurioConsumer == null) {
            brokenCurioConsumer = consumer;
        }
    }

    @Override
    public void onBrokenCurio(String id, int index, LivingEntity damager) {
        brokenCurioConsumerLegacy.accept((Object)id, (Object)index, (Object)damager);
    }

    @Override
    public void setBrokenCurioConsumer(TriConsumer<String, Integer, LivingEntity> consumer) {
        if (brokenCurioConsumerLegacy == null) {
            brokenCurioConsumerLegacy = consumer;
        }
    }

    public static SlotAttributeWrapper getOrCreateSlotAttribute(String identifier) {
        return SLOT_ATTRIBUTES.computeIfAbsent(identifier, SlotAttributeWrapper::new);
    }

    public static class SlotAttributeWrapper
    extends Attribute {
        public final String identifier;

        private SlotAttributeWrapper(String identifier) {
            super("curios.slot." + identifier, 0.0);
            this.identifier = identifier;
        }
    }
}

