/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.api.background.example.with_input_string;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.api.background.MenuBackground;
import de.keksuccino.fancymenu.api.background.MenuBackgroundType;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class ExampleMenuBackgroundForInputString
extends MenuBackground {
    private ExternalTextureResourceLocation imageLocation = null;

    public ExampleMenuBackgroundForInputString(@Nonnull MenuBackgroundType type, String imagePath) {
        super("unused_identifier", type);
        File imageFile = new File(imagePath);
        if (imageFile.exists() && (imageFile.getPath().toLowerCase().endsWith(".jpg") || imageFile.getPath().toLowerCase().endsWith(".jpeg") || imageFile.getPath().toLowerCase().endsWith(".png"))) {
            this.imageLocation = TextureHandler.getResource((String)imageFile.getPath());
            if (this.imageLocation != null) {
                this.imageLocation.loadTexture();
            }
        }
    }

    @Override
    public void onOpenMenu() {
    }

    @Override
    public void render(GuiGraphics graphics, Screen screen, boolean keepAspectRatio) {
        try {
            if (this.imageLocation != null && this.imageLocation.isReady()) {
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!keepAspectRatio) {
                    graphics.m_280163_(this.imageLocation.getResourceLocation(), 0, 0, 1.0f, 1.0f, screen.f_96543_, screen.f_96544_, screen.f_96543_, screen.f_96544_);
                } else {
                    int w = this.imageLocation.getWidth();
                    int h = this.imageLocation.getHeight();
                    double ratio = (double)w / (double)h;
                    int wfinal = (int)((double)screen.f_96544_ * ratio);
                    int screenCenterX = screen.f_96543_ / 2;
                    if (wfinal < screen.f_96543_) {
                        graphics.m_280163_(this.imageLocation.getResourceLocation(), 0, 0, 1.0f, 1.0f, screen.f_96543_, screen.f_96544_, screen.f_96543_, screen.f_96544_);
                    } else {
                        graphics.m_280163_(this.imageLocation.getResourceLocation(), screenCenterX - wfinal / 2, 0, 1.0f, 1.0f, wfinal, screen.f_96544_, wfinal, screen.f_96544_);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

