/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.api.buttonaction;

import de.keksuccino.fancymenu.api.buttonaction.ButtonActionContainer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ButtonActionRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static Map<String, ButtonActionContainer> actions = new LinkedHashMap<String, ButtonActionContainer>();

    public static void registerButtonAction(ButtonActionContainer action) {
        if (action != null) {
            if (action.getIdentifier() != null) {
                ButtonActionContainer c;
                if (actions.containsKey(action.getIdentifier())) {
                    LOGGER.warn("[FANCYMENU] An action with the identifier '" + action.getIdentifier() + "' is already registered! Overriding action!");
                }
                if ((c = ButtonActionRegistry.getActionByName(action.getAction())) != null) {
                    LOGGER.warn("[FANCYMENU] An action with the name '" + action.getAction() + "' is already registered! Overriding action!");
                    ButtonActionRegistry.unregisterButtonAction(c.getIdentifier());
                }
                actions.put(action.getIdentifier(), action);
            } else {
                LOGGER.error("[FANCYMENU] Action identifier cannot be null for ButtonActionContainers!");
            }
        }
    }

    public static void unregisterButtonAction(String actionIdentifier) {
        actions.remove(actionIdentifier);
    }

    public static List<ButtonActionContainer> getActions() {
        ArrayList<ButtonActionContainer> l = new ArrayList<ButtonActionContainer>();
        actions.forEach((key, value) -> l.add((ButtonActionContainer)value));
        return l;
    }

    public static ButtonActionContainer getAction(String actionIdentifier) {
        return actions.get(actionIdentifier);
    }

    public static ButtonActionContainer getActionByName(String actionName) {
        for (ButtonActionContainer c : actions.values()) {
            if (c.getAction() == null || !c.getAction().equals(actionName)) continue;
            return c;
        }
        return null;
    }
}

