/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.sounds.SoundManager;

public abstract class ScrollAreaEntry
extends UIBase {
    public ScrollArea parent;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    public AdvancedButton buttonBase;
    protected Color backgroundColorIdle = AREA_BACKGROUND_COLOR;
    protected Color backgroundColorHover = ENTRY_COLOR_FOCUSED;
    protected boolean focusable = true;
    protected boolean focused = false;
    protected boolean playClickSound = true;
    public boolean unfocusOtherEntriesOnFocus = true;
    public boolean focusOnClick = true;
    public int index = 0;

    public ScrollAreaEntry(ScrollArea parent, int width, int height) {
        this.parent = parent;
        this.width = width;
        this.height = height;
        this.buttonBase = new AdvancedButton(0, 0, 0, 0, "", true, button -> {
            if (this.focusOnClick) {
                this.setFocused(true);
            }
            this.onClick(this);
        }){

            public void m_7435_(SoundManager p_93665_) {
                if (ScrollAreaEntry.this.playClickSound) {
                    super.m_7435_(p_93665_);
                }
            }

            public void m_88315_(GuiGraphics p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                if (ScrollAreaEntry.this.parent.isMouseInteractingWithGrabbers() || !ScrollAreaEntry.this.parent.isMouseInsideArea()) {
                    this.f_93622_ = false;
                }
                super.m_88315_(p_93657_, p_93658_, p_93659_, p_93660_);
            }

            public boolean m_198029_() {
                if (ScrollAreaEntry.this.parent.isMouseInteractingWithGrabbers() || !ScrollAreaEntry.this.parent.isMouseInsideArea()) {
                    return false;
                }
                return super.m_198029_();
            }

            public void m_5716_(double p_93371_, double p_93372_) {
                if (ScrollAreaEntry.this.parent.isMouseInteractingWithGrabbers() || !ScrollAreaEntry.this.parent.isMouseInsideArea()) {
                    return;
                }
                super.m_5716_(p_93371_, p_93372_);
            }
        };
        this.updateEntry();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.updateEntry();
        this.buttonBase.m_88315_(graphics, mouseX, mouseY, partial);
    }

    public abstract void onClick(ScrollAreaEntry var1);

    public void updateEntry() {
        this.buttonBase.m_252865_(this.x);
        this.buttonBase.m_253211_(this.y);
        this.buttonBase.m_93674_(this.width);
        this.buttonBase.setHeight(this.height);
        if (!this.isFocused()) {
            this.buttonBase.setBackgroundColor(this.backgroundColorIdle, this.backgroundColorHover, this.backgroundColorIdle, this.backgroundColorHover, 1);
        } else {
            this.buttonBase.setBackgroundColor(this.backgroundColorHover, this.backgroundColorHover, this.backgroundColorHover, this.backgroundColorHover, 1);
        }
    }

    public void setX(int x) {
        this.x = x;
        this.updateEntry();
    }

    public int getX() {
        return this.x;
    }

    public void setY(int y) {
        this.y = y;
        this.updateEntry();
    }

    public int getY() {
        return this.y;
    }

    public void setWidth(int width) {
        this.width = width;
        this.updateEntry();
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
        this.updateEntry();
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isFocused() {
        return this.focusable && this.focused;
    }

    public void setFocused(boolean focused) {
        if (this.focusable) {
            this.focused = focused;
            this.updateEntry();
            if (focused && this.unfocusOtherEntriesOnFocus) {
                for (ScrollAreaEntry e : this.parent.getEntries()) {
                    if (e == this) continue;
                    e.setFocused(false);
                }
            }
        }
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
        if (!focusable) {
            this.focused = false;
        }
    }

    public void setPlayClickSound(boolean playClickSound) {
        this.playClickSound = playClickSound;
    }

    public boolean isPlayClickSound() {
        return this.playClickSound;
    }

    public Color getBackgroundColorIdle() {
        return this.backgroundColorIdle;
    }

    public void setBackgroundColorIdle(Color backgroundColorIdle) {
        this.backgroundColorIdle = backgroundColorIdle;
        this.updateEntry();
    }

    public Color getBackgroundColorHover() {
        return this.backgroundColorHover;
    }

    public void setBackgroundColorHover(Color backgroundColorHover) {
        this.backgroundColorHover = backgroundColorHover;
        this.updateEntry();
    }

    public void setTooltip(String ... tooltipLines) {
        this.buttonBase.setDescription(tooltipLines);
    }
}

