/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.FMContextMenu;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollbar.ScrollBar;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorLine;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.formattingrules.TextEditorFormattingRules;
import de.keksuccino.fancymenu.menu.placeholder.v2.Placeholder;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderRegistry;
import de.keksuccino.fancymenu.mixin.client.IMixinEditBox;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    public Screen parentScreen;
    public CharacterFilter characterFilter;
    public Consumer<String> callback;
    public List<TextEditorLine> textFieldLines = new ArrayList<TextEditorLine>();
    public ScrollBar verticalScrollBar = new ScrollBar(ScrollBar.ScrollBarDirection.VERTICAL, 5, 40, 0, 0, 0, 0, (Color)null, null);
    public ScrollBar horizontalScrollBar = new ScrollBar(ScrollBar.ScrollBarDirection.HORIZONTAL, 40, 5, 0, 0, 0, 0, (Color)null, null);
    public ScrollBar verticalScrollBarPlaceholderMenu = new ScrollBar(ScrollBar.ScrollBarDirection.VERTICAL, 5, 40, 0, 0, 0, 0, (Color)null, null);
    public ScrollBar horizontalScrollBarPlaceholderMenu = new ScrollBar(ScrollBar.ScrollBarDirection.HORIZONTAL, 40, 5, 0, 0, 0, 0, (Color)null, null);
    public FMContextMenu rightClickContextMenu;
    public AdvancedButton cancelButton;
    public AdvancedButton doneButton;
    public AdvancedButton placeholderButton;
    public int lastCursorPosSetByUser = 0;
    public boolean justSwitchedLineByWordDeletion = false;
    public boolean triggeredFocusedLineWasTooHighInCursorPosMethod = false;
    public int headerHeight = 50;
    public int footerHeight = 50;
    public int borderLeft = 40;
    public int borderRight = 20;
    public int lineHeight = 14;
    public Color screenBackgroundColor = UIBase.SCREEN_BACKGROUND_COLOR;
    public Color editorAreaBorderColor = UIBase.ELEMENT_BORDER_COLOR_IDLE;
    public Color editorAreaBackgroundColor = UIBase.AREA_BACKGROUND_COLOR;
    public Color textColor = UIBase.TEXT_COLOR_GRAY_1;
    public Color focusedLineColor = UIBase.ENTRY_COLOR_FOCUSED;
    public Color scrollGrabberIdleColor = UIBase.SCROLL_GRABBER_IDLE_COLOR;
    public Color scrollGrabberHoverColor = UIBase.SCROLL_GRABBER_HOVER_COLOR;
    public Color sideBarColor = UIBase.SIDE_BAR_COLOR;
    public Color lineNumberTextColorNormal = UIBase.TEXT_COLOR_GREY_2;
    public Color lineNumberTextColorFocused = UIBase.TEXT_COLOR_GREY_3;
    public Color multilineNotSupportedNotificationColor = UIBase.TEXT_COLOR_RED_1;
    public Color placeholderEntryBackgroundColorIdle = UIBase.AREA_BACKGROUND_COLOR;
    public Color placeholderEntryBackgroundColorHover = UIBase.ENTRY_COLOR_FOCUSED;
    public Color placeholderEntryDotColorPlaceholder = UIBase.LISTING_DOT_BLUE;
    public Color placeholderEntryDotColorCategory = UIBase.LISTING_DOT_RED;
    public Color placeholderEntryLabelColor = UIBase.TEXT_COLOR_GRAY_1;
    public Color placeholderEntryBackToCategoriesLabelColor = UIBase.TEXT_COLOR_ORANGE_1;
    public int currentLineWidth;
    public int lastTickFocusedLineIndex = -1;
    public TextEditorLine startHighlightLine = null;
    public int startHighlightLineIndex = -1;
    public int endHighlightLineIndex = -1;
    public int overriddenTotalScrollHeight = -1;
    public List<Runnable> lineNumberRenderQueue = new ArrayList<Runnable>();
    public List<TextEditorFormattingRule> formattingRules = new ArrayList<TextEditorFormattingRule>();
    public int currentRenderCharacterIndexTotal = 0;
    public static boolean showPlaceholderMenu = false;
    public int placeholderMenuWidth = 120;
    public int placeholderMenuEntryHeight = 16;
    public List<PlaceholderMenuEntry> placeholderMenuEntries = new ArrayList<PlaceholderMenuEntry>();
    public boolean multilineMode = true;
    public long multilineNotSupportedNotificationDisplayStart = -1L;
    public boolean boldTitle = true;

    public TextEditorScreen(@Nullable Screen parent, @Nullable CharacterFilter characterFilter, Consumer<String> callback) {
        this(null, parent, characterFilter, callback);
    }

    public TextEditorScreen(@Nullable Component title, @Nullable Screen parent, @Nullable CharacterFilter characterFilter, Consumer<String> callback) {
        super((Component)(title != null ? title : Component.m_237113_((String)"")));
        this.f_96541_ = Minecraft.m_91087_();
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.parentScreen = parent;
        this.characterFilter = characterFilter;
        this.callback = callback;
        this.addLine();
        this.getLine(0).m_93692_(true);
        this.verticalScrollBar.setScrollWheelAllowed(true);
        this.verticalScrollBarPlaceholderMenu.setScrollWheelAllowed(true);
        this.updateRightClickContextMenu();
        this.formattingRules.addAll(TextEditorFormattingRules.getRules());
        this.updatePlaceholderEntries(null, true, true);
        this.updateCurrentLineWidth();
    }

    public void m_7856_() {
        Minecraft.m_91087_().m_91268_().m_85378_((double)Minecraft.m_91087_().m_91268_().m_85385_(((Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_()).intValue(), Minecraft.m_91087_().m_91390_()));
        this.f_96544_ = Minecraft.m_91087_().m_91268_().m_85446_();
        this.f_96543_ = Minecraft.m_91087_().m_91268_().m_85445_();
        super.m_7856_();
        this.verticalScrollBar.scrollAreaStartX = this.getEditorAreaX() + 1;
        this.verticalScrollBar.scrollAreaStartY = this.getEditorAreaY() + 1;
        this.verticalScrollBar.scrollAreaEndX = this.getEditorAreaX() + this.getEditorAreaWidth() - 2;
        this.verticalScrollBar.scrollAreaEndY = this.getEditorAreaY() + this.getEditorAreaHeight() - this.horizontalScrollBar.grabberHeight - 2;
        this.horizontalScrollBar.scrollAreaStartX = this.getEditorAreaX() + 1;
        this.horizontalScrollBar.scrollAreaStartY = this.getEditorAreaY() + 1;
        this.horizontalScrollBar.scrollAreaEndX = this.getEditorAreaX() + this.getEditorAreaWidth() - this.verticalScrollBar.grabberWidth - 2;
        this.horizontalScrollBar.scrollAreaEndY = this.getEditorAreaY() + this.getEditorAreaHeight() - 1;
        int placeholderAreaX = this.f_96543_ - this.borderRight - this.placeholderMenuWidth;
        int placeholderAreaY = this.getEditorAreaY();
        this.verticalScrollBarPlaceholderMenu.scrollAreaStartX = placeholderAreaX + 1;
        this.verticalScrollBarPlaceholderMenu.scrollAreaStartY = placeholderAreaY + 1;
        this.verticalScrollBarPlaceholderMenu.scrollAreaEndX = placeholderAreaX + this.placeholderMenuWidth - 2;
        this.verticalScrollBarPlaceholderMenu.scrollAreaEndY = placeholderAreaY + this.getEditorAreaHeight() - this.horizontalScrollBarPlaceholderMenu.grabberHeight - 2;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaStartX = placeholderAreaX + 1;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaStartY = placeholderAreaY + 1;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaEndX = placeholderAreaX + this.placeholderMenuWidth - this.verticalScrollBarPlaceholderMenu.grabberWidth - 2;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaEndY = placeholderAreaY + this.getEditorAreaHeight() - 1;
        this.verticalScrollBar.idleBarColor = this.scrollGrabberIdleColor;
        this.verticalScrollBar.hoverBarColor = this.scrollGrabberHoverColor;
        this.horizontalScrollBar.idleBarColor = this.scrollGrabberIdleColor;
        this.horizontalScrollBar.hoverBarColor = this.scrollGrabberHoverColor;
        this.verticalScrollBarPlaceholderMenu.idleBarColor = this.scrollGrabberIdleColor;
        this.verticalScrollBarPlaceholderMenu.hoverBarColor = this.scrollGrabberHoverColor;
        this.horizontalScrollBarPlaceholderMenu.idleBarColor = this.scrollGrabberIdleColor;
        this.horizontalScrollBarPlaceholderMenu.hoverBarColor = this.scrollGrabberHoverColor;
        this.cancelButton = new AdvancedButton(this.f_96543_ - this.borderRight - 100 - 5 - 100, this.f_96544_ - 35, 100, 20, Locals.localize((String)"fancymenu.guicomponents.cancel", (String[])new String[0]), true, button -> this.m_7379_());
        UIBase.applyDefaultButtonSkinTo(this.cancelButton);
        this.doneButton = new AdvancedButton(this.f_96543_ - this.borderRight - 100, this.f_96544_ - 35, 100, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, button -> {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
            if (this.callback != null) {
                this.callback.accept(this.getText());
            }
        });
        UIBase.applyDefaultButtonSkinTo(this.doneButton);
        this.placeholderButton = new AdvancedButton(this.f_96543_ - this.borderRight - 100, this.headerHeight / 2 - 10, 100, 20, Locals.localize((String)"fancymenu.ui.text_editor.placeholders", (String[])new String[0]), true, button -> {
            showPlaceholderMenu = !showPlaceholderMenu;
            this.m_232761_();
        });
        this.placeholderButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.dynamicvariabletextfield.variables.desc", (String[])new String[0]), (String)"%n%"));
        UIBase.applyDefaultButtonSkinTo(this.placeholderButton);
        if (showPlaceholderMenu) {
            this.placeholderButton.setBackgroundColor(UIBase.getButtonIdleColor(), UIBase.getButtonHoverColor(), this.editorAreaBorderColor, this.editorAreaBorderColor, 1);
            this.placeholderButton.setHeight(this.getEditorAreaY() - (this.headerHeight / 2 - 10));
        }
    }

    public void updateRightClickContextMenu() {
        TextEditorLine hoveredLine = this.getHoveredLine();
        if (this.rightClickContextMenu != null) {
            this.rightClickContextMenu.closeMenu();
        }
        this.rightClickContextMenu = new FMContextMenu();
        AdvancedButton cutButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.ui.text_editor.cut", (String[])new String[0]), true, press -> {
            Minecraft.m_91087_().f_91068_.m_90911_(this.cutHighlightedText());
            this.rightClickContextMenu.closeMenu();
        });
        this.rightClickContextMenu.addContent(cutButton);
        if (hoveredLine == null || !hoveredLine.isHighlightedHovered()) {
            cutButton.f_93623_ = false;
        }
        AdvancedButton copyButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.ui.text_editor.copy", (String[])new String[0]), true, press -> {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlightedText());
            this.rightClickContextMenu.closeMenu();
        });
        this.rightClickContextMenu.addContent(copyButton);
        if (hoveredLine == null || !hoveredLine.isHighlightedHovered()) {
            copyButton.f_93623_ = false;
        }
        AdvancedButton pasteButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.ui.text_editor.paste", (String[])new String[0]), true, press -> {
            this.pasteText(Minecraft.m_91087_().f_91068_.m_90876_());
            this.rightClickContextMenu.closeMenu();
        });
        this.rightClickContextMenu.addContent(pasteButton);
        this.rightClickContextMenu.addSeparator();
        AdvancedButton selectAllButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.ui.text_editor.select_all", (String[])new String[0]), true, press -> {
            for (TextEditorLine t : this.textFieldLines) {
                t.m_94208_(0);
                t.m_94196_(t.m_94155_().length());
            }
            this.setFocusedLine(this.getLineCount() - 1);
            this.startHighlightLineIndex = 0;
            this.endHighlightLineIndex = this.getLineCount() - 1;
            this.rightClickContextMenu.closeMenu();
        });
        this.rightClickContextMenu.addContent(selectAllButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.currentLineWidth <= this.getEditorAreaWidth()) {
            this.horizontalScrollBar.setScroll(0.0f);
        }
        if (this.getTotalLineHeight() <= this.getEditorAreaHeight()) {
            this.verticalScrollBar.setScroll(0.0f);
        }
        this.justSwitchedLineByWordDeletion = false;
        this.updateCurrentLineWidth();
        this.verticalScrollBar.setWheelScrollSpeed(1.0f / ((float)this.getTotalScrollHeight() / 500.0f));
        this.renderScreenBackground(graphics);
        this.renderEditorAreaBackground(graphics);
        Window win = Minecraft.m_91087_().m_91268_();
        double scale = win.m_85449_();
        int sciBottom = this.f_96544_ - this.footerHeight;
        RenderSystem.enableScissor((int)((int)((double)this.borderLeft * scale)), (int)((int)((double)win.m_85442_() - (double)sciBottom * scale)), (int)((int)((double)this.getEditorAreaWidth() * scale)), (int)((int)((double)this.getEditorAreaHeight() * scale)));
        this.formattingRules.forEach(rule -> rule.resetRule(this));
        this.currentRenderCharacterIndexTotal = 0;
        this.lineNumberRenderQueue.clear();
        this.updateLines(line -> {
            if (line.isInEditorArea()) {
                this.lineNumberRenderQueue.add(() -> this.renderLineNumber(graphics, (TextEditorLine)((Object)line)));
            }
            line.m_88315_(graphics, mouseX, mouseY, partial);
        });
        RenderSystem.disableScissor();
        this.renderLineNumberBackground(graphics, this.borderLeft);
        RenderSystem.enableScissor((int)0, (int)((int)((double)win.m_85442_() - (double)sciBottom * scale)), (int)((int)((double)this.borderLeft * scale)), (int)((int)((double)this.getEditorAreaHeight() * scale)));
        for (Runnable r : this.lineNumberRenderQueue) {
            r.run();
        }
        RenderSystem.disableScissor();
        this.lastTickFocusedLineIndex = this.getFocusedLineIndex();
        this.triggeredFocusedLineWasTooHighInCursorPosMethod = false;
        UIBase.renderBorder(graphics, this.borderLeft - 1, this.headerHeight - 1, this.getEditorAreaX() + this.getEditorAreaWidth(), this.f_96544_ - this.footerHeight + 1, 1, this.editorAreaBorderColor, true, true, true, true);
        this.verticalScrollBar.render(graphics);
        this.horizontalScrollBar.render(graphics);
        this.renderPlaceholderMenu(graphics, mouseX, mouseY, partial);
        this.cancelButton.m_88315_(graphics, mouseX, mouseY, partial);
        this.doneButton.m_88315_(graphics, mouseX, mouseY, partial);
        this.renderMultilineNotSupportedNotification(graphics, mouseX, mouseY, partial);
        UIBase.renderScaledContextMenu(graphics, this.rightClickContextMenu);
        this.tickMouseHighlighting();
        MutableComponent t = this.f_96539_.m_6881_();
        t.m_6270_(t.m_7383_().m_131136_(Boolean.valueOf(this.boldTitle)));
        int n = this.headerHeight / 2;
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280614_(this.f_96547_, (Component)t, this.borderLeft, n - 9 / 2, -1, false);
    }

    protected void renderMultilineNotSupportedNotification(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        long now = System.currentTimeMillis();
        if (!this.multilineMode && this.multilineNotSupportedNotificationDisplayStart + 3000L >= now) {
            int a = 255;
            int diff = (int)(this.multilineNotSupportedNotificationDisplayStart + 3000L - now);
            if (diff <= 1000) {
                float f = (float)diff / 1000.0f;
                a = Math.max(10, (int)(255.0f * f));
            }
            Color c = new Color(this.multilineNotSupportedNotificationColor.getRed(), this.multilineNotSupportedNotificationColor.getGreen(), this.multilineNotSupportedNotificationColor.getBlue(), a);
            String string = Locals.localize((String)"fancymenu.ui.text_editor.error.multiline_support", (String[])new String[0]);
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280056_(this.f_96547_, string, this.borderLeft, this.headerHeight - 9 - 5, c.getRGB(), false);
        }
    }

    protected void renderPlaceholderMenu(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (showPlaceholderMenu) {
            if (this.getTotalPlaceholderEntriesWidth() <= this.placeholderMenuWidth) {
                this.horizontalScrollBarPlaceholderMenu.setScroll(0.0f);
            }
            if (this.getTotalPlaceholderEntriesHeight() <= this.getEditorAreaHeight()) {
                this.verticalScrollBarPlaceholderMenu.setScroll(0.0f);
            }
            graphics.m_280509_(this.f_96543_ - this.borderRight - this.placeholderMenuWidth, this.getEditorAreaY(), this.f_96543_ - this.borderRight, this.getEditorAreaY() + this.getEditorAreaHeight(), this.editorAreaBackgroundColor.getRGB());
            Window win = Minecraft.m_91087_().m_91268_();
            double scale = win.m_85449_();
            int sciBottom = this.f_96544_ - this.footerHeight;
            RenderSystem.enableScissor((int)((int)((double)(this.f_96543_ - this.borderRight - this.placeholderMenuWidth) * scale)), (int)((int)((double)win.m_85442_() - (double)sciBottom * scale)), (int)((int)((double)this.placeholderMenuWidth * scale)), (int)((int)((double)this.getEditorAreaHeight() * scale)));
            ArrayList<PlaceholderMenuEntry> entries = new ArrayList<PlaceholderMenuEntry>();
            entries.addAll(this.placeholderMenuEntries);
            int index = 0;
            for (PlaceholderMenuEntry e : entries) {
                e.x = this.f_96543_ - this.borderRight - this.placeholderMenuWidth + this.getPlaceholderEntriesRenderOffsetX();
                e.y = this.getEditorAreaY() + this.placeholderMenuEntryHeight * index + this.getPlaceholderEntriesRenderOffsetY();
                e.render(graphics, mouseX, mouseY, partial);
                ++index;
            }
            RenderSystem.disableScissor();
            UIBase.renderBorder(graphics, this.f_96543_ - this.borderRight - this.placeholderMenuWidth - 1, this.headerHeight - 1, this.f_96543_ - this.borderRight, this.f_96544_ - this.footerHeight + 1, 1, this.editorAreaBorderColor, true, true, true, true);
            this.verticalScrollBarPlaceholderMenu.render(graphics);
            this.horizontalScrollBarPlaceholderMenu.render(graphics);
        }
        this.placeholderButton.m_88315_(graphics, mouseX, mouseY, partial);
    }

    public int getTotalPlaceholderEntriesHeight() {
        return this.placeholderMenuEntryHeight * this.placeholderMenuEntries.size();
    }

    public int getTotalPlaceholderEntriesWidth() {
        int i = this.placeholderMenuWidth;
        for (PlaceholderMenuEntry e : this.placeholderMenuEntries) {
            if (e.getWidth() <= i) continue;
            i = e.getWidth();
        }
        return i;
    }

    public int getPlaceholderEntriesRenderOffsetX() {
        int totalScrollWidth = Math.max(0, this.getTotalPlaceholderEntriesWidth() - this.placeholderMenuWidth);
        return -((int)((float)totalScrollWidth / 100.0f * (this.horizontalScrollBarPlaceholderMenu.getScroll() * 100.0f)));
    }

    public int getPlaceholderEntriesRenderOffsetY() {
        int totalScrollHeight = Math.max(0, this.getTotalPlaceholderEntriesHeight() - this.getEditorAreaHeight());
        return -((int)((float)totalScrollHeight / 100.0f * (this.verticalScrollBarPlaceholderMenu.getScroll() * 100.0f)));
    }

    public void updatePlaceholderEntries(@Nullable String category, boolean clearList, boolean addBackButton) {
        List<Placeholder> otherCategory;
        Map<String, List<Placeholder>> categories;
        if (clearList) {
            this.placeholderMenuEntries.clear();
        }
        if (!(categories = this.getPlaceholdersOrderedByCategories()).isEmpty() && (otherCategory = categories.get(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]))) != null) {
            if (category == null) {
                for (Map.Entry<String, List<Placeholder>> m : categories.entrySet()) {
                    if (m.getValue() == otherCategory) continue;
                    PlaceholderMenuEntry entry = new PlaceholderMenuEntry(this, (Component)Component.m_237113_((String)((String)m.getKey())), () -> this.updatePlaceholderEntries((String)m.getKey(), true, true));
                    entry.dotColor = this.placeholderEntryDotColorCategory;
                    entry.entryLabelColor = this.placeholderEntryLabelColor;
                    this.placeholderMenuEntries.add(entry);
                }
                this.updatePlaceholderEntries(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]), false, false);
            } else {
                List<Placeholder> placeholders;
                if (addBackButton) {
                    PlaceholderMenuEntry backToCategoriesEntry = new PlaceholderMenuEntry(this, (Component)Component.m_237113_((String)Locals.localize((String)"fancymenu.ui.text_editor.placeholders.back_to_categories", (String[])new String[0])), () -> this.updatePlaceholderEntries(null, true, true));
                    backToCategoriesEntry.dotColor = this.placeholderEntryDotColorCategory;
                    backToCategoriesEntry.entryLabelColor = this.placeholderEntryBackToCategoriesLabelColor;
                    this.placeholderMenuEntries.add(backToCategoriesEntry);
                }
                if ((placeholders = categories.get(category)) != null) {
                    for (Placeholder p : placeholders) {
                        PlaceholderMenuEntry entry = new PlaceholderMenuEntry(this, (Component)Component.m_237113_((String)p.getDisplayName()), () -> this.pasteText(p.getDefaultPlaceholderString().toString()));
                        List<String> desc = p.getDescription();
                        if (desc != null) {
                            entry.setDescription(desc.toArray(new String[0]));
                        }
                        entry.dotColor = this.placeholderEntryDotColorPlaceholder;
                        entry.entryLabelColor = this.placeholderEntryLabelColor;
                        this.placeholderMenuEntries.add(entry);
                    }
                }
            }
            for (PlaceholderMenuEntry e : this.placeholderMenuEntries) {
                e.backgroundColorIdle = this.placeholderEntryBackgroundColorIdle;
                e.backgroundColorHover = this.placeholderEntryBackgroundColorHover;
            }
            this.verticalScrollBarPlaceholderMenu.setScroll(0.0f);
            this.horizontalScrollBarPlaceholderMenu.setScroll(0.0f);
        }
    }

    protected Map<String, List<Placeholder>> getPlaceholdersOrderedByCategories() {
        LinkedHashMap<String, List<Placeholder>> categories = new LinkedHashMap<String, List<Placeholder>>();
        for (Placeholder p : PlaceholderRegistry.getPlaceholdersList()) {
            ArrayList<Placeholder> l;
            String cat = p.getCategory();
            if (cat == null) {
                cat = Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]);
            }
            if ((l = (ArrayList<Placeholder>)categories.get(cat)) == null) {
                l = new ArrayList<Placeholder>();
                categories.put(cat, l);
            }
            l.add(p);
        }
        List otherCategory = (List)categories.get(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]));
        if (otherCategory != null) {
            categories.remove(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]));
            categories.put(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]), otherCategory);
        }
        return categories;
    }

    protected void renderLineNumberBackground(GuiGraphics graphics, int width) {
        graphics.m_280509_(this.getEditorAreaX(), this.getEditorAreaY() - 1, this.getEditorAreaX() - width - 1, this.getEditorAreaY() + this.getEditorAreaHeight() + 1, this.sideBarColor.getRGB());
    }

    protected void renderLineNumber(GuiGraphics graphics, TextEditorLine line) {
        String lineNumberString = "" + (line.lineIndex + 1);
        int lineNumberWidth = this.f_96547_.m_92895_(lineNumberString);
        int n = this.getEditorAreaX() - 3 - lineNumberWidth;
        int n2 = line.m_252907_() + line.m_93694_() / 2;
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280056_(this.f_96547_, lineNumberString, n, n2 - 9 / 2, line.m_93696_() ? this.lineNumberTextColorFocused.getRGB() : this.lineNumberTextColorNormal.getRGB(), false);
    }

    protected void renderEditorAreaBackground(GuiGraphics graphics) {
        graphics.m_280509_(this.getEditorAreaX(), this.getEditorAreaY(), this.getEditorAreaX() + this.getEditorAreaWidth(), this.getEditorAreaY() + this.getEditorAreaHeight(), this.editorAreaBackgroundColor.getRGB());
    }

    protected void renderScreenBackground(GuiGraphics graphics) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, this.screenBackgroundColor.getRGB());
    }

    protected void tickMouseHighlighting() {
        TextEditorLine focused;
        if (!MouseInput.isLeftMouseDown()) {
            this.startHighlightLine = null;
            for (TextEditorLine t : this.textFieldLines) {
                t.isInMouseHighlightingMode = false;
            }
            return;
        }
        if (this.isInMouseHighlightingMode()) {
            float f;
            int mX = MouseInput.getMouseX();
            int mY = MouseInput.getMouseY();
            float speedMult = 0.008f;
            if (mX < this.borderLeft) {
                f = Math.max(0.01f, (float)(this.borderLeft - mX) * speedMult);
                this.horizontalScrollBar.setScroll(this.horizontalScrollBar.getScroll() - f);
            } else if (mX > this.getEditorAreaX() + this.getEditorAreaWidth()) {
                f = Math.max(0.01f, (float)(mX - (this.getEditorAreaX() + this.getEditorAreaWidth())) * speedMult);
                this.horizontalScrollBar.setScroll(this.horizontalScrollBar.getScroll() + f);
            }
            if (mY < this.headerHeight) {
                f = Math.max(0.01f, (float)(this.headerHeight - mY) * speedMult);
                this.verticalScrollBar.setScroll(this.verticalScrollBar.getScroll() - f);
            } else if (mY > this.f_96544_ - this.footerHeight) {
                f = Math.max(0.01f, (float)(mY - (this.f_96544_ - this.footerHeight)) * speedMult);
                this.verticalScrollBar.setScroll(this.verticalScrollBar.getScroll() + f);
            }
        }
        if (!this.isMouseInsideEditorArea()) {
            return;
        }
        TextEditorLine first = this.startHighlightLine;
        TextEditorLine hovered = this.getHoveredLine();
        if (hovered != null && !hovered.m_93696_() && first != null) {
            boolean firstIsAfterHovered;
            int firstIndex = this.getLineIndex(first);
            int hoveredIndex = this.getLineIndex(hovered);
            boolean firstIsBeforeHovered = hoveredIndex > firstIndex;
            boolean bl = firstIsAfterHovered = hoveredIndex < firstIndex;
            if (first.isInMouseHighlightingMode) {
                if (firstIsAfterHovered) {
                    this.setFocusedLine(this.getLineIndex(hovered));
                    if (!hovered.isInMouseHighlightingMode) {
                        hovered.isInMouseHighlightingMode = true;
                        hovered.getAsAccessor().setShiftPressedFancyMenu(false);
                        hovered.m_94192_(hovered.m_94155_().length());
                    }
                } else if (firstIsBeforeHovered) {
                    this.setFocusedLine(this.getLineIndex(hovered));
                    if (!hovered.isInMouseHighlightingMode) {
                        hovered.isInMouseHighlightingMode = true;
                        hovered.getAsAccessor().setShiftPressedFancyMenu(false);
                        hovered.m_94192_(0);
                    }
                } else if (first == hovered) {
                    this.setFocusedLine(this.getLineIndex(first));
                }
            }
            int startIndex = Math.min(hoveredIndex, firstIndex);
            int endIndex = Math.max(hoveredIndex, firstIndex);
            int index = 0;
            for (TextEditorLine t : this.textFieldLines) {
                if (t != hovered && t != first) {
                    if (index > startIndex && index < endIndex) {
                        if (firstIsAfterHovered) {
                            t.m_94196_(0);
                            t.m_94208_(t.m_94155_().length());
                        } else if (firstIsBeforeHovered) {
                            t.m_94196_(t.m_94155_().length());
                            t.m_94208_(0);
                        }
                    } else {
                        t.getAsAccessor().setShiftPressedFancyMenu(false);
                        t.m_94192_(0);
                        t.isInMouseHighlightingMode = false;
                    }
                }
                ++index;
            }
            this.startHighlightLineIndex = startIndex;
            this.endHighlightLineIndex = endIndex;
            if (first != hovered) {
                first.getAsAccessor().setShiftPressedFancyMenu(true);
                if (firstIsAfterHovered) {
                    first.m_94192_(0);
                } else if (firstIsBeforeHovered) {
                    first.m_94192_(first.m_94155_().length());
                }
                first.getAsAccessor().setShiftPressedFancyMenu(false);
            }
        }
        if ((focused = this.getFocusedLine()) != null && focused.isInMouseHighlightingMode) {
            if (this.startHighlightLineIndex == -1 && this.endHighlightLineIndex == -1) {
                this.endHighlightLineIndex = this.startHighlightLineIndex = this.getLineIndex(focused);
            }
            int i = Mth.m_14143_((float)MouseInput.getMouseX()) - focused.m_252754_();
            if (focused.getAsAccessor().getBorderedFancyMenu()) {
                i -= 4;
            }
            String s = this.f_96547_.m_92834_(focused.m_94155_().substring(focused.getAsAccessor().getDisplayPosFancyMenu()), focused.m_94210_());
            focused.getAsAccessor().setShiftPressedFancyMenu(true);
            focused.m_94192_(this.f_96547_.m_92834_(s, i).length() + focused.getAsAccessor().getDisplayPosFancyMenu());
            focused.getAsAccessor().setShiftPressedFancyMenu(false);
            if (focused.getAsAccessor().getHighlightPosFancyMenu() == focused.m_94207_() && this.startHighlightLineIndex == this.endHighlightLineIndex) {
                this.resetHighlighting();
            }
        }
    }

    public void updateLines(@Nullable Consumer<TextEditorLine> doAfterEachLineUpdate) {
        try {
            int index = 0;
            for (TextEditorLine line : this.textFieldLines) {
                line.lineIndex = index;
                line.m_253211_(this.headerHeight + this.lineHeight * index + this.getLineRenderOffsetY());
                line.m_252865_(this.borderLeft + this.getLineRenderOffsetX());
                line.m_93674_(this.currentLineWidth);
                line.setHeight(this.lineHeight);
                line.getAsAccessor().setDisplayPosFancyMenu(0);
                if (doAfterEachLineUpdate != null) {
                    doAfterEachLineUpdate.accept(line);
                }
                ++index;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCurrentLineWidth() {
        int longestTextWidth = 0;
        for (TextEditorLine f : this.textFieldLines) {
            if (f.textWidth <= longestTextWidth) continue;
            longestTextWidth = f.textWidth;
        }
        this.currentLineWidth = longestTextWidth + 30;
    }

    public int getLineRenderOffsetX() {
        return -((int)((float)this.getTotalScrollWidth() / 100.0f * (this.horizontalScrollBar.getScroll() * 100.0f)));
    }

    public int getLineRenderOffsetY() {
        return -((int)((float)this.getTotalScrollHeight() / 100.0f * (this.verticalScrollBar.getScroll() * 100.0f)));
    }

    public int getTotalLineHeight() {
        return this.lineHeight * this.textFieldLines.size();
    }

    @Nullable
    public TextEditorLine addLineAtIndex(int index) {
        TextEditorLine before;
        if (!this.multilineMode && this.getLineCount() > 0) {
            this.multilineNotSupportedNotificationDisplayStart = System.currentTimeMillis();
            return null;
        }
        TextEditorLine f = new TextEditorLine(Minecraft.m_91087_().f_91062_, 0, 0, 50, this.lineHeight, false, this.characterFilter, this);
        f.m_94199_(Integer.MAX_VALUE);
        f.lineIndex = index;
        if (index > 0 && (before = this.getLine(index - 1)) != null) {
            f.m_253211_(before.m_252907_() + this.lineHeight);
        }
        this.textFieldLines.add(index, f);
        return f;
    }

    @Nullable
    public TextEditorLine addLine() {
        return this.addLineAtIndex(this.getLineCount());
    }

    public void removeLineAtIndex(int index) {
        if (index < 1) {
            return;
        }
        if (index <= this.getLineCount() - 1) {
            this.textFieldLines.remove(index);
        }
    }

    public void removeLastLine() {
        this.removeLineAtIndex(this.getLineCount() - 1);
    }

    public int getLineCount() {
        return this.textFieldLines.size();
    }

    @Nullable
    public TextEditorLine getLine(int index) {
        return this.textFieldLines.get(index);
    }

    public void setFocusedLine(int index) {
        if (index <= this.getLineCount() - 1) {
            for (TextEditorLine f : this.textFieldLines) {
                f.m_93692_(false);
            }
            this.getLine(index).m_93692_(true);
        }
    }

    public int getFocusedLineIndex() {
        int index = 0;
        for (TextEditorLine f : this.textFieldLines) {
            if (f.m_93696_()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Nullable
    public TextEditorLine getFocusedLine() {
        int index = this.getFocusedLineIndex();
        if (index != -1) {
            return this.getLine(index);
        }
        return null;
    }

    public boolean isLineFocused() {
        return this.getFocusedLineIndex() > -1;
    }

    @Nullable
    public TextEditorLine getLineAfter(TextEditorLine line) {
        int index = this.getLineIndex(line);
        if (index > -1 && index < this.getLineCount() - 1) {
            return this.getLine(index + 1);
        }
        return null;
    }

    @Nullable
    public TextEditorLine getLineBefore(TextEditorLine line) {
        int index = this.getLineIndex(line);
        if (index > 0) {
            return this.getLine(index - 1);
        }
        return null;
    }

    public boolean isAtLeastOneLineInHighlightMode() {
        for (TextEditorLine t : this.textFieldLines) {
            if (!t.isInMouseHighlightingMode) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public List<TextEditorLine> getLinesBetweenIndexes(int startIndex, int endIndex) {
        startIndex = Math.min(Math.max(startIndex, 0), this.textFieldLines.size() - 1);
        endIndex = Math.min(Math.max(endIndex, 0), this.textFieldLines.size() - 1);
        ArrayList<TextEditorLine> l = new ArrayList<TextEditorLine>();
        l.addAll(this.textFieldLines.subList(startIndex, endIndex));
        if (!l.isEmpty()) {
            l.remove(0);
        }
        return l;
    }

    @Nullable
    public TextEditorLine getHoveredLine() {
        for (TextEditorLine t : this.textFieldLines) {
            if (!t.m_274382_()) continue;
            return t;
        }
        return null;
    }

    public int getLineIndex(TextEditorLine inputBox) {
        return this.textFieldLines.indexOf((Object)inputBox);
    }

    public void goUpLine() {
        int current;
        if (this.isLineFocused() && (current = Math.max(0, this.getFocusedLineIndex())) > 0) {
            TextEditorLine currentLine = this.getLine(current);
            this.setFocusedLine(current - 1);
            if (currentLine != null) {
                this.getFocusedLine().m_94192_(this.lastCursorPosSetByUser);
            }
        }
    }

    public void goDownLine(boolean isNewLine) {
        if (this.isLineFocused()) {
            int current = Math.max(0, this.getFocusedLineIndex());
            if (isNewLine) {
                this.addLineAtIndex(current + 1);
            }
            TextEditorLine currentLine = this.getLine(current);
            this.setFocusedLine(current + 1);
            if (currentLine != null) {
                TextEditorLine nextLine = this.getFocusedLine();
                if (isNewLine) {
                    String textBeforeCursor = currentLine.m_94155_().substring(0, currentLine.m_94207_());
                    String textAfterCursor = currentLine.m_94155_().substring(currentLine.m_94207_());
                    currentLine.m_94144_(textBeforeCursor);
                    nextLine.m_94144_(textAfterCursor);
                    nextLine.m_94192_(0);
                    if (textBeforeCursor.startsWith(" ")) {
                        int spaces = 0;
                        for (char c : textBeforeCursor.toCharArray()) {
                            if (!String.valueOf(c).equals(" ")) break;
                            ++spaces;
                        }
                        nextLine.m_94144_(textBeforeCursor.substring(0, spaces) + nextLine.m_94155_());
                        nextLine.m_94192_(spaces);
                    }
                } else {
                    nextLine.m_94192_(this.lastCursorPosSetByUser);
                }
            }
        }
    }

    public List<TextEditorLine> getCopyOfLines() {
        ArrayList<TextEditorLine> l = new ArrayList<TextEditorLine>();
        for (TextEditorLine t : this.textFieldLines) {
            TextEditorLine n = new TextEditorLine(this.f_96547_, 0, 0, 0, 0, false, this.characterFilter, this);
            n.m_94144_(t.m_94155_());
            n.m_93692_(t.m_93696_());
            n.m_94192_(t.m_94207_());
            l.add(n);
        }
        return l;
    }

    public boolean isTextHighlighted() {
        return this.startHighlightLineIndex != -1 && this.endHighlightLineIndex != -1;
    }

    public boolean isHighlightedTextHovered() {
        if (this.isTextHighlighted()) {
            ArrayList<TextEditorLine> highlightedLines = new ArrayList<TextEditorLine>();
            if (this.endHighlightLineIndex <= this.getLineCount() - 1) {
                highlightedLines.addAll(this.textFieldLines.subList(this.startHighlightLineIndex, this.endHighlightLineIndex + 1));
            }
            for (TextEditorLine t : highlightedLines) {
                if (!t.isHighlightedHovered()) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getHighlightedText() {
        try {
            if (this.startHighlightLineIndex != -1 && this.endHighlightLineIndex != -1) {
                ArrayList<TextEditorLine> lines = new ArrayList<TextEditorLine>();
                lines.add(this.getLine(this.startHighlightLineIndex));
                if (this.startHighlightLineIndex != this.endHighlightLineIndex) {
                    lines.addAll(this.getLinesBetweenIndexes(this.startHighlightLineIndex, this.endHighlightLineIndex));
                    lines.add(this.getLine(this.endHighlightLineIndex));
                }
                StringBuilder s = new StringBuilder();
                boolean b = false;
                for (TextEditorLine t : lines) {
                    if (b) {
                        s.append("\n");
                    }
                    s.append(t.m_94173_());
                    b = true;
                }
                String ret = s.toString();
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @NotNull
    public String cutHighlightedText() {
        String highlighted = this.getHighlightedText();
        this.deleteHighlightedText();
        return highlighted;
    }

    public void deleteHighlightedText() {
        int linesRemoved = 0;
        try {
            if (this.startHighlightLineIndex != -1 && this.endHighlightLineIndex != -1) {
                if (this.startHighlightLineIndex == this.endHighlightLineIndex) {
                    this.getLine(this.startHighlightLineIndex).m_94164_("");
                } else {
                    TextEditorLine start = this.getLine(this.startHighlightLineIndex);
                    start.m_94164_("");
                    TextEditorLine end = this.getLine(this.endHighlightLineIndex);
                    end.m_94164_("");
                    if (this.endHighlightLineIndex - this.startHighlightLineIndex > 1) {
                        for (TextEditorLine line : this.getLinesBetweenIndexes(this.startHighlightLineIndex, this.endHighlightLineIndex)) {
                            this.removeLineAtIndex(this.getLineIndex(line));
                            ++linesRemoved;
                        }
                    }
                    String oldStartValue = start.m_94155_();
                    start.m_94196_(start.m_94155_().length());
                    start.m_94208_(start.m_94207_());
                    start.m_94164_(end.m_94155_());
                    start.m_94196_(oldStartValue.length());
                    start.m_94208_(start.m_94207_());
                    this.removeLineAtIndex(this.getLineIndex(end));
                    ++linesRemoved;
                    this.setFocusedLine(this.startHighlightLineIndex);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.correctYScroll(-linesRemoved);
        this.resetHighlighting();
    }

    public void resetHighlighting() {
        this.startHighlightLineIndex = -1;
        this.endHighlightLineIndex = -1;
        for (TextEditorLine t : this.textFieldLines) {
            t.m_94208_(t.m_94207_());
        }
    }

    public boolean isInMouseHighlightingMode() {
        return MouseInput.isLeftMouseDown() && this.startHighlightLine != null;
    }

    public void pasteText(String text) {
        try {
            if (text != null && !text.equals("")) {
                int addedLinesCount = 0;
                if (this.isTextHighlighted()) {
                    this.deleteHighlightedText();
                }
                if (!this.isLineFocused()) {
                    this.setFocusedLine(this.getLineCount() - 1);
                    this.getFocusedLine().m_94201_();
                }
                TextEditorLine focusedLine = this.getFocusedLine();
                String textBeforeCursor = "";
                String textAfterCursor = "";
                if (focusedLine.m_94155_().length() > 0) {
                    textBeforeCursor = focusedLine.m_94155_().substring(0, focusedLine.m_94207_());
                    if (focusedLine.m_94207_() < focusedLine.m_94155_().length()) {
                        textAfterCursor = this.getFocusedLine().m_94155_().substring(focusedLine.m_94207_(), focusedLine.m_94155_().length());
                    }
                }
                focusedLine.m_94144_(textBeforeCursor);
                focusedLine.m_94196_(textBeforeCursor.length());
                String[] lines = new String[]{text};
                if (text.contains("\n")) {
                    lines = text.split("\n", -1);
                }
                if (!this.multilineMode && lines.length > 1) {
                    lines = new String[]{lines[0]};
                    this.multilineNotSupportedNotificationDisplayStart = System.currentTimeMillis();
                }
                Array.set(lines, lines.length - 1, lines[lines.length - 1] + textAfterCursor);
                if (lines.length == 1) {
                    this.getFocusedLine().m_94164_(lines[0]);
                } else if (lines.length > 1) {
                    int index = -1;
                    for (String s : lines) {
                        if (index == -1) {
                            index = this.getFocusedLineIndex();
                        } else {
                            this.addLineAtIndex(index);
                            ++addedLinesCount;
                        }
                        this.getLine(index).m_94164_(s);
                        ++index;
                    }
                    this.setFocusedLine(index - 1);
                    this.getFocusedLine().m_94196_(Math.max(0, this.getFocusedLine().m_94155_().length() - textAfterCursor.length()));
                    this.getFocusedLine().m_94208_(this.getFocusedLine().m_94207_());
                }
                this.correctYScroll(addedLinesCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.resetHighlighting();
    }

    public void setText(String text) {
        TextEditorLine t = this.getLine(0);
        this.textFieldLines.clear();
        this.textFieldLines.add(t);
        this.setFocusedLine(0);
        t.m_94144_("");
        t.m_94192_(0);
        this.pasteText(text);
        this.setFocusedLine(0);
        t.m_94192_(0);
        this.verticalScrollBar.setScroll(0.0f);
    }

    public String getText() {
        StringBuilder s = new StringBuilder();
        boolean b = false;
        for (TextEditorLine t : this.textFieldLines) {
            if (b) {
                s.append("\n");
            }
            s.append(t.m_94155_());
            b = true;
        }
        return s.toString();
    }

    @Nullable
    public String getTextBeforeCursor() {
        if (!this.isLineFocused()) {
            return null;
        }
        int focusedLineIndex = this.getFocusedLineIndex();
        ArrayList<TextEditorLine> lines = new ArrayList<TextEditorLine>();
        if (focusedLineIndex == 0) {
            lines.add(this.getLine(0));
        } else if (focusedLineIndex > 0) {
            lines.addAll(this.textFieldLines.subList(0, focusedLineIndex + 1));
        }
        TextEditorLine lastLine = (TextEditorLine)((Object)lines.get(lines.size() - 1));
        StringBuilder s = new StringBuilder();
        boolean b = false;
        for (TextEditorLine t : lines) {
            if (b) {
                s.append("\n");
            }
            if (t != lastLine) {
                s.append(t.m_94155_());
            } else {
                s.append(t.m_94155_().substring(0, t.m_94207_()));
            }
            b = true;
        }
        return s.toString();
    }

    @Nullable
    public String getTextAfterCursor() {
        if (!this.isLineFocused()) {
            return null;
        }
        int focusedLineIndex = this.getFocusedLineIndex();
        ArrayList<TextEditorLine> lines = new ArrayList<TextEditorLine>();
        if (focusedLineIndex == this.getLineCount() - 1) {
            lines.add(this.getLine(this.getLineCount() - 1));
        } else if (focusedLineIndex < this.getLineCount() - 1) {
            lines.addAll(this.textFieldLines.subList(focusedLineIndex, this.getLineCount()));
        }
        TextEditorLine firstLine = (TextEditorLine)((Object)lines.get(0));
        StringBuilder s = new StringBuilder();
        boolean b = false;
        for (TextEditorLine t : lines) {
            if (b) {
                s.append("\n");
            }
            if (t != firstLine) {
                s.append(t.m_94155_());
            } else {
                s.append(t.m_94155_().substring(t.m_94207_(), t.m_94155_().length()));
            }
            b = true;
        }
        return s.toString();
    }

    public boolean m_5534_(char character, int modifiers) {
        for (TextEditorLine l : this.textFieldLines) {
            l.m_5534_(character, modifiers);
        }
        return super.m_5534_(character, modifiers);
    }

    public boolean m_7933_(int keycode, int i1, int i2) {
        for (TextEditorLine l : this.textFieldLines) {
            l.m_7933_(keycode, i1, i2);
        }
        if (keycode == 257) {
            if (!this.isInMouseHighlightingMode() && this.multilineMode && this.isLineFocused()) {
                this.resetHighlighting();
                this.goDownLine(true);
                this.correctYScroll(1);
            }
            if (!this.multilineMode) {
                this.multilineNotSupportedNotificationDisplayStart = System.currentTimeMillis();
            }
            return true;
        }
        if (keycode == 265) {
            if (!this.isInMouseHighlightingMode()) {
                this.resetHighlighting();
                this.goUpLine();
                this.correctYScroll(0);
            }
            return true;
        }
        if (keycode == 264) {
            if (!this.isInMouseHighlightingMode()) {
                this.resetHighlighting();
                this.goDownLine(false);
                this.correctYScroll(0);
            }
            return true;
        }
        if (keycode == 259) {
            if (!this.isInMouseHighlightingMode()) {
                if (this.isTextHighlighted()) {
                    this.deleteHighlightedText();
                } else if (this.isLineFocused()) {
                    TextEditorLine focused = this.getFocusedLine();
                    focused.getAsAccessor().setShiftPressedFancyMenu(false);
                    focused.getAsAccessor().invokeDeleteTextFancyMenu(-1);
                    focused.getAsAccessor().setShiftPressedFancyMenu(Screen.m_96638_());
                }
                this.resetHighlighting();
            }
            return true;
        }
        if (Screen.m_96632_((int)keycode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlightedText());
            return true;
        }
        if (Screen.m_96630_((int)keycode)) {
            this.pasteText(Minecraft.m_91087_().f_91068_.m_90876_());
            return true;
        }
        if (Screen.m_96634_((int)keycode)) {
            for (TextEditorLine t : this.textFieldLines) {
                t.m_94208_(0);
                t.m_94196_(t.m_94155_().length());
            }
            this.setFocusedLine(this.getLineCount() - 1);
            this.startHighlightLineIndex = 0;
            this.endHighlightLineIndex = this.getLineCount() - 1;
            return true;
        }
        if (Screen.m_96628_((int)keycode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.cutHighlightedText());
            this.resetHighlighting();
            return true;
        }
        if (keycode == 262 || keycode == 263) {
            this.resetHighlighting();
            return true;
        }
        return super.m_7933_(keycode, i1, i2);
    }

    public boolean m_7920_(int i1, int i2, int i3) {
        for (TextEditorLine l : this.textFieldLines) {
            l.m_7920_(i1, i2, i3);
        }
        return super.m_7920_(i1, i2, i3);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isMouseInteractingWithGrabbers()) {
            for (TextEditorLine l : this.textFieldLines) {
                l.m_6375_(mouseX, mouseY, button);
            }
            if (this.isMouseInsideEditorArea()) {
                if (button == 1) {
                    this.rightClickContextMenu.closeMenu();
                }
                if (button == 0 || button == 1) {
                    boolean isHighlightedHovered = this.isHighlightedTextHovered();
                    TextEditorLine hoveredLine = this.getHoveredLine();
                    if (!this.rightClickContextMenu.isOpen()) {
                        if (button == 0 || !isHighlightedHovered) {
                            this.resetHighlighting();
                        }
                        if (hoveredLine == null) {
                            TextEditorLine focus = this.getLine(this.getLineCount() - 1);
                            for (TextEditorLine t : this.textFieldLines) {
                                if (MouseInput.getMouseY() < t.f_93621_ || MouseInput.getMouseY() > t.f_93621_ + t.m_93694_()) continue;
                                focus = t;
                                break;
                            }
                            this.setFocusedLine(this.getLineIndex(focus));
                            this.getFocusedLine().m_94201_();
                            this.correctYScroll(0);
                        } else if (button == 1 && !isHighlightedHovered) {
                            this.setFocusedLine(this.getLineIndex(hoveredLine));
                            String s = this.f_96547_.m_92834_(hoveredLine.m_94155_().substring(hoveredLine.getAsAccessor().getDisplayPosFancyMenu()), hoveredLine.m_94210_());
                            hoveredLine.m_94192_(this.f_96547_.m_92834_(s, MouseInput.getMouseX() - hoveredLine.m_252754_()).length() + hoveredLine.getAsAccessor().getDisplayPosFancyMenu());
                        }
                    }
                    if (button == 1) {
                        this.updateRightClickContextMenu();
                        UIBase.openScaledContextMenuAtMouse(this.rightClickContextMenu);
                    } else if (this.rightClickContextMenu.isOpen() && !this.rightClickContextMenu.isHoveredOrFocused()) {
                        this.rightClickContextMenu.closeMenu();
                        this.textFieldLines.forEach(line -> line.m_6375_(mouseX, mouseY, button));
                        this.m_6375_(mouseX, mouseY, button);
                    }
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_86600_() {
        for (TextEditorLine l : this.textFieldLines) {
            l.m_94120_();
        }
        super.m_86600_();
    }

    public void m_7379_() {
        if (this.parentScreen != null) {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
        } else {
            super.m_7379_();
        }
        if (this.callback != null) {
            this.callback.accept(null);
        }
    }

    public boolean isMouseInteractingWithGrabbers() {
        return this.verticalScrollBar.isGrabberGrabbed() || this.verticalScrollBar.isGrabberHovered() || this.horizontalScrollBar.isGrabberGrabbed() || this.horizontalScrollBar.isGrabberHovered();
    }

    public boolean isMouseInteractingWithPlaceholderGrabbers() {
        return this.verticalScrollBarPlaceholderMenu.isGrabberGrabbed() || this.verticalScrollBarPlaceholderMenu.isGrabberHovered() || this.horizontalScrollBarPlaceholderMenu.isGrabberGrabbed() || this.horizontalScrollBarPlaceholderMenu.isGrabberHovered();
    }

    public int getEditBoxCursorX(EditBox editBox) {
        try {
            int l;
            IMixinEditBox b = (IMixinEditBox)editBox;
            String s = this.f_96547_.m_92834_(editBox.m_94155_().substring(b.getDisplayPosFancyMenu()), editBox.m_94210_());
            int j = editBox.m_94207_() - b.getDisplayPosFancyMenu();
            boolean flag = j >= 0 && j <= s.length();
            boolean flag2 = editBox.m_94207_() < editBox.m_94155_().length() || editBox.m_94155_().length() >= b.getMaxLengthFancyMenu();
            int j1 = l = b.getBorderedFancyMenu() ? editBox.m_252754_() + 4 : editBox.m_252754_();
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 += this.f_96547_.m_92724_(b.getFormatterFancyMenu().apply(s1, b.getDisplayPosFancyMenu()));
            }
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + editBox.m_5711_() : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            return k1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void scrollToLine(int lineIndex, boolean bottom) {
        if (bottom) {
            this.scrollToLine(lineIndex, -Math.max(0, this.getEditorAreaHeight() - this.lineHeight));
        } else {
            this.scrollToLine(lineIndex, 0);
        }
    }

    public void scrollToLine(int lineIndex, int offset) {
        int totalLineHeight = this.getTotalScrollHeight();
        float f = (float)Math.max(0, (lineIndex + 1) * this.lineHeight - this.lineHeight) / (float)totalLineHeight;
        if (offset != 0) {
            f = offset > 0 ? (f += (float)offset / (float)totalLineHeight) : (f -= (float)Math.abs(offset) / (float)totalLineHeight);
        }
        this.verticalScrollBar.setScroll(f);
    }

    public int getTotalScrollHeight() {
        if (this.overriddenTotalScrollHeight != -1) {
            return this.overriddenTotalScrollHeight;
        }
        return this.getTotalLineHeight();
    }

    public int getTotalScrollWidth() {
        return this.currentLineWidth;
    }

    public void correctYScroll(int lineCountOffsetAfterRemovingAdding) {
        if (this.isInMouseHighlightingMode() || !this.isLineFocused()) {
            return;
        }
        int minY = this.getEditorAreaY();
        int maxY = this.getEditorAreaY() + this.getEditorAreaHeight();
        int currentLineY = this.getFocusedLine().m_252907_();
        if (currentLineY < minY) {
            this.scrollToLine(this.getFocusedLineIndex(), false);
        } else if (currentLineY + this.lineHeight > maxY) {
            this.scrollToLine(this.getFocusedLineIndex(), true);
        } else if (lineCountOffsetAfterRemovingAdding != 0) {
            this.overriddenTotalScrollHeight = -1;
            int removedAddedLineCount = Math.abs(lineCountOffsetAfterRemovingAdding);
            if (lineCountOffsetAfterRemovingAdding > 0) {
                this.overriddenTotalScrollHeight = this.getTotalScrollHeight() - this.lineHeight * removedAddedLineCount;
            } else if (lineCountOffsetAfterRemovingAdding < 0) {
                this.overriddenTotalScrollHeight = this.getTotalScrollHeight() + this.lineHeight * removedAddedLineCount;
            }
            this.updateLines(null);
            this.overriddenTotalScrollHeight = -1;
            int diffToTop = Math.max(0, this.getFocusedLine().m_252907_() - this.getEditorAreaY());
            this.scrollToLine(this.getFocusedLineIndex(), -diffToTop);
            this.correctYScroll(0);
        }
        if (this.getTotalLineHeight() <= this.getEditorAreaHeight()) {
            this.verticalScrollBar.setScroll(0.0f);
        }
    }

    public void correctXScroll(TextEditorLine line) {
        if (this.isInMouseHighlightingMode()) {
            return;
        }
        if (this.isLineFocused() && this.getFocusedLine() == line) {
            boolean textGotAdded;
            int oldX = line.f_93620_;
            this.updateCurrentLineWidth();
            this.updateLines(null);
            int newX = line.f_93620_;
            String oldValue = line.lastTickValue;
            String newValue = line.m_94155_();
            int cursorWidth = 2;
            if (line.m_94207_() >= newValue.length()) {
                cursorWidth = 6;
            }
            int editorAreaCenterX = this.getEditorAreaX() + this.getEditorAreaWidth() / 2;
            int cursorX = this.getEditBoxCursorX((EditBox)line);
            if (cursorX > editorAreaCenterX) {
                cursorX += cursorWidth + 5;
            } else if (cursorX < editorAreaCenterX) {
                cursorX -= cursorWidth + 5;
            }
            int maxToRight = this.getEditorAreaX() + this.getEditorAreaWidth();
            int maxToLeft = this.getEditorAreaX();
            float currentScrollX = this.horizontalScrollBar.getScroll();
            int currentLineW = this.getTotalScrollWidth();
            boolean textGotDeleted = oldValue.length() > newValue.length();
            boolean bl = textGotAdded = oldValue.length() < newValue.length();
            if (cursorX > maxToRight) {
                float f = (float)(cursorX - maxToRight) / (float)currentLineW;
                this.horizontalScrollBar.setScroll(currentScrollX + f);
            } else if (cursorX < maxToLeft) {
                float f = (float)(maxToLeft - cursorX) / (float)currentLineW;
                if (textGotDeleted) {
                    f = (float)(maxToRight - maxToLeft) / (float)currentLineW;
                }
                this.horizontalScrollBar.setScroll(currentScrollX - f);
            } else if (textGotDeleted && oldX < newX) {
                float f = (float)(newX - oldX) / (float)currentLineW;
                this.horizontalScrollBar.setScroll(currentScrollX + f);
            } else if (textGotAdded && oldX > newX) {
                float f = (float)(oldX - newX) / (float)currentLineW;
                this.horizontalScrollBar.setScroll(currentScrollX - f);
            }
            if (line.m_94207_() == 0) {
                this.horizontalScrollBar.setScroll(0.0f);
            }
        }
    }

    public boolean isMouseInsideEditorArea() {
        int xStart = this.borderLeft;
        int yStart = this.headerHeight;
        int xEnd = this.getEditorAreaX() + this.getEditorAreaWidth();
        int yEnd = this.f_96544_ - this.footerHeight;
        int mX = MouseInput.getMouseX();
        int mY = MouseInput.getMouseY();
        return mX >= xStart && mX <= xEnd && mY >= yStart && mY <= yEnd;
    }

    public int getEditorAreaWidth() {
        int i = this.f_96543_ - this.borderRight - this.borderLeft;
        if (showPlaceholderMenu) {
            i = i - this.placeholderMenuWidth - 15;
        }
        return i;
    }

    public int getEditorAreaHeight() {
        return this.f_96544_ - this.footerHeight - this.headerHeight;
    }

    public int getEditorAreaX() {
        return this.borderLeft;
    }

    public int getEditorAreaY() {
        return this.headerHeight;
    }

    public static class PlaceholderMenuEntry
    extends UIBase {
        public TextEditorScreen parent;
        public final Component label;
        public Runnable clickAction;
        public int x;
        public int y;
        public final int labelWidth;
        public Color backgroundColorIdle = Color.GRAY;
        public Color backgroundColorHover = Color.LIGHT_GRAY;
        public Color dotColor = Color.BLUE;
        public Color entryLabelColor = Color.WHITE;
        public AdvancedButton buttonBase;
        public Font font;

        public PlaceholderMenuEntry(@NotNull TextEditorScreen parent, @NotNull Component label, @NotNull Runnable clickAction) {
            this.font = Minecraft.m_91087_().f_91062_;
            this.parent = parent;
            this.label = label;
            this.clickAction = clickAction;
            this.labelWidth = this.font.m_92852_((FormattedText)this.label);
            this.buttonBase = new AdvancedButton(0, 0, this.getWidth(), this.getHeight(), "", true, button -> this.clickAction.run()){

                public boolean m_198029_() {
                    if (parent.isMouseInteractingWithPlaceholderGrabbers()) {
                        return false;
                    }
                    return super.m_198029_();
                }

                public void m_5716_(double p_93371_, double p_93372_) {
                    if (parent.isMouseInteractingWithPlaceholderGrabbers()) {
                        return;
                    }
                    super.m_5716_(p_93371_, p_93372_);
                }

                public void m_88315_(GuiGraphics p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                    if (parent.isMouseInteractingWithPlaceholderGrabbers()) {
                        this.f_93622_ = false;
                    }
                    super.m_88315_(p_93657_, p_93658_, p_93659_, p_93660_);
                }
            };
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            this.buttonBase.setBackgroundColor(this.backgroundColorIdle, this.backgroundColorHover, this.backgroundColorIdle, this.backgroundColorHover, 1);
            this.buttonBase.f_93620_ = this.x;
            this.buttonBase.f_93621_ = this.y;
            int yCenter = this.y + this.getHeight() / 2;
            this.buttonBase.m_88315_(graphics, mouseX, mouseY, partial);
            PlaceholderMenuEntry.renderListingDot(graphics, this.x + 5, yCenter - 2, this.dotColor);
            Objects.requireNonNull(this.font);
            graphics.m_280614_(this.font, this.label, this.x + 5 + 4 + 3, yCenter - 9 / 2, this.entryLabelColor.getRGB(), false);
        }

        public int getWidth() {
            return Math.max(this.parent.placeholderMenuWidth, 12 + this.labelWidth + 5);
        }

        public int getHeight() {
            return this.parent.placeholderMenuEntryHeight;
        }

        public boolean isHovered() {
            return this.buttonBase.m_198029_();
        }

        public void setDescription(String ... desc) {
            this.buttonBase.setDescription(desc);
        }
    }
}

