/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import de.keksuccino.fancymenu.events.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.menu.fancy.helper.MenuReloadedEvent;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.fancymenu.mixin.client.IMixinSplashRenderer;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SplashTextCustomizationItem
extends CustomizationItemBase {
    protected static Map<String, String> splashCache = new HashMap<String, String>();
    protected static boolean init = false;
    public float scale = 1.0f;
    public boolean shadow = true;
    public boolean bounce = true;
    public float rotation = 20.0f;
    public Color basecolor = new Color(255, 255, 0);
    public String basecolorString = "#ffff00";
    public boolean refreshOnMenuReload = false;
    public File splashfile;
    public String text = null;
    public boolean vanillaLike = false;
    protected float basescale = 1.8f;
    protected static boolean isNewMenu = false;
    protected boolean isNewMenuThis = false;
    protected static Screen lastScreen = null;
    protected static Map<String, String> vanillaLikeCache = new HashMap<String, String>();

    public SplashTextCustomizationItem(PropertiesSection item) {
        super(item);
        if (!init) {
            MinecraftForge.EVENT_BUS.register(SplashTextCustomizationItem.class);
            init = true;
        }
        if (this.action != null && this.action.equalsIgnoreCase("addsplash")) {
            String b;
            String sc;
            String sh;
            Color c;
            String co;
            String re;
            Object filepath;
            String vanillaLikeString = item.getEntryValue("vanilla-like");
            if (vanillaLikeString != null && vanillaLikeString.equals("true")) {
                this.vanillaLike = true;
            }
            if ((filepath = SplashTextCustomizationItem.fixBackslashPath(item.getEntryValue("splashfilepath"))) != null) {
                this.splashfile = new File((String)filepath);
                if (!this.splashfile.exists() || !this.splashfile.getAbsolutePath().replace("\\", "/").startsWith(Minecraft.m_91087_().f_91069_.getAbsolutePath().replace("\\", "/"))) {
                    filepath = Minecraft.m_91087_().f_91069_.getAbsolutePath().replace("\\", "/") + "/" + (String)filepath;
                    this.splashfile = new File((String)filepath);
                }
                if (!this.splashfile.exists() || !this.splashfile.getPath().toLowerCase().endsWith(".txt")) {
                    this.splashfile = null;
                }
            }
            if (!this.vanillaLike) {
                this.text = item.getEntryValue("text");
            } else if (vanillaLikeCache.containsKey(this.actionId)) {
                this.text = vanillaLikeCache.get(this.actionId);
            }
            String ro = item.getEntryValue("rotation");
            if (ro != null && MathUtils.isFloat((String)ro)) {
                this.rotation = Float.parseFloat(ro);
            }
            if ((re = item.getEntryValue("refresh")) != null && re.equalsIgnoreCase("true")) {
                this.refreshOnMenuReload = true;
            }
            if ((co = item.getEntryValue("basecolor")) != null && (c = RenderUtils.getColorFromHexString((String)co)) != null) {
                this.basecolor = c;
                this.basecolorString = co;
            }
            if ((sh = item.getEntryValue("shadow")) != null && sh.equalsIgnoreCase("false")) {
                this.shadow = false;
            }
            if ((sc = item.getEntryValue("scale")) != null && MathUtils.isFloat((String)sc)) {
                this.scale = Float.parseFloat(sc);
            }
            if ((b = item.getEntryValue("bouncing")) != null && b.equalsIgnoreCase("false")) {
                this.bounce = false;
            }
            this.value = "splash text";
            this.setWidth((int)(30.0f * this.basescale * this.scale));
            this.setHeight((int)(10.0f * this.basescale * this.scale));
        }
    }

    @Override
    public void render(GuiGraphics graphics, Screen menu) throws IOException {
        if (this.isNewMenuThis) {
            isNewMenu = false;
        }
        this.isNewMenuThis = isNewMenu;
        this.setWidth((int)(30.0f * this.basescale * this.scale));
        this.setHeight((int)(10.0f * this.basescale * this.scale));
        if (this.shouldRender()) {
            this.renderSplash(graphics, Minecraft.m_91087_().f_91062_, menu);
        }
    }

    protected void renderSplash(GuiGraphics graphics, Font font, Screen s) {
        String splash = null;
        if (this.vanillaLike && this.text == null) {
            this.text = ((IMixinSplashRenderer)Minecraft.m_91087_().m_91310_()).getSplashStringFancyMenu();
            vanillaLikeCache.put(this.actionId, this.text);
        }
        if (this.splashfile != null && this.text == null) {
            List l;
            if (isNewMenu && this.refreshOnMenuReload) {
                splashCache.remove(this.getActionId());
            }
            if (!splashCache.containsKey(this.getActionId()) && !(l = FileUtils.getFileLines((File)this.splashfile)).isEmpty()) {
                int i = MathUtils.getRandomNumberInRange((int)0, (int)(l.size() - 1));
                splashCache.put(this.getActionId(), (String)l.get(i));
            }
            if (splashCache.containsKey(this.getActionId())) {
                splash = splashCache.get(this.getActionId());
            }
        }
        if (this.text != null) {
            splash = this.text;
        }
        if (splash != null) {
            if (this.value != null) {
                splash = !SplashTextCustomizationItem.isEditorActive() ? PlaceholderParser.replacePlaceholders(splash) : StringUtils.convertFormatCodes((String)splash, (String)"&", (String)"\u00a7");
            }
            this.value = splash;
            float f = this.basescale;
            if (this.bounce) {
                f -= Mth.m_14154_((float)(Mth.m_14031_((float)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
            }
            f = f * 100.0f / (float)(font.m_92895_(splash) + 32);
            RenderSystem.enableBlend();
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(this.scale, this.scale, this.scale);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(this.getPosX(s) + this.getWidth() / 2) / this.scale, (float)this.getPosY(s) / this.scale, 0.0f);
            graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(this.rotation));
            graphics.m_280168_().m_85841_(f, f, f);
            int alpha = this.basecolor.getAlpha();
            int i = Mth.m_14167_((float)(this.opacity * 255.0f));
            if (i < alpha) {
                alpha = i;
            }
            Color c = new Color(this.basecolor.getRed(), this.basecolor.getGreen(), this.basecolor.getBlue(), alpha);
            graphics.m_280056_(Minecraft.m_91087_().f_91062_, splash, -(font.m_92895_(splash) / 2), 0, c.getRGB(), this.shadow);
            graphics.m_280168_().m_85849_();
            graphics.m_280168_().m_85849_();
        }
    }

    @SubscribeEvent
    public static void onInitScreenPre(InitOrResizeScreenEvent.Pre e) {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (!(s == null || lastScreen != null && lastScreen.getClass().getName().equals(s.getClass().getName()))) {
            isNewMenu = true;
        }
        lastScreen = s;
    }

    @SubscribeEvent
    public static void onMenuReloaded(MenuReloadedEvent e) {
        splashCache.clear();
    }
}

