/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.v3.rendering.ui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.mixin.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.mixin.client.IMixinButton;
import de.keksuccino.fancymenu.v3.ConsumingSupplier;
import de.keksuccino.fancymenu.v3.rendering.DrawableColor;
import de.keksuccino.fancymenu.v3.rendering.ui.UIBase;
import de.keksuccino.fancymenu.v3.rendering.ui.widget.UniqueWidget;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedButton
extends Button
implements UniqueWidget {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Minecraft mc = Minecraft.m_91087_();
    protected boolean enableLabel = true;
    @NotNull
    protected ButtonBackground background = VanillaButtonBackground.create().setParent(this);
    protected DrawableColor labelBaseColorNormal = DrawableColor.of(new Color(0xFFFFFF));
    protected DrawableColor labelBaseColorInactive = DrawableColor.of(new Color(0xA0A0A0));
    protected boolean labelShadow = true;
    @NotNull
    protected ConsumingSupplier<ExtendedButton, Component> labelSupplier = consumes -> Component.m_237119_();
    protected boolean forceDefaultTooltipStyle = false;
    @Nullable
    protected ConsumingSupplier<ExtendedButton, Boolean> activeSupplier;
    protected boolean focusable = true;
    @Nullable
    protected String identifier;
    protected int lastHoverState = -1;

    public ExtendedButton(int x, int y, int width, int height, @NotNull String label, @NotNull Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""), onPress, f_252438_);
        this.setLabel((Component)Component.m_237113_((String)label));
    }

    public ExtendedButton(int x, int y, int width, int height, @NotNull String label, @NotNull Button.OnPress onPress, Button.CreateNarration narration) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""), onPress, narration);
        this.setLabel((Component)Component.m_237113_((String)label));
    }

    public ExtendedButton(int x, int y, int width, int height, @NotNull Component label, @NotNull Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""), onPress, f_252438_);
        this.setLabel(label);
    }

    public ExtendedButton(int x, int y, int width, int height, @NotNull Component label, @NotNull Button.OnPress onPress, Button.CreateNarration narration) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""), onPress, narration);
        this.setLabel(label);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.updateIsActive();
        this.updateLabel();
        this.handleHover();
        super.m_88315_(graphics, mouseX, mouseY, partial);
    }

    public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.background.m_88315_(graphics, mouseX, mouseY, partial);
        this.renderLabelText(graphics);
    }

    protected void renderLabelText(GuiGraphics graphics) {
        if (this.enableLabel) {
            int k = this.f_93623_ ? this.labelBaseColorNormal.getColorIntWithAlpha(this.f_93625_) : this.labelBaseColorInactive.getColorIntWithAlpha(this.f_93625_);
            this.renderScrollingLabel(graphics, this.mc.f_91062_, 2, k);
        }
    }

    protected void renderScrollingLabel(@NotNull GuiGraphics graphics, @NotNull Font font, int spaceLeftRight, int textColor) {
        int xMin = this.m_252754_() + spaceLeftRight;
        int xMax = this.m_252754_() + this.m_5711_() - spaceLeftRight;
        this.renderScrollingLabelInternal(graphics, font, this.m_6035_(), xMin, this.m_252907_(), xMax, this.m_252907_() + this.m_93694_(), textColor);
    }

    protected void renderScrollingLabelInternal(@NotNull GuiGraphics graphics, Font font, @NotNull Component text, int xMin, int yMin, int xMax, int yMax, int textColor) {
        int textWidth = font.m_92852_((FormattedText)text);
        int textPosY = (yMin + yMax - 9) / 2 + 1;
        int maxTextWidth = xMax - xMin;
        if (textWidth > maxTextWidth) {
            int diffTextWidth = textWidth - maxTextWidth;
            double scrollTime = (double)Util.m_137550_() / 1000.0;
            double $$13 = Math.max((double)diffTextWidth * 0.5, 3.0);
            double $$14 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * scrollTime / $$13)) / 2.0 + 0.5;
            double textPosX = Mth.m_14139_((double)$$14, (double)0.0, (double)diffTextWidth);
            graphics.m_280588_(xMin, yMin, xMax, yMax);
            graphics.m_280614_(font, text, xMin - (int)textPosX, textPosY, textColor, this.labelShadow);
            graphics.m_280618_();
        } else {
            graphics.m_280614_(font, text, (int)((float)(xMin + xMax) / 2.0f - (float)font.m_92852_((FormattedText)text) / 2.0f), textPosY, textColor, this.labelShadow);
        }
    }

    protected void handleHover() {
        if (this.lastHoverState != -1 && this.lastHoverState != this.getHoverState()) {
            if (this.f_93622_) {
                this.background.onHover();
            } else {
                this.background.onEndHover();
            }
        }
        this.lastHoverState = this.getHoverState();
    }

    protected void updateLabel() {
        Component c = this.labelSupplier.get(this);
        if (c == null) {
            c = Component.m_237113_((String)"");
        }
        ((IMixinAbstractWidget)((Object)this)).setMessageFieldFancyMenu(c);
    }

    protected void updateIsActive() {
        Boolean b;
        if (this.activeSupplier != null && (b = this.activeSupplier.get(this)) != null) {
            this.f_93623_ = b;
        }
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    protected int getHoverState() {
        if (this.f_93622_) {
            return 1;
        }
        return 0;
    }

    protected int m_274533_() {
        int i = 1;
        if (!this.f_93623_) {
            i = 0;
        } else if (this.m_198029_()) {
            i = 2;
        }
        return 46 + i * 20;
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public ExtendedButton setFocusable(boolean focusable) {
        this.focusable = focusable;
        return this;
    }

    public boolean isForceDefaultTooltipStyle() {
        return this.forceDefaultTooltipStyle;
    }

    public ExtendedButton setForceDefaultTooltipStyle(boolean forceDefaultTooltipStyle) {
        this.forceDefaultTooltipStyle = forceDefaultTooltipStyle;
        return this;
    }

    @Deprecated
    public void m_93666_(@NotNull Component msg) {
        this.setLabel(msg);
    }

    @Deprecated
    @NotNull
    public Component m_6035_() {
        return super.m_6035_();
    }

    public ExtendedButton setLabel(@NotNull Component label) {
        this.labelSupplier = btn -> label;
        ((IMixinAbstractWidget)((Object)this)).setMessageFieldFancyMenu(label);
        return this;
    }

    public ExtendedButton setLabel(@NotNull String label) {
        this.labelSupplier = btn -> Component.m_237113_((String)label);
        return this;
    }

    public ExtendedButton setLabelSupplier(@NotNull ConsumingSupplier<ExtendedButton, Component> labelSupplier) {
        this.labelSupplier = labelSupplier;
        return this;
    }

    @NotNull
    public ConsumingSupplier<ExtendedButton, Component> getLabelSupplier() {
        return this.labelSupplier;
    }

    @NotNull
    public Component getLabel() {
        Component c = this.getLabelSupplier().get(this);
        if (c == null) {
            c = Component.m_237119_();
        }
        return c;
    }

    public boolean isLabelEnabled() {
        return this.enableLabel;
    }

    public ExtendedButton setLabelEnabled(boolean enabled) {
        this.enableLabel = enabled;
        return this;
    }

    public DrawableColor getLabelBaseColorNormal() {
        return this.labelBaseColorNormal;
    }

    public void setLabelBaseColorNormal(DrawableColor labelBaseColorNormal) {
        this.labelBaseColorNormal = labelBaseColorNormal;
    }

    public DrawableColor getLabelBaseColorInactive() {
        return this.labelBaseColorInactive;
    }

    public void setLabelBaseColorInactive(DrawableColor labelBaseColorInactive) {
        this.labelBaseColorInactive = labelBaseColorInactive;
    }

    public boolean isLabelShadowEnabled() {
        return this.labelShadow;
    }

    public ExtendedButton setLabelShadowEnabled(boolean enabled) {
        this.labelShadow = enabled;
        return this;
    }

    public ExtendedButton setIsActiveSupplier(@Nullable ConsumingSupplier<ExtendedButton, Boolean> isActiveSupplier) {
        this.activeSupplier = isActiveSupplier;
        return this;
    }

    @Nullable
    public ConsumingSupplier<ExtendedButton, Boolean> getIsActiveSupplier() {
        return this.activeSupplier;
    }

    @NotNull
    public ButtonBackground getBackground() {
        return this.background;
    }

    public ExtendedButton setBackground(@NotNull ButtonBackground background) {
        this.background = background;
        this.background.setParent(this);
        return this;
    }

    public Button.OnPress getPressAction() {
        return this.f_93717_;
    }

    public ExtendedButton setPressAction(@NotNull Button.OnPress pressAction) {
        ((IMixinButton)((Object)this)).setPressActionFancyMenu(pressAction);
        return this;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean m_93696_() {
        if (!this.focusable) {
            return false;
        }
        return super.m_93696_();
    }

    public void m_93692_(boolean $$0) {
        if (!this.focusable) {
            super.m_93692_(false);
            return;
        }
        super.m_93692_($$0);
    }

    public ExtendedButton setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.identifier;
    }

    public static class VanillaButtonBackground
    extends ButtonBackground {
        public static VanillaButtonBackground create() {
            return new VanillaButtonBackground();
        }

        @Override
        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            graphics.m_280246_(1.0f, 1.0f, 1.0f, this.parent.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            graphics.m_280027_(AbstractWidget.f_93617_, this.parent.m_252754_(), this.parent.m_252907_(), this.parent.m_5711_(), this.parent.m_93694_(), 20, 4, 200, 20, 0, this.parent.m_274533_());
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public void onHover() {
        }

        @Override
        public void onEndHover() {
        }
    }

    public static abstract class ButtonBackground
    implements Renderable {
        protected ExtendedButton parent;

        public abstract void m_88315_(@NotNull GuiGraphics var1, int var2, int var3, float var4);

        public abstract void onHover();

        public abstract void onEndHover();

        public ButtonBackground setParent(ExtendedButton parent) {
            this.parent = parent;
            return this;
        }
    }

    public static class MultiTypeButtonBackground
    extends ButtonBackground {
        @NotNull
        protected ButtonBackground backgroundNormal;
        @Nullable
        protected ButtonBackground backgroundHover;
        @Nullable
        protected ButtonBackground backgroundInactive;

        public static MultiTypeButtonBackground build(@Nullable Object backgroundNormal, @Nullable Object backgroundHover, @Nullable Object backgroundInactive) {
            IAnimationRenderer a;
            ResourceLocation r;
            MultiTypeButtonBackground b = new MultiTypeButtonBackground(null, null, null);
            if (backgroundNormal == null) {
                b.setBackgroundNormal(VanillaButtonBackground.create());
            } else if (backgroundNormal instanceof ResourceLocation) {
                r = (ResourceLocation)backgroundNormal;
                b.setBackgroundNormal(ImageButtonBackground.create(r, r));
            } else if (backgroundNormal instanceof IAnimationRenderer) {
                a = (IAnimationRenderer)backgroundNormal;
                b.setBackgroundNormal(AnimationButtonBackground.create(a, a));
            } else {
                b.setBackgroundNormal(VanillaButtonBackground.create());
            }
            if (backgroundHover == null) {
                b.setBackgroundHover(VanillaButtonBackground.create());
            } else if (backgroundHover instanceof ResourceLocation) {
                r = (ResourceLocation)backgroundHover;
                b.setBackgroundHover(ImageButtonBackground.create(r, r));
            } else if (backgroundHover instanceof IAnimationRenderer) {
                a = (IAnimationRenderer)backgroundHover;
                b.setBackgroundHover(AnimationButtonBackground.create(a, a));
            } else {
                b.setBackgroundHover(VanillaButtonBackground.create());
            }
            if (backgroundInactive == null) {
                b.setBackgroundInactive(VanillaButtonBackground.create());
            } else if (backgroundInactive instanceof ResourceLocation) {
                r = (ResourceLocation)backgroundInactive;
                b.setBackgroundInactive(ImageButtonBackground.create(r, r));
            } else if (backgroundInactive instanceof IAnimationRenderer) {
                a = (IAnimationRenderer)backgroundInactive;
                b.setBackgroundInactive(AnimationButtonBackground.create(a, a));
            } else {
                b.setBackgroundInactive(VanillaButtonBackground.create());
            }
            return b;
        }

        public static MultiTypeButtonBackground create(@NotNull ButtonBackground backgroundNormal) {
            return new MultiTypeButtonBackground(backgroundNormal, null, null);
        }

        public static MultiTypeButtonBackground create(@NotNull ButtonBackground backgroundNormal, @Nullable ButtonBackground backgroundHover) {
            return new MultiTypeButtonBackground(backgroundNormal, backgroundHover, null);
        }

        public static MultiTypeButtonBackground create(@NotNull ButtonBackground backgroundNormal, @Nullable ButtonBackground backgroundHover, @Nullable ButtonBackground backgroundInactive) {
            return new MultiTypeButtonBackground(backgroundNormal, backgroundHover, backgroundInactive);
        }

        public MultiTypeButtonBackground(@NotNull ButtonBackground backgroundNormal, @Nullable ButtonBackground backgroundHover, @Nullable ButtonBackground backgroundInactive) {
            this.backgroundNormal = backgroundNormal;
            this.backgroundHover = backgroundHover;
            this.backgroundInactive = backgroundInactive;
        }

        @Override
        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            this.getBackground().setParent(this.parent).m_88315_(graphics, mouseX, mouseY, partial);
        }

        @Override
        public void onHover() {
            this.backgroundNormal.onHover();
            if (this.backgroundHover != null) {
                this.backgroundHover.onHover();
            }
        }

        @Override
        public void onEndHover() {
            this.backgroundNormal.onEndHover();
            if (this.backgroundHover != null) {
                this.backgroundHover.onEndHover();
            }
        }

        @NotNull
        protected ButtonBackground getBackground() {
            if (!this.parent.f_93623_ && this.backgroundInactive != null) {
                return this.backgroundInactive;
            }
            if (this.parent.f_93622_ && this.parent.m_142518_() && this.backgroundHover != null) {
                return this.backgroundHover;
            }
            return this.backgroundNormal;
        }

        @Nullable
        public ButtonBackground getBackgroundInactive() {
            return this.backgroundInactive;
        }

        public MultiTypeButtonBackground setBackgroundInactive(@Nullable ButtonBackground backgroundInactive) {
            this.backgroundInactive = backgroundInactive;
            return this;
        }

        @NotNull
        public ButtonBackground getBackgroundNormal() {
            return this.backgroundNormal;
        }

        public MultiTypeButtonBackground setBackgroundNormal(@NotNull ButtonBackground backgroundNormal) {
            this.backgroundNormal = backgroundNormal;
            return this;
        }

        @Nullable
        public ButtonBackground getBackgroundHover() {
            return this.backgroundHover;
        }

        public MultiTypeButtonBackground setBackgroundHover(@Nullable ButtonBackground backgroundHover) {
            this.backgroundHover = backgroundHover;
            return this;
        }
    }

    public static class AnimationButtonBackground
    extends ButtonBackground {
        @NotNull
        protected IAnimationRenderer backgroundAnimationNormal;
        @Nullable
        protected IAnimationRenderer backgroundAnimationHover;
        @Nullable
        protected IAnimationRenderer backgroundAnimationInactive;
        protected boolean loop = true;
        protected boolean restartOnHover = true;

        public static AnimationButtonBackground create(@NotNull IAnimationRenderer backgroundAnimationNormal) {
            return new AnimationButtonBackground(backgroundAnimationNormal, null, null);
        }

        public static AnimationButtonBackground create(@NotNull IAnimationRenderer backgroundAnimationNormal, @Nullable IAnimationRenderer backgroundAnimationHover) {
            return new AnimationButtonBackground(backgroundAnimationNormal, backgroundAnimationHover, null);
        }

        public static AnimationButtonBackground create(@NotNull IAnimationRenderer backgroundAnimationNormal, @Nullable IAnimationRenderer backgroundAnimationHover, @Nullable IAnimationRenderer backgroundAnimationInactive) {
            return new AnimationButtonBackground(backgroundAnimationNormal, backgroundAnimationHover, backgroundAnimationInactive);
        }

        public AnimationButtonBackground(@NotNull IAnimationRenderer backgroundAnimationNormal, @Nullable IAnimationRenderer backgroundAnimationHover, @Nullable IAnimationRenderer backgroundAnimationInactive) {
            this.backgroundAnimationNormal = backgroundAnimationNormal;
            this.backgroundAnimationHover = backgroundAnimationHover;
            this.backgroundAnimationInactive = backgroundAnimationInactive;
        }

        @Override
        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.parent.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            this.renderBackgroundAnimation(graphics);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onHover() {
            AdvancedAnimation aa;
            IAnimationRenderer iAnimationRenderer;
            if (this.restartOnHover) {
                this.backgroundAnimationNormal.resetAnimation();
                iAnimationRenderer = this.backgroundAnimationNormal;
                if (iAnimationRenderer instanceof AdvancedAnimation) {
                    aa = (AdvancedAnimation)iAnimationRenderer;
                    aa.stopAudio();
                    aa.resetAudio();
                }
                if (this.backgroundAnimationHover != null) {
                    this.backgroundAnimationHover.resetAnimation();
                    iAnimationRenderer = this.backgroundAnimationHover;
                    if (iAnimationRenderer instanceof AdvancedAnimation) {
                        aa = (AdvancedAnimation)iAnimationRenderer;
                        aa.stopAudio();
                        aa.resetAudio();
                    }
                }
            }
            if ((iAnimationRenderer = this.backgroundAnimationNormal) instanceof AdvancedAnimation) {
                aa = (AdvancedAnimation)iAnimationRenderer;
                aa.stopAudio();
                aa.resetAudio();
            }
        }

        @Override
        public void onEndHover() {
            IAnimationRenderer iAnimationRenderer = this.backgroundAnimationHover;
            if (iAnimationRenderer instanceof AdvancedAnimation) {
                AdvancedAnimation aa = (AdvancedAnimation)iAnimationRenderer;
                aa.stopAudio();
                aa.resetAudio();
            }
        }

        protected void renderBackgroundAnimation(GuiGraphics graphics) {
            IAnimationRenderer a = this.getBackgroundAnimation();
            int cachedW = a.getWidth();
            int cachedH = a.getHeight();
            int cachedX = a.getPosX();
            int cachedY = a.getPosY();
            boolean cachedLoop = a.isGettingLooped();
            a.setWidth(this.parent.m_5711_());
            a.setHeight(this.parent.m_93694_());
            a.setPosX(this.parent.m_252754_());
            a.setPosY(this.parent.m_252907_());
            a.setLooped(this.loop);
            a.setOpacity(this.parent.f_93625_);
            a.render(graphics);
            a.setWidth(cachedW);
            a.setHeight(cachedH);
            a.setPosX(cachedX);
            a.setPosY(cachedY);
            a.setLooped(cachedLoop);
            a.setOpacity(1.0f);
        }

        @NotNull
        protected IAnimationRenderer getBackgroundAnimation() {
            if (!this.parent.f_93623_ && this.backgroundAnimationInactive != null) {
                return this.backgroundAnimationInactive;
            }
            if (this.parent.f_93622_ && this.parent.m_142518_() && this.backgroundAnimationHover != null) {
                return this.backgroundAnimationHover;
            }
            return this.backgroundAnimationNormal;
        }

        @Nullable
        public IAnimationRenderer getBackgroundAnimationInactive() {
            return this.backgroundAnimationInactive;
        }

        public AnimationButtonBackground setBackgroundAnimationInactive(@Nullable IAnimationRenderer backgroundAnimationInactive) {
            this.backgroundAnimationInactive = backgroundAnimationInactive;
            return this;
        }

        @NotNull
        public IAnimationRenderer getBackgroundAnimationNormal() {
            return this.backgroundAnimationNormal;
        }

        public AnimationButtonBackground setBackgroundAnimationNormal(@NotNull IAnimationRenderer backgroundAnimationNormal) {
            this.backgroundAnimationNormal = backgroundAnimationNormal;
            return this;
        }

        @Nullable
        public IAnimationRenderer getBackgroundAnimationHover() {
            return this.backgroundAnimationHover;
        }

        public AnimationButtonBackground setBackgroundAnimationHover(@Nullable IAnimationRenderer backgroundAnimationHover) {
            this.backgroundAnimationHover = backgroundAnimationHover;
            return this;
        }

        public boolean isLooped() {
            return this.loop;
        }

        public AnimationButtonBackground setLooped(boolean loop) {
            this.loop = loop;
            return this;
        }

        public boolean isRestartOnHover() {
            return this.restartOnHover;
        }

        public AnimationButtonBackground setRestartOnHover(boolean restartOnHover) {
            this.restartOnHover = restartOnHover;
            return this;
        }
    }

    public static class ImageButtonBackground
    extends ButtonBackground {
        @NotNull
        protected ResourceLocation backgroundTextureNormal;
        @Nullable
        protected ResourceLocation backgroundTextureHover;
        @Nullable
        protected ResourceLocation backgroundTextureInactive;

        public static ImageButtonBackground create(@NotNull ResourceLocation backgroundTextureNormal) {
            return new ImageButtonBackground(backgroundTextureNormal, null, null);
        }

        public static ImageButtonBackground create(@NotNull ResourceLocation backgroundTextureNormal, @Nullable ResourceLocation backgroundTextureHover) {
            return new ImageButtonBackground(backgroundTextureNormal, backgroundTextureHover, null);
        }

        public static ImageButtonBackground create(@NotNull ResourceLocation backgroundTextureNormal, @Nullable ResourceLocation backgroundTextureHover, @Nullable ResourceLocation backgroundTextureInactive) {
            return new ImageButtonBackground(backgroundTextureNormal, backgroundTextureHover, backgroundTextureInactive);
        }

        public ImageButtonBackground(@NotNull ResourceLocation backgroundTextureNormal, @Nullable ResourceLocation backgroundTextureHover, @Nullable ResourceLocation backgroundTextureInactive) {
            this.backgroundTextureNormal = backgroundTextureNormal;
            this.backgroundTextureHover = backgroundTextureHover;
            this.backgroundTextureInactive = backgroundTextureInactive;
        }

        @Override
        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.parent.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            graphics.m_280163_(this.getBackgroundTexture(), this.parent.m_252754_(), this.parent.m_252907_(), 0.0f, 0.0f, this.parent.m_5711_(), this.parent.m_93694_(), this.parent.m_5711_(), this.parent.m_93694_());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onHover() {
        }

        @Override
        public void onEndHover() {
        }

        @NotNull
        protected ResourceLocation getBackgroundTexture() {
            if (!this.parent.f_93623_ && this.backgroundTextureInactive != null) {
                return this.backgroundTextureInactive;
            }
            if (this.parent.f_93622_ && this.parent.m_142518_() && this.backgroundTextureHover != null) {
                return this.backgroundTextureHover;
            }
            return this.backgroundTextureNormal;
        }

        @Nullable
        public ResourceLocation getBackgroundTextureInactive() {
            return this.backgroundTextureInactive;
        }

        public ImageButtonBackground setBackgroundTextureInactive(@Nullable ResourceLocation backgroundTextureInactive) {
            this.backgroundTextureInactive = backgroundTextureInactive;
            return this;
        }

        @NotNull
        public ResourceLocation getBackgroundTextureNormal() {
            return this.backgroundTextureNormal;
        }

        public ImageButtonBackground setBackgroundTextureNormal(@NotNull ResourceLocation backgroundTextureNormal) {
            this.backgroundTextureNormal = backgroundTextureNormal;
            return this;
        }

        @Nullable
        public ResourceLocation getBackgroundTextureHover() {
            return this.backgroundTextureHover;
        }

        public ImageButtonBackground setBackgroundTextureHover(@Nullable ResourceLocation backgroundTextureHover) {
            this.backgroundTextureHover = backgroundTextureHover;
            return this;
        }
    }

    public static class ColorButtonBackground
    extends ButtonBackground {
        @NotNull
        protected DrawableColor backgroundColorNormal;
        @Nullable
        protected DrawableColor backgroundColorHover;
        @Nullable
        protected DrawableColor backgroundColorInactive;
        @Nullable
        protected DrawableColor backgroundColorBorderNormal;
        @Nullable
        protected DrawableColor backgroundColorBorderHover;
        @Nullable
        protected DrawableColor backgroundColorBorderInactive;
        protected int borderThickness;

        public static ColorButtonBackground create(@NotNull DrawableColor backgroundColorNormal) {
            return new ColorButtonBackground(backgroundColorNormal, null, null, null, null, null, 1);
        }

        public static ColorButtonBackground create(@NotNull DrawableColor backgroundColorNormal, @Nullable DrawableColor backgroundColorHover, @Nullable DrawableColor backgroundColorBorderNormal, @Nullable DrawableColor backgroundColorBorderHover) {
            return new ColorButtonBackground(backgroundColorNormal, backgroundColorHover, null, backgroundColorBorderNormal, backgroundColorBorderHover, null, 1);
        }

        public static ColorButtonBackground create(@NotNull DrawableColor backgroundColorNormal, @Nullable DrawableColor backgroundColorHover, @Nullable DrawableColor backgroundColorBorderNormal, @Nullable DrawableColor backgroundColorBorderHover, int borderThickness) {
            return new ColorButtonBackground(backgroundColorNormal, backgroundColorHover, null, backgroundColorBorderNormal, backgroundColorBorderHover, null, borderThickness);
        }

        public static ColorButtonBackground create(@NotNull DrawableColor backgroundColorNormal, @Nullable DrawableColor backgroundColorHover, @Nullable DrawableColor backgroundColorInactive, @Nullable DrawableColor backgroundColorBorderNormal, @Nullable DrawableColor backgroundColorBorderHover, @Nullable DrawableColor backgroundColorBorderInactive) {
            return new ColorButtonBackground(backgroundColorNormal, backgroundColorHover, backgroundColorInactive, backgroundColorBorderNormal, backgroundColorBorderHover, backgroundColorBorderInactive, 1);
        }

        public static ColorButtonBackground create(@NotNull DrawableColor backgroundColorNormal, @Nullable DrawableColor backgroundColorHover, @Nullable DrawableColor backgroundColorInactive, @Nullable DrawableColor backgroundColorBorderNormal, @Nullable DrawableColor backgroundColorBorderHover, @Nullable DrawableColor backgroundColorBorderInactive, int borderThickness) {
            return new ColorButtonBackground(backgroundColorNormal, backgroundColorHover, backgroundColorInactive, backgroundColorBorderNormal, backgroundColorBorderHover, backgroundColorBorderInactive, borderThickness);
        }

        public ColorButtonBackground(@NotNull DrawableColor backgroundColorNormal, @Nullable DrawableColor backgroundColorHover, @Nullable DrawableColor backgroundColorInactive, @Nullable DrawableColor backgroundColorBorderNormal, @Nullable DrawableColor backgroundColorBorderHover, @Nullable DrawableColor backgroundColorBorderInactive, int borderThickness) {
            this.backgroundColorNormal = backgroundColorNormal;
            this.backgroundColorHover = backgroundColorHover;
            this.backgroundColorInactive = backgroundColorInactive;
            this.backgroundColorBorderNormal = backgroundColorBorderNormal;
            this.backgroundColorBorderHover = backgroundColorBorderHover;
            this.backgroundColorBorderInactive = backgroundColorBorderInactive;
            this.borderThickness = borderThickness;
        }

        @Override
        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.parent.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            this.renderColorBackground(graphics);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onHover() {
        }

        @Override
        public void onEndHover() {
        }

        protected void renderColorBackground(GuiGraphics graphics) {
            int w = this.parent.m_5711_() - this.borderThickness * 2;
            int h = this.parent.m_93694_() - this.borderThickness * 2;
            graphics.m_280509_(this.parent.m_252754_() + this.borderThickness, this.parent.m_252907_() + this.borderThickness, this.parent.m_252754_() + this.borderThickness + w, this.parent.m_252907_() + this.borderThickness + h, this.getBackgroundColor().getColorIntWithAlpha(this.parent.f_93625_));
            UIBase.renderBorder(graphics.m_280168_(), this.parent.m_252754_(), this.parent.m_252907_(), this.parent.m_252754_() + this.parent.m_5711_(), this.parent.m_252907_() + this.parent.m_93694_(), this.borderThickness, this.getBorderColor().getColor(), true, true, true, true);
        }

        @NotNull
        protected DrawableColor getBorderColor() {
            if (!this.parent.f_93623_ && this.backgroundColorBorderInactive != null) {
                return this.backgroundColorBorderInactive;
            }
            if (this.parent.f_93622_ && this.parent.m_142518_()) {
                if (this.backgroundColorBorderHover != null) {
                    return this.backgroundColorBorderHover;
                }
                if (this.backgroundColorBorderNormal != null) {
                    return this.backgroundColorBorderNormal;
                }
                return this.getBackgroundColor();
            }
            if (this.backgroundColorBorderNormal != null) {
                return this.backgroundColorBorderNormal;
            }
            return this.getBackgroundColor();
        }

        @NotNull
        protected DrawableColor getBackgroundColor() {
            if (!this.parent.f_93623_ && this.backgroundColorInactive != null) {
                return this.backgroundColorInactive;
            }
            if (this.parent.f_93622_ && this.parent.m_142518_() && this.backgroundColorHover != null) {
                return this.backgroundColorHover;
            }
            return this.backgroundColorNormal;
        }

        @NotNull
        public DrawableColor getBackgroundColorNormal() {
            return this.backgroundColorNormal;
        }

        public ColorButtonBackground setBackgroundColorNormal(@NotNull DrawableColor backgroundColorNormal) {
            Objects.requireNonNull(backgroundColorNormal);
            this.backgroundColorNormal = backgroundColorNormal;
            return this;
        }

        @Nullable
        public DrawableColor getBackgroundColorInactive() {
            return this.backgroundColorInactive;
        }

        public ColorButtonBackground setBackgroundColorInactive(@Nullable DrawableColor backgroundColorInactive) {
            this.backgroundColorInactive = backgroundColorInactive;
            return this;
        }

        @Nullable
        public DrawableColor getBackgroundColorBorderInactive() {
            return this.backgroundColorBorderInactive;
        }

        public ColorButtonBackground setBackgroundColorBorderInactive(@Nullable DrawableColor backgroundColorBorderInactive) {
            this.backgroundColorBorderInactive = backgroundColorBorderInactive;
            return this;
        }

        @Nullable
        public DrawableColor getBackgroundColorHover() {
            return this.backgroundColorHover;
        }

        public ColorButtonBackground setBackgroundColorHover(@Nullable DrawableColor backgroundColorHover) {
            this.backgroundColorHover = backgroundColorHover;
            return this;
        }

        @Nullable
        public DrawableColor getBackgroundColorBorderNormal() {
            return this.backgroundColorBorderNormal;
        }

        public ColorButtonBackground setBackgroundColorBorderNormal(@Nullable DrawableColor backgroundColorBorderNormal) {
            this.backgroundColorBorderNormal = backgroundColorBorderNormal;
            return this;
        }

        @Nullable
        public DrawableColor getBackgroundColorBorderHover() {
            return this.backgroundColorBorderHover;
        }

        public ColorButtonBackground setBackgroundColorBorderHover(@Nullable DrawableColor backgroundColorBorderHover) {
            this.backgroundColorBorderHover = backgroundColorBorderHover;
            return this;
        }

        public int getBorderThickness() {
            return this.borderThickness;
        }

        public ColorButtonBackground setBorderThickness(int borderThickness) {
            this.borderThickness = borderThickness;
            return this;
        }
    }
}

