/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message.handshake;

import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.HandshakeMessage;
import com.mrcrayfish.framework.config.FrameworkConfigManager;
import java.util.concurrent.CountDownLatch;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class S2CLoginConfigData
extends HandshakeMessage<S2CLoginConfigData> {
    private ResourceLocation key;
    private byte[] data;

    public S2CLoginConfigData() {
    }

    public S2CLoginConfigData(ResourceLocation key, byte[] data) {
        this.key = key;
        this.data = data;
    }

    @Override
    public void encode(S2CLoginConfigData message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.key);
        buffer.m_130087_(message.data);
    }

    @Override
    public S2CLoginConfigData decode(FriendlyByteBuf buffer) {
        ResourceLocation key = buffer.m_130281_();
        byte[] data = buffer.m_130052_();
        return new S2CLoginConfigData(key, data);
    }

    @Override
    public void handle(S2CLoginConfigData message, MessageContext context) {
        Constants.LOG.debug("Received config data from server");
        CountDownLatch block = new CountDownLatch(1);
        context.execute(() -> {
            if (!FrameworkConfigManager.getInstance().processConfigData(message)) {
                context.getNetworkManager().m_129507_((Component)Component.m_237115_((String)"configured.gui.handshake_process_failed"));
            }
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        context.setHandled(true);
        context.reply(new HandshakeMessage.Acknowledge());
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public byte[] getData() {
        return this.data;
    }
}

